/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BPriAlmHisHistoryRecord;
import com.tridium.tls.datatypes.BPriorityAlarmHistoryEntry;
import com.tridium.tls.datatypes.BPriorityAlarmHistoryTable;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.TlsConsolePriorityAlarmHistoryReport;
import com.tridium.tls.messages.TlsConsolePriorityAlarmHistoryReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350ConsoleDevicePointDeviceExt;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350PahDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="minimumPollInterval", type="BRelTime", defaultValue="BRelTime.makeMinutes(2)"), @NiagaraProperty(name="priorityAlarmHistoryTable", type="BPriorityAlarmHistoryTable", defaultValue="new BPriorityAlarmHistoryTable()", flags=257), @NiagaraProperty(name="maxOldEntriesSaved", type="int", defaultValue="16", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")})})
@NiagaraAction(name="purgeHashtable", flags=4)
@NiagaraTopic(name="newAlarmNotify")
public class BTls350PriAlmHisProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    @Generated
    public static final Property minimumPollInterval = BTls350PriAlmHisProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), null);
    @Generated
    public static final Property priorityAlarmHistoryTable = BTls350PriAlmHisProxyExt.newProperty((int)257, (BValue)new BPriorityAlarmHistoryTable(), null);
    @Generated
    public static final Property maxOldEntriesSaved = BTls350PriAlmHisProxyExt.newProperty((int)0, (int)16, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Action purgeHashtable = BTls350PriAlmHisProxyExt.newAction((int)4, null);
    @Generated
    public static final Topic newAlarmNotify = BTls350PriAlmHisProxyExt.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTls350PriAlmHisProxyExt.class);
    private Vector<BPriorityAlarmHistoryEntry> pAHEntriesVector;
    private Hashtable<Long, BPriorityAlarmHistoryEntry> pAHHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;

    @Generated
    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    @Generated
    public void setMinimumPollInterval(BRelTime v) {
        this.set(minimumPollInterval, (BValue)v, null);
    }

    @Generated
    public BPriorityAlarmHistoryTable getPriorityAlarmHistoryTable() {
        return (BPriorityAlarmHistoryTable)this.get(priorityAlarmHistoryTable);
    }

    @Generated
    public void setPriorityAlarmHistoryTable(BPriorityAlarmHistoryTable v) {
        this.set(priorityAlarmHistoryTable, (BValue)v, null);
    }

    @Generated
    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    @Generated
    public void setMaxOldEntriesSaved(int v) {
        this.setInt(maxOldEntriesSaved, v, null);
    }

    @Generated
    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    @Generated
    public void fireNewAlarmNotify(BValue event) {
        this.fire(newAlarmNotify, event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getDeviceExtType() {
        return BTls350ConsoleDevicePointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BPriorityAlarmHistoryEntry[] saved = this.getPriorityAlarmHistoryTable().getEntries();
            this.pAHHashtable = new Hashtable(saved.length * 2);
            for (int i = 0; i < saved.length; ++i) {
                Long key = saved[i].getValueHashCode();
                this.pAHHashtable.put(key, saved[i]);
            }
            TlsHistoryHelper.initHistory(BPriAlmHisHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.pAHHashtable = null;
        super.stopped();
    }

    @Override
    public void poll() {
        if (!(this.getDevice().getEnabled() && this.getEnabled() && this.pollIntervalCheck(this.getMinimumPollInterval().getMillis()))) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        boolean pollDebug = this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1;
        boolean pollDebugSkip = this.isTraceOn() && this.device().getUserData().indexOf("skip") != -1;
        TlsConsolePriorityAlarmHistoryReport req = new TlsConsolePriorityAlarmHistoryReport(this);
        TlsConsolePriorityAlarmHistoryReportResponse rsp = (TlsConsolePriorityAlarmHistoryReportResponse)this.network().sendSync(req);
        if (rsp != null) {
            if (rsp.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                TlsConsolePriorityAlarmHistoryReportResponse.PriorityAlarmHistory[] entries = rsp.getPriorityAlarmHistoryEntries();
                if (entries == null || entries.length <= 0) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit... response has no entries");
                    }
                    return;
                }
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow continue... process " + entries.length + " entries");
                }
                this.pAHEntriesVector = new Vector();
                boolean newEntryDetected = false;
                for (int i = entries.length - 1; i > -1; --i) {
                    String storeName = Sys.getStation().getStationName();
                    BAbsTime dateTimeRetrieved = entries[i].getDateTimeRetrieved();
                    int alarmWarningCategory = entries[i].getAlarmWarningCategory();
                    int sensorCategory = entries[i].getSensorCategory();
                    int alarmType = entries[i].getAlarmTypeNumber();
                    int tankSensorNumber = entries[i].getTankSensorNumber();
                    int alarmState = entries[i].getAlarmState();
                    BAbsTime dateTimeOccurred = entries[i].getDateTimeOccurred();
                    BPriorityAlarmHistoryEntry newPahEntry = new BPriorityAlarmHistoryEntry(storeName, dateTimeRetrieved, alarmWarningCategory, sensorCategory, alarmType, tankSensorNumber, alarmState, dateTimeOccurred);
                    BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (newPahEntry.getDateTimeOccurred().isBefore(previousTime)) {
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newPahEntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    if (!newPahEntry.getDateTimeOccurred().isBefore(newPahEntry.getDateTimeRetrieved())) {
                        if (!pollDebugSkip) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... potential incomplete entry = " + newPahEntry.createCommaDelimitedString() + " for " + this.getName());
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " millis rcvDT/occDT= " + newPahEntry.getDateTimeRetrieved().getMillis() + "/" + newPahEntry.getDateTimeOccurred().getMillis());
                        continue;
                    }
                    if (pollDebugSkip) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow not skipped... entry = " + newPahEntry.createCommaDelimitedString() + " for " + this.getName());
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " millis rcvDT/occDT= " + newPahEntry.getDateTimeRetrieved().getMillis() + "/" + newPahEntry.getDateTimeOccurred().getMillis());
                    }
                    Long newHtKey = newPahEntry.getValueHashCode();
                    if (this.pAHHashtable == null || this.pAHHashtable.get(newHtKey) == null || newEntryDetected) {
                        this.pAHHashtable.put(newHtKey, newPahEntry);
                        this.pAHEntriesVector.addElement(newPahEntry);
                        newEntryDetected = true;
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + newPahEntry.createCommaDelimitedString());
                        continue;
                    }
                    if (!pollDebug) continue;
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newPahEntry.createCommaDelimitedString());
                }
                if (this.pAHEntriesVector.size() > 0) {
                    this.setValue(this.pAHEntriesVector);
                    return;
                }
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)sv);
                this.updateDemuxedProxyPoints();
            } else {
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector<BPriorityAlarmHistoryEntry> values) {
        BPriorityAlarmHistoryEntry[] valuesCopy = new BPriorityAlarmHistoryEntry[values.size()];
        values.copyInto((Object[])valuesCopy);
        BPriorityAlarmHistoryTable sendToCsMgrCopy = new BPriorityAlarmHistoryTable();
        for (int i = 0; i < valuesCopy.length; ++i) {
            try {
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                String newValue = valuesCopy[i].createCommaDelimitedString();
                sv.setValue(newValue);
                sv.setStatus(BStatus.ok);
                this.readOk((BStatusValue)sv);
                this.getPriorityAlarmHistoryTable().add("priorityAlarmHistoryEntry?", (BValue)valuesCopy[i]);
                sendToCsMgrCopy.add("priorityAlarmHistoryEntry?", (BValue)((BPriorityAlarmHistoryEntry)valuesCopy[i].newCopy()));
                this.fireNewAlarmNotify((BValue)((BPriorityAlarmHistoryEntry)valuesCopy[i].newCopy()));
                BPriAlmHisHistoryRecord newrec = new BPriAlmHisHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), valuesCopy[i]);
                TlsHistoryHelper.appendTlsHistory((BStruct)newrec);
                if (!this.isTraceOn() || this.device().getUserData().indexOf("poll") == -1) continue;
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + newValue);
                continue;
            }
            catch (Exception e) {
                this.readFail(e.toString());
            }
        }
        this.updateDemuxedProxyPoints();
        BPriorityAlarmHistoryEntry[] sortedValues = this.getPriorityAlarmHistoryTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        int numRemoveEntries = sortedValues.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350PriAlmHisProxyExt setValue sortedValues.length=" + sortedValues.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (numRemoveEntries > 0) {
            Vector<BPriorityAlarmHistoryEntry> removeEntries = new Vector<BPriorityAlarmHistoryEntry>();
            for (int i = 0; i < numRemoveEntries; ++i) {
                removeEntries.addElement(sortedValues[i]);
            }
            Enumeration re = removeEntries.elements();
            while (re.hasMoreElements()) {
                BPriorityAlarmHistoryEntry oldestEntryCopy = (BPriorityAlarmHistoryEntry)((Object)re.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350PriAlmHisProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + oldestEntryCopy.createCommaDelimitedString());
                }
                this.getPriorityAlarmHistoryTable().remove((BComplex)oldestEntryCopy);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, sendToCsMgrCopy));
    }

    private void updateDemuxedProxyPoints() {
        BPriorityAlarmHistoryEntry[] sortedValues = this.getPriorityAlarmHistoryTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        BPriorityAlarmHistoryEntry mostRecentValue = sortedValues[sortedValues.length - 1];
        String[] demuxedValueStrings = CsMgrBaseUtil.createStringArrayOfAllNames((String)mostRecentValue.createCommaDelimitedString());
        if (demuxedValueStrings != null && demuxedValueStrings.length > 0) {
            BControlPoint[] dCPA;
            BTls350PahDemuxedPointDeviceExt pahdExt = null;
            BDeviceExt[] exts = this.getDevice().getDeviceExts();
            for (int k = 0; k < exts.length; ++k) {
                if (!(exts[k] instanceof BTls350PahDemuxedPointDeviceExt)) continue;
                pahdExt = (BTls350PahDemuxedPointDeviceExt)exts[k];
                break;
            }
            if (pahdExt != null && (dCPA = pahdExt.getPoints()) != null && dCPA.length > 0) {
                for (int k = 0; k < dCPA.length; ++k) {
                    if (dCPA[k].getProxyExt().getType() != BTls350DemuxedProxyExt.TYPE) continue;
                    ((BTls350DemuxedProxyExt)dCPA[k].getProxyExt()).updateValueFrom(demuxedValueStrings);
                }
            }
        }
    }

    @Override
    public void readDataNow() {
        this.pollForDataNow();
    }

    @Override
    public void clearDataNow() {
        this.getPriorityAlarmHistoryTable().lease(2);
        BPriorityAlarmHistoryEntry[] pahe = (BPriorityAlarmHistoryEntry[])this.getPriorityAlarmHistoryTable().getChildren(BPriorityAlarmHistoryEntry.class);
        if (pahe != null && pahe.length > 0) {
            for (int i = 0; i < pahe.length; ++i) {
                this.getPriorityAlarmHistoryTable().remove((BComplex)pahe[i]);
            }
        }
        this.pAHHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context cx) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration<Long> pAHkeys = this.pAHHashtable.keys();
        while (pAHkeys.hasMoreElements()) {
            Long nextKey = pAHkeys.nextElement();
            BPriorityAlarmHistoryEntry nextEntry = this.pAHHashtable.get(nextKey);
            BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!nextEntry.getDateTimeOccurred().isBefore(previousTime)) continue;
            this.pAHHashtable.remove(nextKey);
        }
        this.reschedPurgeHashtable();
    }

    private void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime nextChangeOfDay = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)nextChangeOfDay, (Action)purgeHashtable, null);
    }
}

