/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BInvReconcileRowEntry;
import com.tridium.tls.datatypes.BInvReconcileRowRecord;
import com.tridium.tls.datatypes.BInvReconcileRowTable;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350InvReconcileReport;
import com.tridium.tls.messages.Tls350InvReconcileReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350ConsoleDevicePointDeviceExt;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350IrrDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="productNumber", type="int", defaultValue="0", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="minimumPollInterval", type="BRelTime", defaultValue="BRelTime.makeMinutes(2)"), @NiagaraProperty(name="invReconcileRowTable", type="BInvReconcileRowTable", defaultValue="new BInvReconcileRowTable()"), @NiagaraProperty(name="maxOldEntriesSaved", type="int", defaultValue="8", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")})})
@NiagaraAction(name="purgeHashtable", flags=4)
public class BTls350InvReconcileReportProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    @Generated
    public static final Property productNumber = BTls350InvReconcileReportProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property minimumPollInterval = BTls350InvReconcileReportProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), null);
    @Generated
    public static final Property invReconcileRowTable = BTls350InvReconcileReportProxyExt.newProperty((int)0, (BValue)new BInvReconcileRowTable(), null);
    @Generated
    public static final Property maxOldEntriesSaved = BTls350InvReconcileReportProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Action purgeHashtable = BTls350InvReconcileReportProxyExt.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTls350InvReconcileReportProxyExt.class);
    private Vector<BInvReconcileRowEntry> iRREntriesVector;
    private Hashtable<Long, BInvReconcileRowEntry> iRRHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;

    @Generated
    public int getProductNumber() {
        return this.getInt(productNumber);
    }

    @Generated
    public void setProductNumber(int v) {
        this.setInt(productNumber, v, null);
    }

    @Generated
    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    @Generated
    public void setMinimumPollInterval(BRelTime v) {
        this.set(minimumPollInterval, (BValue)v, null);
    }

    @Generated
    public BInvReconcileRowTable getInvReconcileRowTable() {
        return (BInvReconcileRowTable)this.get(invReconcileRowTable);
    }

    @Generated
    public void setInvReconcileRowTable(BInvReconcileRowTable v) {
        this.set(invReconcileRowTable, (BValue)v, null);
    }

    @Generated
    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    @Generated
    public void setMaxOldEntriesSaved(int v) {
        this.setInt(maxOldEntriesSaved, v, null);
    }

    @Generated
    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getDeviceExtType() {
        return BTls350ConsoleDevicePointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BInvReconcileRowEntry[] saved = this.getInvReconcileRowTable().getEntries();
            this.iRRHashtable = new Hashtable(saved.length * 2);
            for (int i = 0; i < saved.length; ++i) {
                Long key = saved[i].getHTKey();
                this.iRRHashtable.put(key, saved[i]);
            }
            TlsHistoryHelper.initHistory(BInvReconcileRowRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.iRRHashtable = null;
        super.stopped();
    }

    @Override
    public void poll() {
        if (!(this.getDevice().getEnabled() && this.getEnabled() && this.pollIntervalCheck(this.getMinimumPollInterval().getMillis()))) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        boolean pollDebug = this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1;
        int productNumber = this.getProductNumber();
        Tls350InvReconcileReport req = new Tls350InvReconcileReport(productNumber, this);
        Tls350InvReconcileReportResponse rsp = (Tls350InvReconcileReportResponse)this.network().sendSync(req);
        if (rsp != null) {
            if (rsp.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                Tls350InvReconcileReportResponse.InvReconcileRecordEntry[] entries = rsp.getInvReconcileRecordEntries();
                if (entries == null || entries.length <= 0) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit... response has no entries");
                    }
                    return;
                }
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow continue... process " + entries.length + " entries");
                }
                if (productNumber == 0) {
                    System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!!  product number not initialized... initialize product number to valid product\n\n");
                    return;
                }
                if (productNumber != entries[0].getProductNumber()) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong product number... entry for productNumber=" + entries[0].getProductNumber() + " may be lost\n\n");
                    }
                    return;
                }
                this.iRREntriesVector = new Vector();
                boolean newEntryDetected = false;
                for (int i = entries.length - 1; i > -1; --i) {
                    BInvReconcileRowEntry newIRREntry = new BInvReconcileRowEntry();
                    newIRREntry.setStore(Sys.getStation().getStationName());
                    newIRREntry.setProductNumber(productNumber);
                    newIRREntry.setNumberTanks(entries[i].getNumberTanks());
                    newIRREntry.setTanks(entries[i].getTanks());
                    newIRREntry.setOpenningTime(entries[i].getOpenningTime());
                    newIRREntry.setClosingTime(entries[i].getClosingTime());
                    newIRREntry.setInvAtPrevClose(entries[i].getInvAtPrevClose());
                    newIRREntry.setSumTotAdjDel(entries[i].getSumTotAdjDel());
                    newIRREntry.setSumTotMeteredSales(entries[i].getSumTotMeteredSales());
                    newIRREntry.setManAdjForPer(entries[i].getManAdjForPer());
                    newIRREntry.setCalcInvCurPer(entries[i].getCalcInvCurPer());
                    newIRREntry.setProbeMeasInvCurPer(entries[i].getProbeMeasInvCurPer());
                    newIRREntry.setWaterLevCurPer(entries[i].getWaterLevCurPer());
                    newIRREntry.setProbeCalcInvVar(entries[i].getProbeCalcInvVar());
                    BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (newIRREntry.getClosingTime().isBefore(previousTime)) {
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newIRREntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    Long newHtKey = newIRREntry.getHTKey();
                    if (this.iRRHashtable == null || this.iRRHashtable.get(newHtKey) == null || newEntryDetected) {
                        this.iRRHashtable.put(newHtKey, newIRREntry);
                        this.iRREntriesVector.addElement(newIRREntry);
                        newEntryDetected = true;
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + newIRREntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    if (!pollDebug) continue;
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newIRREntry.createCommaDelimitedString() + " for " + this.getName());
                }
                if (this.iRREntriesVector.size() > 0) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... new entries for setValue() to process  = " + this.iRREntriesVector.size());
                    }
                    this.setValue(this.iRREntriesVector);
                    return;
                }
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)sv);
                this.updateDemuxedProxyPoints();
            } else {
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector<BInvReconcileRowEntry> values) {
        BInvReconcileRowEntry[] valuesCopy = new BInvReconcileRowEntry[values.size()];
        values.copyInto((Object[])valuesCopy);
        BInvReconcileRowTable sendToCsMgrCopy = new BInvReconcileRowTable();
        for (int i = 0; i < valuesCopy.length; ++i) {
            try {
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                String newValue = valuesCopy[i].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + newValue);
                }
                sv.setValue(newValue);
                this.readOk((BStatusValue)sv);
                this.getInvReconcileRowTable().add("invReconcileRowEntry?", (BValue)valuesCopy[i]);
                sendToCsMgrCopy.add("invReconcileRowEntry?", (BValue)((BInvReconcileRowEntry)valuesCopy[i].newCopy()));
                BInvReconcileRowRecord newrec = new BInvReconcileRowRecord(BAbsTime.make((long)System.currentTimeMillis()), valuesCopy[i]);
                TlsHistoryHelper.appendTlsHistory((BStruct)newrec);
                continue;
            }
            catch (Exception e) {
                this.readFail(e.toString());
            }
        }
        this.updateDemuxedProxyPoints();
        BInvReconcileRowEntry[] sortedValues = this.getInvReconcileRowTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        int numRemoveEntries = sortedValues.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350InvReconcileReportProxyExt setValue sortedValues.length=" + sortedValues.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (numRemoveEntries > 0) {
            Vector<BInvReconcileRowEntry> removeEntries = new Vector<BInvReconcileRowEntry>();
            for (int i = 0; i < numRemoveEntries; ++i) {
                removeEntries.addElement(sortedValues[i]);
            }
            Enumeration re = removeEntries.elements();
            while (re.hasMoreElements()) {
                BInvReconcileRowEntry oldestEntryCopy = (BInvReconcileRowEntry)((Object)re.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350InvReconcileReportProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + oldestEntryCopy.createCommaDelimitedString());
                }
                this.getInvReconcileRowTable().remove((BComplex)oldestEntryCopy);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, sendToCsMgrCopy));
    }

    private void updateDemuxedProxyPoints() {
        BInvReconcileRowEntry[] sortedValues = this.getInvReconcileRowTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        BInvReconcileRowEntry mostRecentValue = sortedValues[sortedValues.length - 1];
        String[] demuxedValueStrings = CsMgrBaseUtil.createStringArrayOfAllNames((String)mostRecentValue.createCommaDelimitedString());
        if (demuxedValueStrings != null && demuxedValueStrings.length > 0) {
            BControlPoint[] dCPA;
            for (int k = 0; k < demuxedValueStrings.length; ++k) {
                if (!this.isTraceOn() || this.device().getUserData().indexOf("demux") == -1) continue;
                this.getLog().trace("BTls350IRRProxyExt updateDemuxedProxyPoints demuxedValueStrings[" + k + "]=" + demuxedValueStrings[k]);
            }
            BTls350IrrDemuxedPointDeviceExt irrExt = null;
            BDeviceExt[] exts = this.getDevice().getDeviceExts();
            for (int k = 0; k < exts.length; ++k) {
                if (!(exts[k] instanceof BTls350IrrDemuxedPointDeviceExt)) continue;
                irrExt = (BTls350IrrDemuxedPointDeviceExt)exts[k];
                break;
            }
            if (irrExt != null && (dCPA = irrExt.getPoints()) != null && dCPA.length > 0) {
                if (this.isTraceOn() && this.device().getUserData().indexOf("demux") != -1) {
                    this.getLog().trace("BTls350InvReconcileReportProxyExt setValue dCPA.length=" + dCPA.length);
                }
                for (int k = 0; k < dCPA.length; ++k) {
                    if (dCPA[k].getProxyExt().getType() != BTls350DemuxedProxyExt.TYPE) continue;
                    ((BTls350DemuxedProxyExt)dCPA[k].getProxyExt()).updateValueFrom(demuxedValueStrings);
                }
            }
        }
    }

    @Override
    public void readDataNow() {
        this.pollForDataNow();
    }

    @Override
    public void clearDataNow() {
        this.getInvReconcileRowTable().lease(2);
        BInvReconcileRowEntry[] irre = (BInvReconcileRowEntry[])this.getInvReconcileRowTable().getChildren(BInvReconcileRowEntry.class);
        if (irre != null && irre.length > 0) {
            for (int i = 0; i < irre.length; ++i) {
                this.getInvReconcileRowTable().remove((BComplex)irre[i]);
            }
        }
        this.iRRHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context cx) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration<Long> iRRkeys = this.iRRHashtable.keys();
        while (iRRkeys.hasMoreElements()) {
            Long nextKey = iRRkeys.nextElement();
            BInvReconcileRowEntry nextEntry = this.iRRHashtable.get(nextKey);
            BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!nextEntry.getClosingTime().isBefore(previousTime)) continue;
            this.iRRHashtable.remove(nextKey);
        }
        this.reschedPurgeHashtable();
    }

    private void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime nextChangeOfDay = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)nextChangeOfDay, (Action)purgeHashtable, null);
    }
}

