/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350InTankStaProxyExt;
import com.tridium.tls.util.TlsUtil;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;

public class Tls350StatusReportResponse
extends Tls350Response
implements TlsMessageConst {
    public int messageTank;
    public BAbsTime readTime;
    public int numAlarms;
    public int[] alarmTypes;
    private BTls350InTankStaProxyExt ext;
    private boolean debug;

    public Tls350StatusReportResponse() {
    }

    public Tls350StatusReportResponse(BTls350InTankStaProxyExt ext) {
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    public BAbsTime getReadTime() {
        return this.readTime;
    }

    public int getMessageTank() {
        return this.messageTank;
    }

    public int getNumAlarms() {
        return this.numAlarms;
    }

    public int[] getAlarmTypes() {
        if (this.debug) {
            this.ext.getLog().trace("TlsStaResponse :readResponse alarmTypes.length=" + this.alarmTypes.length);
        }
        return this.alarmTypes;
    }

    @Override
    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = super.readResponse(message);
        if (this.debug) {
            this.ext.getLog().trace("TlsStaResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (inStream.available() < 16 || !this.functionCode.equalsIgnoreCase("205")) {
            this.alarmTypes = new int[0];
            this.messageTank = this.tank;
            return inStream;
        }
        this.readTime = inStream.readDateTime(true);
        boolean readResponseDone = false;
        while (!readResponseDone) {
            inStream.mark(0);
            String dataTerminationTest = inStream.readString(2);
            if (dataTerminationTest.equals("&&")) {
                this.alarmTypes = new int[0];
                this.messageTank = this.tank;
                return inStream;
            }
            inStream.reset();
            if (inStream.available() < 8) {
                this.alarmTypes = new int[0];
                this.messageTank = this.tank;
                return inStream;
            }
            this.messageTank = inStream.readAsciiInt(2);
            String numAlarmsStr = inStream.readString(2);
            try {
                this.numAlarms = Integer.parseInt(numAlarmsStr, 16);
            }
            catch (NumberFormatException nfe) {
                System.out.println("StatusReportResponse could not convert numAlarmsStr from str-hex-int... numAlarmsStr=" + numAlarmsStr);
                return inStream;
            }
            if (this.numAlarms == 0) {
                this.alarmTypes = new int[0];
                return inStream;
            }
            String tmpStr = "";
            this.alarmTypes = new int[this.numAlarms];
            for (int i = 0; i < this.numAlarms; ++i) {
                this.alarmTypes[i] = inStream.readAsciiInt(2);
                tmpStr = i == 0 ? "" + this.alarmTypes[i] : tmpStr + ", " + this.alarmTypes[i];
                if (!this.debug) continue;
                this.ext.getLog().trace("TlsStaResponse :readResponse nextEntry=" + tmpStr);
            }
            readResponseDone = true;
        }
        return inStream;
    }

    public String createCommaDelimitedString() {
        String sb = "" + Sys.getStation().getStationName() + "," + Integer.toString(this.getMessageTank()) + "," + this.getReadTime().toString() + "," + Integer.toString(this.getNumAlarms());
        for (int i = 0; i < this.alarmTypes.length; ++i) {
            sb = sb + "," + TlsUtil.getAlarmTypeString(this.getAlarmTypes()[i]);
        }
        return sb;
    }
}

