/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350InTankInvProxyExt;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;

public class Tls350InventoryReportResponse
extends Tls350Response {
    public static final int STATUS_DELIVERY_IN_PROCESS = 1;
    public static final int STATUS_LEAK_TEST_IN_PROCESS = 2;
    public static final int STATUS_INVALID_FUEL_HEIGHT = 4;
    public BAbsTime readTime;
    public int statusBits = 0;
    public String product;
    public int messageTank = 0;
    public int numValues = 0;
    public float volume = Float.NaN;
    public float tcVolume = Float.NaN;
    public float ullage = Float.NaN;
    public float fuelLevel = Float.NaN;
    public float waterLevel = Float.NaN;
    public float temperature = Float.NaN;
    public float waterVolume = Float.NaN;
    private BTls350InTankInvProxyExt ext;
    private boolean debug;
    private boolean debug_negative;

    public Tls350InventoryReportResponse() {
    }

    public Tls350InventoryReportResponse(BTls350InTankInvProxyExt ext) {
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
        this.debug_negative = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("negv") != -1;
    }

    @Override
    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = super.readResponse(message);
        if (this.debug) {
            this.ext.getLog().trace("TlsInvResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (inStream.available() < 16 || !this.functionCode.equalsIgnoreCase("201")) {
            this.messageTank = this.tank;
            return inStream;
        }
        this.readTime = inStream.readDateTime(true);
        boolean readResponseDone = false;
        while (!readResponseDone) {
            inStream.mark(0);
            String dataTerminationTest = inStream.readString(2);
            if (dataTerminationTest.equals("&&")) {
                this.messageTank = this.tank;
                return inStream;
            }
            inStream.reset();
            if (inStream.available() < 8) {
                this.messageTank = this.tank;
                return inStream;
            }
            this.messageTank = inStream.readAsciiInt(2);
            this.product = inStream.readString(1);
            this.statusBits = inStream.readAsciiInt(4);
            String numValuesStr = inStream.readString(2);
            try {
                this.numValues = Integer.parseInt(numValuesStr, 16);
            }
            catch (NumberFormatException nfe) {
                System.out.println("InventoryReportResponse could not convert numValuesStr from str-hex-int... numValuesStr=" + numValuesStr);
                return inStream;
            }
            if (this.numValues == 0) {
                return inStream;
            }
            String tmpStr = "";
            block12: for (int i = 0; i < this.numValues; ++i) {
                float flTemp = inStream.readAsciiFloat();
                if (flTemp < 0.0f && this.debug_negative) {
                    System.out.println("IRR (-) value=" + flTemp + " i=" + i);
                    System.out.println("IRR - ba=" + ByteArrayUtil.toHexString((byte[])message, (int)0, (int)message.length));
                }
                switch (i) {
                    case 0: {
                        this.volume = flTemp;
                        tmpStr = tmpStr + this.volume;
                        continue block12;
                    }
                    case 1: {
                        this.tcVolume = flTemp;
                        tmpStr = tmpStr + ", " + this.tcVolume;
                        continue block12;
                    }
                    case 2: {
                        this.ullage = flTemp;
                        tmpStr = tmpStr + ", " + this.ullage;
                        continue block12;
                    }
                    case 3: {
                        this.fuelLevel = flTemp;
                        tmpStr = tmpStr + ", " + this.fuelLevel;
                        continue block12;
                    }
                    case 4: {
                        this.waterLevel = flTemp;
                        tmpStr = tmpStr + ", " + this.waterLevel;
                        continue block12;
                    }
                    case 5: {
                        this.temperature = flTemp;
                        tmpStr = tmpStr + ", " + this.temperature;
                        continue block12;
                    }
                    case 6: {
                        this.waterVolume = flTemp;
                        tmpStr = tmpStr + ", " + this.waterVolume;
                    }
                }
            }
            if (this.debug) {
                this.ext.getLog().trace("TlsInvResponse :readResponse nextEntry=" + tmpStr);
            }
            readResponseDone = true;
        }
        return inStream;
    }

    public BAbsTime getReadTime() {
        return this.readTime;
    }

    public int getMessageTank() {
        return this.messageTank;
    }

    public String getProduct() {
        return this.product;
    }

    public boolean isDeliveryInProcess() {
        return (this.statusBits & 1) != 0;
    }

    public boolean isLeakTestInProcess() {
        return (this.statusBits & 2) != 0;
    }

    public boolean isInvalidFuelHeight() {
        return (this.statusBits & 4) != 0;
    }

    public float getVolume() {
        if (this.volume < 0.0f) {
            return 0.0f;
        }
        return this.volume;
    }

    public float getTcVolume() {
        if (this.tcVolume < 0.0f) {
            return 0.0f;
        }
        return this.tcVolume;
    }

    public float getUllage() {
        if (this.ullage < 0.0f) {
            return 0.0f;
        }
        return this.ullage;
    }

    public float getFuelLevel() {
        if (this.fuelLevel < 0.0f) {
            return 0.0f;
        }
        return this.fuelLevel;
    }

    public float getWaterLevel() {
        if (this.waterLevel < 0.0f) {
            return 0.0f;
        }
        return this.waterLevel;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getWaterVolume() {
        if (this.waterVolume < 0.0f) {
            return 0.0f;
        }
        return this.waterVolume;
    }
}

