/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350DelVarProxyExt;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;

public class Tls350DeliveryVarianceReportResponse
extends Tls350Response {
    public BAbsTime messageReadTime;
    public int messageTank = 0;
    public String messageProduct;
    public int messageProbe = 0;
    public int messageNumDeliveries = 0;
    public int messageNumValues = 0;
    public DeliveryVariance[] deliveries;
    private BTls350DelVarProxyExt ext;
    private boolean debug;

    public Tls350DeliveryVarianceReportResponse() {
    }

    public Tls350DeliveryVarianceReportResponse(BTls350DelVarProxyExt ext) {
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    public DeliveryVariance[] getDeliveryVariances() {
        if (this.debug) {
            this.ext.getLog().trace("TlsDVResponse :readResponse deliveries.length=" + this.deliveries.length);
        }
        return this.deliveries;
    }

    @Override
    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = super.readResponse(message);
        if (this.debug) {
            this.ext.getLog().trace("TlsDVResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (inStream.available() < 16 || !this.functionCode.equalsIgnoreCase("227")) {
            this.deliveries = new DeliveryVariance[0];
            this.messageTank = this.tank;
            return inStream;
        }
        this.messageReadTime = inStream.readDateTime(true);
        boolean readResponseDone = false;
        while (!readResponseDone) {
            inStream.mark(0);
            String dataTerminationTest = inStream.readString(2);
            if (dataTerminationTest.equals("&&")) {
                this.deliveries = new DeliveryVariance[0];
                this.messageTank = this.tank;
                return inStream;
            }
            inStream.reset();
            if (inStream.available() < 8) {
                this.deliveries = new DeliveryVariance[0];
                this.messageTank = this.tank;
                return inStream;
            }
            this.messageTank = inStream.readAsciiInt(2);
            this.messageProduct = inStream.readString(1);
            this.messageProbe = inStream.readAsciiInt(2);
            this.messageNumDeliveries = inStream.readAsciiInt(3);
            this.deliveries = new DeliveryVariance[this.messageNumDeliveries];
            for (int j = 0; j < this.messageNumDeliveries; ++j) {
                this.deliveries[j] = new DeliveryVariance();
                this.deliveries[j].setTankNumber(this.messageTank);
                this.deliveries[j].setProduct(this.messageProduct);
                this.deliveries[j].setProbe(this.messageProbe);
                this.deliveries[j].setDeliveryTime(inStream.readDateTime(true));
                String numValuesStr = inStream.readString(2);
                try {
                    this.messageNumValues = Integer.parseInt(numValuesStr, 16);
                }
                catch (NumberFormatException nfe) {
                    System.out.println("DeliveryVarianceReportResponse could not convert messageNumValues from str-hex-int... numValuesStr=" + numValuesStr);
                    return inStream;
                }
                for (int i = 0; i < this.messageNumValues; ++i) {
                    switch (i) {
                        case 0: {
                            this.deliveries[j].setTicketVolume(inStream.readAsciiFloat());
                            break;
                        }
                        case 1: {
                            this.deliveries[j].setGuagedVolume(inStream.readAsciiFloat());
                            break;
                        }
                        case 2: {
                            this.deliveries[j].setDeliveryVariance(inStream.readAsciiFloat());
                        }
                    }
                    if (!this.debug) continue;
                    this.ext.getLog().trace("TlsDVResponse :readResponse deliveries[" + j + "]=" + this.deliveries[j].getDVLogString());
                }
            }
            readResponseDone = true;
        }
        return inStream;
    }

    public class DeliveryVariance {
        int tankNumber;
        String product;
        int probe;
        BAbsTime deliveryTime;
        float ticketVolume = Float.NaN;
        float guagedVolume = Float.NaN;
        float deliveryVarance = Float.NaN;

        public void setTankNumber(int tn) {
            this.tankNumber = tn;
        }

        public void setProduct(String pd) {
            this.product = pd;
        }

        public void setProbe(int pb) {
            this.probe = pb;
        }

        public void setDeliveryTime(BAbsTime dt) {
            this.deliveryTime = dt;
        }

        public void setTicketVolume(float value) {
            this.ticketVolume = value;
        }

        public void setGuagedVolume(float value) {
            this.guagedVolume = value;
        }

        public void setDeliveryVariance(float value) {
            this.deliveryVarance = value;
        }

        public int getTankNumber() {
            return this.tankNumber;
        }

        public String getProduct() {
            return this.product;
        }

        public int getProbe() {
            return this.probe;
        }

        public BAbsTime getDeliveryTime() {
            return this.deliveryTime;
        }

        public float getTicketVolume() {
            return this.ticketVolume;
        }

        public float getGuagedVolume() {
            return this.guagedVolume;
        }

        public float getDeliveryVarance() {
            return this.deliveryVarance;
        }

        public String getDVLogString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.tankNumber);
            sb.append(", ");
            sb.append(this.product);
            sb.append(", ");
            sb.append(this.probe);
            sb.append(", ");
            sb.append(this.deliveryTime.toString(null));
            sb.append(", ");
            sb.append(this.ticketVolume);
            sb.append(", ");
            sb.append(this.guagedVolume);
            sb.append(", ");
            sb.append(this.deliveryVarance);
            return sb.toString();
        }
    }
}

