/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.Tls350DeliveryVarianceReportResponse;
import com.tridium.tls.messages.Tls350Message;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.messages.TlsReceivedMessage;
import com.tridium.tls.point.BTls350DelVarProxyExt;
import javax.baja.nre.util.ByteArrayUtil;

public class Tls350DeliveryVarianceReport
extends Tls350Message
implements TlsMessageConst {
    private BTls350DelVarProxyExt ext;
    private boolean debug;

    public Tls350DeliveryVarianceReport() {
    }

    public Tls350DeliveryVarianceReport(int tank) {
        super("227", tank);
    }

    public Tls350DeliveryVarianceReport(int tank, BTls350DelVarProxyExt ext) {
        super("227", tank);
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    @Override
    public Message toResponse(ReceivedMessage response) {
        TlsReceivedMessage rm = (TlsReceivedMessage)response;
        byte[] rmBytes = rm.getBytes();
        if (this.debug) {
            this.ext.getLog().trace("TlsDVReport :toResponse []=" + ByteArrayUtil.toHexString((byte[])rmBytes, (int)0, (int)rmBytes.length));
        }
        Tls350DeliveryVarianceReportResponse rsp = new Tls350DeliveryVarianceReportResponse(this.ext);
        rsp.readResponse(rmBytes);
        return rsp;
    }
}

