/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.devices;

import com.tridium.basicdriver.message.Message;
import com.tridium.tls.BTlsConsole;
import com.tridium.tls.BTlsDevice;
import com.tridium.tls.messages.Tls350StatusReport;
import com.tridium.tls.messages.Tls350StatusReportResponse;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="tankNumber", type="int", defaultValue="0", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="points", type="BTls350FuelTankPointDeviceExt", defaultValue="new BTls350FuelTankPointDeviceExt()")})
public class BTls350FuelTankDevice
extends BTlsDevice {
    @Generated
    public static final Property tankNumber = BTls350FuelTankDevice.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property points = BTls350FuelTankDevice.newProperty((int)0, (BValue)new BTls350FuelTankPointDeviceExt(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTls350FuelTankDevice.class);

    @Generated
    public int getTankNumber() {
        return this.getInt(tankNumber);
    }

    @Generated
    public void setTankNumber(int v) {
        this.setInt(tankNumber, v, null);
    }

    @Generated
    public BTls350FuelTankPointDeviceExt getPoints() {
        return (BTls350FuelTankPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BTls350FuelTankPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doPing() {
        if (this.pingForeignHardware()) {
            this.pingOk();
        } else {
            this.pingFail(this.getLexicon().getText("pingFail"));
        }
    }

    public boolean pingForeignHardware() {
        BTlsConsole network = this.network();
        boolean pingDebug = network.getLog().isTraceOn() && this.getUserData().indexOf("ping") != -1;
        String myId = network.getName() + "|" + this.getName();
        if (pingDebug) {
            network.getLog().trace("BTlsDevice entered ping method for " + myId);
        }
        if (!this.getMonitor().getPingEnabled()) {
            this.pollSinceLastPingFlag = false;
            if (pingDebug) {
                network.getLog().trace("BTlsDevice ping disabled.. ping skipped for " + myId);
            }
            return true;
        }
        if (this.pollSinceLastPingFlag) {
            this.pollSinceLastPingFlag = false;
            if (pingDebug) {
                network.getLog().trace("BTlsDevice ping skipped for " + myId);
            }
            return true;
        }
        int tankNumber = this.getTankNumber();
        if (tankNumber == 0) {
            network.getLog().trace("BTlsDevice ping skipped for " + myId + "... tankNumber not initiaized");
            return false;
        }
        Message rsp = network.sendSync(new Tls350StatusReport(tankNumber));
        if (rsp == null || !(rsp instanceof Tls350StatusReportResponse)) {
            if (pingDebug) {
                network.getLog().trace("BTlsDevice ping failed for " + myId);
            }
            return false;
        }
        if (pingDebug) {
            network.getLog().trace("BTlsDevice ping successful for " + myId);
        }
        return true;
    }
}

