/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.consoles;

import com.tridium.tls.BTlsConsole;
import com.tridium.tls.BTlsDevice;
import com.tridium.tls.BTlsDeviceFolder;
import com.tridium.tls.enums.BTlsCommTypeEnum;
import com.tridium.tls.messages.TlsMessageConst;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialHelper;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="interMessageDelay", type="BRelTime", defaultValue="BRelTime.make(0)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(0), BFacets.MAX, BRelTime.SECOND)")}), @NiagaraProperty(name="serialPortConfig", type="BSerialHelper", defaultValue="new BSerialHelper()"), @NiagaraProperty(name="commType", type="BTlsCommTypeEnum", defaultValue="BTlsCommTypeEnum.serial")})
public abstract class BTlsSerialConsole
extends BTlsConsole
implements BISerialHelperParent,
TlsMessageConst {
    @Generated
    public static final Property interMessageDelay = BTlsSerialConsole.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Property serialPortConfig = BTlsSerialConsole.newProperty((int)0, (BValue)new BSerialHelper(), null);
    @Generated
    public static final Property commType = BTlsSerialConsole.newProperty((int)0, (BValue)BTlsCommTypeEnum.serial, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTlsSerialConsole.class);
    private Subscriber subscriber;
    private String serialInitError = null;

    @Generated
    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    @Generated
    public void setInterMessageDelay(BRelTime v) {
        this.set(interMessageDelay, (BValue)v, null);
    }

    @Generated
    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    @Generated
    public void setSerialPortConfig(BSerialHelper v) {
        this.set(serialPortConfig, (BValue)v, null);
    }

    @Generated
    public BTlsCommTypeEnum getCommType() {
        return (BTlsCommTypeEnum)this.get(commType);
    }

    @Generated
    public void setCommType(BTlsCommTypeEnum v) {
        this.set(commType, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTlsSerialConsole() {
        this.getSerialPortConfig().setBaudRate((BBaudRate)BSerialBaudRate.baud9600);
        this.getSerialPortConfig().setDataBits(BSerialDataBits.dataBits8);
        this.getSerialPortConfig().setStopBits(BSerialStopBits.stopBits2);
        this.getSerialPortConfig().setParity(BSerialParity.none);
        this.setRetryCount(1);
        this.setResponseTimeout(BRelTime.make((long)2000L));
        this.setFlags((Slot)BLoadableNetwork.upload, 4);
        this.setFlags((Slot)BLoadableNetwork.download, 4);
    }

    public void serviceStarted() throws Exception {
        this.subscriber = new NameSubscriber(this);
        this.subscriber.subscribe((BComponent)this.getParent());
        this.subscriber.subscribe((BComponent)this.getSerialPortConfig());
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
    }

    public void startComm() throws Exception {
        try {
            super.startComm();
            this.serialInitError = null;
        }
        catch (Exception e) {
            this.serialInitError = "Could not enable serial communication (" + e + ")";
            throw e;
        }
        finally {
            String error = this.checkSerialConfig();
            if (error == null) {
                this.configOk();
            } else {
                this.configFail(error);
            }
        }
    }

    protected String checkSerialConfig() {
        if (this.getSerialPortConfig().getPortName().equals("none")) {
            return "No port selected for serial communication.";
        }
        return this.serialInitError;
    }

    public final void reopenPort() {
        try {
            String newPort = this.getSerialPortConfig().getPortName();
            if (newPort.equals("none")) {
                this.configFail("No port selected for serial communication.");
                this.stopComm();
                return;
            }
            this.restartSerialNetwork();
        }
        catch (Exception e) {
            this.getLog().error("BSerialNetwork caught exception in reopenPort(): ", (Throwable)e);
        }
    }

    private void restartSerialNetwork() throws Exception {
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Restarting serial comm ***");
            }
            this.stopComm();
            this.startComm();
        }
    }

    @Override
    public Type getDeviceType() {
        return BTlsDevice.TYPE;
    }

    @Override
    public Type getDeviceFolderType() {
        return BTlsDeviceFolder.TYPE;
    }

    private class NameSubscriber
    extends Subscriber {
        private BTlsSerialConsole net;

        public NameSubscriber(BTlsSerialConsole net) {
            this.net = net;
        }

        public void event(BComponentEvent event) {
        }
    }
}

