/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.comm.TlsTcpIpComm;
import com.tridium.tls.consoles.BTlsTcpIpConsole;
import com.tridium.tls.messages.TlsReceivedMessage;
import java.io.IOException;
import java.net.SocketException;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.ByteBuffer;

public class TlsTcpIpCommReceiver
extends CommReceiver {
    protected ByteBuffer rcv = new ByteBuffer();
    protected int state = 0;
    protected int cksumErrorCount = 0;
    protected int cksumSuccessCount = 0;
    private static final int WAIT_FOR_START = 0;
    private static final int READ_FIRST_CHAR = 1;
    private static final int READ_UNTIL_APMERSAND1 = 2;
    private static final int READ_UNTIL_APMERSAND2 = 3;
    private static final int READ_CKSUM1 = 4;
    private static final int READ_CKSUM2 = 5;
    private static final int READ_CKSUM3 = 6;
    private static final int READ_CKSUM4 = 7;
    private static final int READ_ETX = 9;

    public void initReceiveState(byte[] msg) {
        this.initRxState();
    }

    public void initReceiveState(Message msg) {
        this.initRxState();
    }

    public void initRxState() {
        this.setDriverState(0);
    }

    public void setDriverState(int state) {
        this.state = state;
    }

    public int getDriverState() {
        return this.state;
    }

    protected ReceivedMessage receive() throws Exception {
        TlsTcpIpComm comm = (TlsTcpIpComm)this.getComm();
        if (comm == null) {
            this.pause();
            return null;
        }
        BTlsTcpIpConsole network = (BTlsTcpIpConsole)comm.getNetwork();
        if (network == null) {
            if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm3") != -1) {
                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- network==null");
            }
            this.pause();
            return null;
        }
        if (this.getInputStream() == null) {
            if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm3") != -1) {
                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- inputStream==null");
            }
            this.pause();
            return null;
        }
        boolean done = false;
        this.rcv.reset();
        int sum = 0;
        int checksumVal = 0;
        while (!done) {
            boolean newChar = false;
            try {
                int charIn = this.getInputStream().read();
                newChar = charIn != -1;
                byte b = (byte)(charIn & 0xFF);
                if (newChar) {
                    int charValue = charIn & 0xFF;
                    if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm2") != -1) {
                        network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- charValue=" + Integer.toHexString(charValue) + " state=" + this.state);
                    }
                    switch (this.state) {
                        case 0: {
                            if (charValue != 1) break;
                            this.state = 1;
                            this.rcv.reset();
                            this.rcv.write(charValue);
                            if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm2") != -1) {
                                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- detected start character, charValue=" + Integer.toHexString(charValue));
                            }
                            sum += b;
                            break;
                        }
                        case 1: {
                            if (Character.isLowerCase((char)charValue)) {
                                this.state = 2;
                                sum += b;
                            } else {
                                this.state = 9;
                            }
                            this.rcv.write(charValue);
                            if (!network.getLog().isTraceOn() || network.getUserData().indexOf("comm2") == -1) break;
                            network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- reading first byte of message data, charValue=" + Integer.toHexString(charValue));
                            break;
                        }
                        case 2: {
                            if (charValue == 38) {
                                this.state = 3;
                            }
                            this.rcv.write(charValue);
                            if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm2") != -1) {
                                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- reading nth byte of message data, charValue=" + Integer.toHexString(charValue));
                            }
                            sum += b;
                            break;
                        }
                        case 3: {
                            this.state = charValue == 38 ? 4 : 2;
                            this.rcv.write(charValue);
                            if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm2") != -1) {
                                network.getLog().trace(network.getName() + "reading 2nd ampersand, charValue=" + Integer.toHexString(charValue));
                            }
                            sum += b;
                            break;
                        }
                        case 4: {
                            this.rcv.write(charValue);
                            if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm2") != -1) {
                                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- reading cs1 ampersand, charValue=" + Integer.toHexString(charValue));
                            }
                            this.state = 5;
                            char x = (char)charValue;
                            charValue = Character.getNumericValue(x);
                            checksumVal += charValue;
                            break;
                        }
                        case 5: {
                            this.rcv.write(charValue);
                            this.state = 6;
                            if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm2") != -1) {
                                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- reading cs2 ampersand, charValue=" + Integer.toHexString(charValue));
                            }
                            char x = (char)charValue;
                            charValue = Character.getNumericValue(x);
                            checksumVal = (checksumVal << 4) + charValue;
                            break;
                        }
                        case 6: {
                            this.rcv.write(charValue);
                            this.state = 7;
                            if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm2") != -1) {
                                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- reading cs3 ampersand, charValue=" + Integer.toHexString(charValue));
                            }
                            char x = (char)charValue;
                            charValue = Character.getNumericValue(x);
                            checksumVal = (checksumVal << 4) + charValue;
                            break;
                        }
                        case 7: {
                            this.rcv.write(charValue);
                            this.state = 9;
                            if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm2") != -1) {
                                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- reading cs4 ampersand, charValue=" + Integer.toHexString(charValue));
                            }
                            char x = (char)charValue;
                            charValue = Character.getNumericValue(x);
                            checksumVal = (checksumVal << 4) + charValue;
                            break;
                        }
                        case 9: {
                            if (charValue == 3) {
                                this.rcv.write(charValue);
                                done = true;
                                if (!network.getLog().isTraceOn() || network.getUserData().indexOf("comm2") == -1) break;
                                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- finished read from rcvLength=" + this.rcv.getLength());
                                break;
                            }
                            done = true;
                            if (!network.getLog().isTraceOn() || network.getUserData().indexOf("comm2") == -1) break;
                            network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- response received without ETX char... lastChar=" + charValue + " rcvLength=" + this.rcv.getLength());
                        }
                    }
                    continue;
                }
                if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm3") != -1) {
                    network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- sleep");
                }
                this.pause();
            }
            catch (SocketException e) {
                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- SOCKET connection lost !!!!!!");
                this.pause();
                return null;
            }
            catch (IOException e) {
                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- ........Received IOException.............");
                this.pause();
                return null;
            }
        }
        if (this.rcv.getLength() <= 0) {
            if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm3") != -1) {
                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)- rcv.getLength==0");
            }
            this.pause();
            return null;
        }
        byte[] tempBA = this.rcv.toByteArray();
        if ((sum + checksumVal & 0xFFFF) != 0) {
            ++this.cksumErrorCount;
            if (network.getLog().isTraceOn() && network.getUserData().indexOf("cksum") != -1) {
                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)-  read entire ba=" + ByteArrayUtil.toHexString((byte[])tempBA, (int)0, (int)tempBA.length));
                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)-  cksumErrorCount=" + this.cksumErrorCount + " sum=" + sum + " checksumVal=" + checksumVal);
                return null;
            }
        } else {
            ++this.cksumSuccessCount;
            if (network.getLog().isTraceOn() && network.getUserData().indexOf("cksum") != -1) {
                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)-  read entire ba=" + ByteArrayUtil.toHexString((byte[])tempBA, (int)0, (int)tempBA.length));
                network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)-  cksumSuccessCount=" + this.cksumSuccessCount);
            }
        }
        if (network.getLog().isTraceOn() && network.getUserData().indexOf("comm1") != -1) {
            network.getLog().trace(network.getName() + "(TlsTcpIpCommReceiver)-  read entire ba=" + ByteArrayUtil.toHexString((byte[])tempBA, (int)0, (int)tempBA.length));
        }
        TlsReceivedMessage msg = new TlsReceivedMessage(tempBA);
        return msg;
    }

    private void pause() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

