/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hierarchy;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.hierarchy.BHierarchyCacheStatus;
import com.tridium.hierarchy.HierarchyUtil;
import com.tridium.hierarchy.QueryUtil;
import com.tridium.hierarchy.fox.BFoxHierarchyChannel;
import com.tridium.hierarchy.fox.BFoxHierarchySpace;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.hierarchy.BHierarchy;
import javax.baja.hierarchy.BHierarchyScope;
import javax.baja.hierarchy.BHierarchySpace;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.hierarchy.BRelationLevelDef;
import javax.baja.hierarchy.BRoleHierarchies;
import javax.baja.hierarchy.HierarchyQuery;
import javax.baja.license.Feature;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BIRole;
import javax.baja.role.BRoleService;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperty(name="hierarchyTimeout", type="BRelTime", defaultValue="BRelTime.make(45000)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1)")})
public class BHierarchyService
extends BAbstractService
implements BIRestrictedComponent {
    @Generated
    public static final Property hierarchyTimeout = BHierarchyService.newProperty((int)0, (BValue)BRelTime.make((long)45000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    @Generated
    public static final Type TYPE = Sys.loadType(BHierarchyService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std((String)"navOnly/hierarchyService.png");
    public static final Logger log = Logger.getLogger("hierarchy");
    public static final String LEVEL_DEF_TYPES_PROP_NAME = "levelDefTypes";
    private static final BHierarchyScope[] EMPTY_HIERARCHY_SCOPES_ARR = new BHierarchyScope[0];
    private static final BLevelElem[] EMPTY_LEVEL_ELEM_ARR = new BLevelElem[0];
    private BHierarchySpace hSpace;
    private static boolean allowLocalHierarchy;
    private static boolean allowSystemHierarchy;

    @Generated
    public BRelTime getHierarchyTimeout() {
        return (BRelTime)this.get(hierarchyTimeout);
    }

    @Generated
    public void setHierarchyTimeout(BRelTime v) {
        this.set(hierarchyTimeout, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() {
        if (this.isOperational()) {
            this.hSpace = new BHierarchySpace(this);
            BLocalHost.INSTANCE.addNavChild((BINavNode)this.hSpace);
            try {
                BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
                if (registry.get("hierarchy") == null) {
                    registry.add("hierarchy", (BValue)new BFoxHierarchyChannel());
                }
            }
            catch (Exception e) {
                log.severe(() -> "Unable to add BFoxHierarchyChannel");
            }
            QueryUtil.init();
            this.getComponentSpace().enableMixIn(BRoleHierarchies.TYPE);
        }
    }

    public void serviceStopped() {
        this.getComponentSpace().disableMixIn(BRoleHierarchies.TYPE);
        QueryUtil.cleanup();
        try {
            BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
            if (registry.get("hierarchy") != null) {
                registry.remove("hierarchy");
            }
        }
        catch (Exception e) {
            log.severe(() -> "Unable to remove BFoxHierarchyChannel");
        }
        try {
            BLocalHost.INSTANCE.removeNavChild((BINavNode)this.hSpace);
        }
        catch (Exception e) {
            log.severe(() -> "Unable to remove BHierarchySpace");
        }
        this.hSpace = null;
    }

    protected final void enabled() {
        this.serviceStarted();
    }

    protected final void disabled() {
        this.serviceStopped();
    }

    public final Feature getLicenseFeature() {
        Feature feature = Sys.getLicenseManager().getFeature("tridium", "hierarchy");
        allowLocalHierarchy = feature.getb("local", false);
        allowSystemHierarchy = feature.getb("system", false);
        if (!allowLocalHierarchy && !allowSystemHierarchy) {
            this.configFatal("Unlicensed for all scopes. No hierarchies are allowed.");
        }
        return feature;
    }

    public static BHierarchyScope[] getLicensedScopes(BHierarchyScope[] scopesArray) {
        ArrayList<BHierarchyScope> scopesList = new ArrayList<BHierarchyScope>();
        BHierarchyService.doGetLicensedScopes(scopesArray, scopesList);
        return scopesList.toArray(EMPTY_HIERARCHY_SCOPES_ARR);
    }

    private static void doGetLicensedScopes(BHierarchyScope[] scopesArray, List<BHierarchyScope> scopesList) {
        for (BHierarchyScope scope : scopesArray) {
            if (!allowLocalHierarchy && BHierarchyService.isLocalScope(scope) || !allowSystemHierarchy && BHierarchyService.isSystemScope(scope)) {
                log.warning((Object)((Object)scope) + ": \"" + scope.getScopeOrd() + "\" is not a licensed scope.");
                continue;
            }
            scopesList.add(scope);
        }
    }

    static boolean isLocalScope(BHierarchyScope scope) {
        return true;
    }

    static boolean isSystemScope(BHierarchyScope scope) {
        return false;
    }

    public boolean isChildLegal(BComponent c) {
        return c instanceof BHierarchy;
    }

    public void renamed(Property property, String oldName, Context context) {
        super.renamed(property, oldName, context);
        if (this.isOperational()) {
            try {
                BIRole[] roles;
                BRoleService roleSvc = (BRoleService)Sys.getService((Type)BRoleService.TYPE);
                for (BIRole role : roles = (BIRole[])roleSvc.getChildren(BIRole.class)) {
                    BRoleHierarchies hierarchies = (BRoleHierarchies)role.asObject().asComponent().getMixIn(BRoleHierarchies.TYPE);
                    if (hierarchies == null) continue;
                    hierarchies.renameHierarchy(oldName, property.getName());
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (this.isOperational()) {
            try {
                BIRole[] roles;
                BRoleService roleSvc = (BRoleService)Sys.getService((Type)BRoleService.TYPE);
                for (BIRole role : roles = (BIRole[])roleSvc.getChildren(BIRole.class)) {
                    BRoleHierarchies hierarchies = (BRoleHierarchies)role.asObject().asComponent().getMixIn(BRoleHierarchies.TYPE);
                    if (hierarchies == null) continue;
                    hierarchies.removeHierarchy(property.getName());
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
    }

    public BLevelDef[] getHierarchyDefs() {
        return (BLevelDef[])this.getChildren(BHierarchy.class);
    }

    public static BLevelElem[] getHierarchyElems(BLevelElem parent, BObject base, Context cx) {
        BHierarchySpace space = BHierarchyService.getHierarchySpace(base);
        if (space instanceof BFoxHierarchySpace) {
            try {
                BLevelElem[] elems = parent == null ? ((BFoxHierarchySpace)space).channel().getRootLevelElems() : ((BFoxHierarchySpace)space).channel().getLevelElems(parent.getContextParams(), parent.getElemTags());
                for (BLevelElem elem : elems) {
                    elem.parent = parent;
                    elem.setHierarchySpace(space);
                }
                return elems;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e, () -> "Failed to retrieve hierarchy elems over the fox channel");
                return BLevelDef.EMPTY_LEVEL_ELEMS;
            }
        }
        try {
            BHierarchyService service = (BHierarchyService)Sys.getService((Type)TYPE);
            if (parent == null) {
                return service.getHierarchyRootElems(cx);
            }
            if (service.isHierarchyViewable(parent)) {
                return service.getChildElems(parent, cx);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e, () -> "Cannot get Hierarchy Elements");
        }
        return BLevelDef.EMPTY_LEVEL_ELEMS;
    }

    private boolean isHierarchyViewable(BLevelElem parent) {
        if (!this.isRunning() || !this.isOperational()) {
            log.fine(() -> "isHierarchyViewable: service running? " + this.isRunning() + "; operational? " + this.isOperational());
            return false;
        }
        Object parentDef = parent.fw(1303);
        if (!(parentDef instanceof BLevelDef)) {
            log.fine("isHierarchyViewable: cannot retrieve level def");
            return false;
        }
        BHierarchy hierarchyDef = ((BLevelDef)((Object)parentDef)).getHierarchy();
        if (hierarchyDef == null) {
            log.fine("isHierarchyViewable: hierarchy def is null");
            return false;
        }
        return hierarchyDef.canViewHierarchy();
    }

    public BLevelElem[] getHierarchyRootElems(Context context) {
        if (!this.isRunning() || !this.isOperational()) {
            return BLevelDef.EMPTY_LEVEL_ELEMS;
        }
        BHierarchy[] hierarchyDefs = (BHierarchy[])this.getHierarchyDefs();
        ArrayList<BLevelElem> rootElems = new ArrayList<BLevelElem>(hierarchyDefs.length);
        boolean isFox = context != null && context.getFacet("foxSessionId") != null;
        for (BHierarchy hierarchyDef : hierarchyDefs) {
            BLevelElem[] elems = hierarchyDef.getElements(null, context);
            if (elems.length <= 0) continue;
            BLevelElem rootElem = elems[0];
            if (isFox) {
                if (hierarchyDef.getCacheStatus().equals((Object)BHierarchyCacheStatus.cached)) {
                    rootElem = (BLevelElem)rootElem.newCopy(true);
                }
                BHierarchyService.addLevelDefTypes(rootElem, hierarchyDef);
            }
            rootElems.add(rootElem);
        }
        return rootElems.toArray(EMPTY_LEVEL_ELEM_ARR);
    }

    private static void addLevelDefTypes(BLevelElem root, BHierarchy hierarchyDef) {
        BVector levelDefTypes = new BVector();
        for (BLevelDef levelDef : hierarchyDef.getLevelDefCache()) {
            levelDefTypes.add(null, (BValue)levelDef.getType().getTypeSpec(), 1);
        }
        root.add(LEVEL_DEF_TYPES_PROP_NAME, (BValue)levelDefTypes, 5);
    }

    public BLevelElem[] getChildElems(String defPath, BFacets contextParams, BFacets tags, Context context) {
        if (!this.isRunning() || !this.isOperational()) {
            return BLevelDef.EMPTY_LEVEL_ELEMS;
        }
        String[] defNames = new SlotPath(defPath).getNames();
        if (defNames.length < 1) {
            log.warning(() -> "Def path is empty when trying to retrieve a parent elem");
            return BLevelDef.EMPTY_LEVEL_ELEMS;
        }
        String hierarchyName = defNames[0];
        BHierarchy hierarchyDef = null;
        for (BLevelDef rootDef : this.getHierarchyDefs()) {
            if (!rootDef.getName().equals(hierarchyName)) continue;
            hierarchyDef = (BHierarchy)rootDef;
            break;
        }
        if (hierarchyDef == null) {
            log.fine(() -> "Hierarchy def " + hierarchyName + " not found when trying to retrieve child elems");
            return BLevelDef.EMPTY_LEVEL_ELEMS;
        }
        BLevelElem[] hierarchyRoots = hierarchyDef.getElements(null, context);
        if (hierarchyRoots.length < 1) {
            log.fine(() -> "Hierarchy root elem could not be retrieved for " + hierarchyName + " when trying to retrieve child elems");
            return BLevelDef.EMPTY_LEVEL_ELEMS;
        }
        if (((Boolean)hierarchyRoots[0].fw(1300)).booleanValue()) {
            BLevelElem parent = BHierarchyService.getCachedParent(hierarchyRoots[0], contextParams);
            return this.getChildElems(parent, context);
        }
        BOrd levelDefOrd = BOrd.make((String)("station:|" + this.getSlotPathOrd() + defPath));
        BLevelDef levelDef = (BLevelDef)levelDefOrd.resolve((BObject)this).get();
        BLevelElem parent = new BLevelElem(levelDef, null, "parent", BIcon.DEFAULT, contextParams, tags);
        return this.getChildElems(parent, context);
    }

    private static BLevelElem getCachedParent(BLevelElem hierarchyRoot, BFacets contextParams) {
        BObject facetValue = contextParams.get("hierarchyOrd");
        if (!(facetValue instanceof BOrd)) {
            log.fine("Hierarchy ord missing from context parameters when looking for cached parent");
            return null;
        }
        OrdQuery[] queries = ((BOrd)facetValue).parse();
        if (queries.length < 1 || !"hierarchy".equals(queries[0].getScheme())) {
            log.fine(() -> "Missing hierarchy scheme in first ord query when looking for cached parent; " + facetValue);
            return null;
        }
        BLevelElem parent = hierarchyRoot;
        String[] hierarchyNames = new HierarchyQuery(queries[0].getBody()).getNames();
        for (int i = 1; i < hierarchyNames.length; ++i) {
            String hierarchyName = hierarchyNames[i];
            BLevelElem[] children = (BLevelElem[])parent.fw(1302);
            if ((parent = HierarchyUtil.findElem(hierarchyName, children)) != null) continue;
            log.fine(() -> "Could not find " + hierarchyName + " when looking for cached parent; " + facetValue);
            return null;
        }
        return parent;
    }

    BLevelElem[] getChildElems(BLevelElem parent, Context context) {
        if (parent == null) {
            return BLevelDef.EMPTY_LEVEL_ELEMS;
        }
        if (((Boolean)parent.fw(1300)).booleanValue()) {
            return (BLevelElem[])parent.fw(1302);
        }
        BLevelDef levelDef = parent.getLevelDef();
        if (levelDef == null) {
            return BLevelDef.EMPTY_LEVEL_ELEMS;
        }
        BLevelElem[] elems = BLevelDef.EMPTY_LEVEL_ELEMS;
        if (levelDef instanceof BRelationLevelDef && ((BRelationLevelDef)levelDef).getRepeatRelation()) {
            elems = levelDef.getElements(parent, context);
        }
        if (elems.length > 0) {
            return elems;
        }
        BLevelDef nextDef = levelDef.getNext();
        if (nextDef != null) {
            elems = nextDef.getElements(parent, context);
        }
        return elems;
    }

    public BLevelElem resolveHierarchyLevelElem(HierarchyQuery query) throws UnresolvedException {
        if (!this.isRunning()) {
            throw new UnsupportedOperationException("resolveHierarchyLevelElem may only be called from the station");
        }
        log.fine(() -> "resolveHierarchyLevelElem: query=" + (Object)((Object)query));
        String[] hierarchyNames = query.getNames();
        BLevelElem parent = null;
        BFacets context = null;
        for (String hierarchyName : hierarchyNames) {
            log.fine(() -> "  " + hierarchyName);
            BLevelElem[] children = parent == null ? this.getHierarchyRootElems((Context)context) : this.getChildElems(parent, (Context)context);
            parent = HierarchyUtil.findElem(hierarchyName, children);
            if (parent == null) {
                throw new UnresolvedException("Cannot resolve hierarchy elem " + hierarchyName);
            }
            context = parent.getContextParams();
        }
        if (parent != null) {
            return parent;
        }
        throw new UnresolvedException("Cannot resolve hierarchy elem " + (Object)((Object)query));
    }

    public static BHierarchySpace getHierarchySpace(BObject base) {
        BHierarchySpace space = null;
        try {
            space = (BHierarchySpace)(base instanceof BHierarchySpace ? base : BOrd.make((String)"hierarchy:").get(base));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return space;
    }

    public static BHierarchyService getHierarchyService(BObject base) {
        BHierarchyService service = null;
        try {
            BOrd ord = BOrd.make((String)"service:hierarchy:HierarchyService");
            service = (BHierarchyService)ord.get(base);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e, () -> "Could not get the hierarchy service");
        }
        return service;
    }

    public BHierarchySpace getHierarchySpace() {
        return this.hSpace;
    }

    public BIcon getIcon() {
        return icon;
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("HierarchyService");
        out.prop((Object)"Licensed for local hierarchy", allowLocalHierarchy);
        out.prop((Object)"Licensed for system hierarchy", allowSystemHierarchy);
        out.endProps();
        QueryUtil.spyExecutor(out);
        super.spy(out);
    }
}

