/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hierarchy;

import com.tridium.hierarchy.HierarchyUtil;
import com.tridium.hierarchy.fox.BFoxHierarchySpace;
import java.util.List;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BHierarchySpace;
import javax.baja.hierarchy.BIEntityLevelDef;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.hierarchy.HierarchyQuery;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.space.BSpaceScheme;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;

@NiagaraType(ordScheme="hierarchy")
@NiagaraSingleton
public class BHierarchyScheme
extends BSpaceScheme {
    @Generated
    public static final BHierarchyScheme INSTANCE = new BHierarchyScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BHierarchyScheme.class);
    public static final String HIERARCHY_QUERY_FACET = "hierarchyQuery";

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHierarchyScheme() {
        super("hierarchy");
    }

    public Type getSpaceType() {
        return BHierarchySpace.TYPE;
    }

    public OrdQuery parse(String queryBody) {
        return new HierarchyQuery(this.getId(), queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query, BSpace space) {
        OrdTarget target;
        BLevelElem[] children;
        BHierarchyService.log.fine(() -> "resolve: base=" + base + " query=" + query + " space=" + space.getSession().getNavOrd());
        BHierarchySpace hierarchySpace = (BHierarchySpace)space;
        HierarchyQuery hierarchyQuery = (HierarchyQuery)query;
        String[] hierarchyNames = hierarchyQuery.getNames();
        BFacets queryFacet = BFacets.make((String)HIERARCHY_QUERY_FACET, (String)query.toString());
        if (hierarchyNames.length <= 0) {
            return OrdTarget.makeWithFacets((OrdTarget)base, (BObject)hierarchySpace, (BFacets)queryFacet);
        }
        BHierarchyService service = null;
        if (hierarchySpace instanceof BFoxHierarchySpace) {
            children = (BLevelElem[])hierarchySpace.getNavChildren();
        } else {
            service = (BHierarchyService)Sys.getService((Type)BHierarchyService.TYPE);
            children = service.getHierarchyRootElems(null);
        }
        BLevelElem parent = HierarchyUtil.findElem(hierarchyNames[0], children);
        if (parent == null) {
            throw new UnresolvedException("Cannot resolve hierarchy elem " + hierarchyNames[0]);
        }
        if (hierarchyNames.length == 1) {
            return OrdTarget.makeWithFacets((OrdTarget)base, (BObject)parent, (BFacets)queryFacet);
        }
        String lastName = null;
        if (hierarchySpace instanceof BFoxHierarchySpace) {
            BVector levelDefTypes = (BVector)parent.get("levelDefTypes");
            if (levelDefTypes != null) {
                BTypeSpec levelDefTypeSpec;
                Property[] levelDefTypeProps = levelDefTypes.getDynamicPropertiesArray();
                if (hierarchyNames.length - 2 < levelDefTypeProps.length && (levelDefTypeSpec = (BTypeSpec)levelDefTypes.get(levelDefTypeProps[hierarchyNames.length - 2])).getTypeInfo().is(BIEntityLevelDef.TYPE)) {
                    lastName = hierarchyNames[hierarchyNames.length - 1];
                }
            } else if (hierarchyNames[hierarchyNames.length - 1].startsWith("station$3a$7c")) {
                lastName = hierarchyNames[hierarchyNames.length - 1];
            }
        } else {
            List<BLevelDef> levelDefs = parent.getLevelDef().getHierarchy().getLevelDefCache();
            if (hierarchyNames.length - 2 < levelDefs.size() && levelDefs.get(hierarchyNames.length - 2) instanceof BIEntityLevelDef) {
                lastName = hierarchyNames[hierarchyNames.length - 1];
            }
        }
        if (lastName != null) {
            if (hierarchySpace instanceof BFoxHierarchySpace) {
                BObject targetComp = BOrd.make((String)SlotPath.unescape(lastName)).resolve(base.get()).get();
                return OrdTarget.makeWithFacets((OrdTarget)base, (BObject)targetComp, (BFacets)queryFacet);
            }
            BUser user = HierarchyUtil.getUser();
            target = BOrd.make((String)SlotPath.unescape(lastName)).resolve(base.get(), (Context)user);
            if (target.canRead()) {
                return OrdTarget.makeWithFacets((OrdTarget)base, (BObject)target.get(), (BFacets)queryFacet);
            }
            throw new UnresolvedException("Cannot resolve hierarchy elem");
        }
        BFacets context = parent.getContextParams();
        target = OrdTarget.makeWithFacets((OrdTarget)base, (BObject)parent, (BFacets)queryFacet);
        for (int i = 1; i < hierarchyNames.length; ++i) {
            String hierarchyName = hierarchyNames[i];
            BHierarchyService.log.fine(() -> "  " + hierarchyName);
            children = hierarchySpace instanceof BFoxHierarchySpace ? (BLevelElem[])parent.getNavChildren() : service.getChildElems(parent, (Context)context);
            parent = HierarchyUtil.findElem(hierarchyName, children);
            if (parent == null) {
                throw new UnresolvedException("Cannot resolve hierarchy elem " + hierarchyName);
            }
            context = parent.getContextParams();
            BComponent targetComp = parent.doGetTargetComponent(false);
            target = OrdTarget.makeWithFacets((OrdTarget)base, (BObject)(targetComp != null ? targetComp : parent), (BFacets)queryFacet);
        }
        return target;
    }
}

