/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hierarchy;

import com.tridium.hierarchy.BHierarchyCacheStatus;
import com.tridium.hierarchy.BHierarchyCachingJob;
import com.tridium.hierarchy.HierarchyCacheBuilder;
import com.tridium.hierarchy.HierarchyUtil;
import com.tridium.hierarchy.MakeElemUtil;
import com.tridium.hierarchy.QueryUtil;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.baja.hierarchy.BHierarchyScope;
import javax.baja.hierarchy.BHierarchyScopeContainer;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BHierarchyTags;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="scope", type="BHierarchyScopeContainer", defaultValue="new BHierarchyScopeContainer()"), @NiagaraProperty(name="tags", type="BHierarchyTags", defaultValue="new BHierarchyTags()"), @NiagaraProperty(name="cacheStatus", type="BHierarchyCacheStatus", defaultValue="notCached", flags=67), @NiagaraProperty(name="cacheCreationTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=67), @NiagaraProperty(name="cacheOnStationStarted", type="boolean", defaultValue="false", flags=64)})
@NiagaraActions(value={@NiagaraAction(name="createCache", returnType="BOrd"), @NiagaraAction(name="clearCache")})
public final class BHierarchy
extends BLevelDef {
    @Generated
    public static final Property status = BHierarchy.newProperty((int)75, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BHierarchy.newProperty((int)67, (String)"", null);
    @Generated
    public static final Property scope = BHierarchy.newProperty((int)0, (BValue)new BHierarchyScopeContainer(), null);
    @Generated
    public static final Property tags = BHierarchy.newProperty((int)0, (BValue)new BHierarchyTags(), null);
    @Generated
    public static final Property cacheStatus = BHierarchy.newProperty((int)67, (BValue)BHierarchyCacheStatus.notCached, null);
    @Generated
    public static final Property cacheCreationTime = BHierarchy.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property cacheOnStationStarted = BHierarchy.newProperty((int)64, (boolean)false, null);
    @Generated
    public static final Action createCache = BHierarchy.newAction((int)0, null);
    @Generated
    public static final Action clearCache = BHierarchy.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHierarchy.class);
    private static final BIcon icon = BIcon.make((String)"module://icons/x16/r2/tree.png");
    private final AtomicReference<List<BLevelDef>> levelDefCache = new AtomicReference(Collections.emptyList());
    private int oldStatus;
    private final Object cachedRootLock = new Object();
    private BLevelElem cachedRoot;
    private int cachedElemCount;
    private long cacheSizeEstimate;
    private static final String DISABLE_CACHING_ON_STATION_STARTED_SYSPROP = "niagara.hierarchy.caching.disableOnStationStarted";
    private static final boolean DISABLE_CACHING_ON_STATION_STARTED = AccessController.doPrivileged(() -> Boolean.getBoolean(DISABLE_CACHING_ON_STATION_STARTED_SYSPROP));
    private static final String DISABLE_CACHING_SYSPROP = "niagara.hierarchy.caching.disabled";
    private static final String DISABLE_CACHING_SYSDB_MSG_LEX_KEY = "hierarchy.caching.disabled.systemdb.message";
    private static final String DISABLE_CACHING_SYSPROP_MSG_LEX_KEY = "hierarchy.caching.disabled.message";

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BHierarchyScopeContainer getScope() {
        return (BHierarchyScopeContainer)this.get(scope);
    }

    @Generated
    public void setScope(BHierarchyScopeContainer v) {
        this.set(scope, (BValue)v, null);
    }

    @Generated
    public BHierarchyTags getTags() {
        return (BHierarchyTags)this.get(tags);
    }

    @Generated
    public void setTags(BHierarchyTags v) {
        this.set(tags, (BValue)v, null);
    }

    @Generated
    public BHierarchyCacheStatus getCacheStatus() {
        return (BHierarchyCacheStatus)this.get(cacheStatus);
    }

    @Generated
    public void setCacheStatus(BHierarchyCacheStatus v) {
        this.set(cacheStatus, (BValue)v, null);
    }

    @Generated
    public BAbsTime getCacheCreationTime() {
        return (BAbsTime)this.get(cacheCreationTime);
    }

    @Generated
    public void setCacheCreationTime(BAbsTime v) {
        this.set(cacheCreationTime, (BValue)v, null);
    }

    @Generated
    public boolean getCacheOnStationStarted() {
        return this.getBoolean(cacheOnStationStarted);
    }

    @Generated
    public void setCacheOnStationStarted(boolean v) {
        this.setBoolean(cacheOnStationStarted, v, null);
    }

    @Generated
    public BOrd createCache() {
        return (BOrd)this.invoke(createCache, null, null);
    }

    @Generated
    public void clearCache() {
        this.invoke(clearCache, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        try {
            BHierarchyService service = (BHierarchyService)Sys.getService((Type)BHierarchyService.TYPE);
            String hierarchyLimitFault = (String)service.fw(501, "hierarchy.limit", null, null, null);
            if (hierarchyLimitFault != null) {
                this.fatalFault = true;
                this.setFaultCause(hierarchyLimitFault);
                this.updateStatus(service);
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        if (this.getCacheOnStationStarted()) {
            if (BHierarchy.isCachingDisabledBySystemProp()) {
                BHierarchyService.log.warning(() -> "Hierarchy " + this.getName() + " was not cached on station started because the system property " + DISABLE_CACHING_SYSPROP + " is set to true.");
                this.setCacheStatus(BHierarchyCacheStatus.notCachedOnStarted);
            } else if (this.isCachingDisabledBySystemDbScope()) {
                BHierarchyService.log.warning(() -> "Hierarchy " + this.getName() + " was not cached on station started because at least one of its scopes includes the system database.");
                this.setCacheStatus(BHierarchyCacheStatus.notCachedOnStarted);
            } else if (DISABLE_CACHING_ON_STATION_STARTED) {
                BHierarchyService.log.warning(() -> "Hierarchy " + this.getName() + " was not cached on station started because the system property " + DISABLE_CACHING_ON_STATION_STARTED_SYSPROP + " is set to true.");
                this.setCacheStatus(BHierarchyCacheStatus.notCachedOnStarted);
            } else {
                this.doCreateCache(null);
            }
        }
    }

    public void updateStatus(BHierarchyService service) {
        int newStatus = this.getStatus().getBits();
        newStatus = this.fatalFault || service.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
    }

    public boolean isOperational() {
        BStatus status = this.getStatus();
        return !status.isDisabled() && !status.isFault();
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BHierarchyService;
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        return child instanceof BLevelDef || child instanceof BHierarchyScopeContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLevelElem[] getElements(BLevelElem parentElem, Context context) {
        if (!this.canViewHierarchy()) {
            return BLevelDef.EMPTY_LEVEL_ELEMS;
        }
        Object object = this.cachedRootLock;
        synchronized (object) {
            return new BLevelElem[]{this.cachedRoot != null ? this.cachedRoot : MakeElemUtil.makeHierarchyElem(this, context)};
        }
    }

    boolean canViewHierarchy() {
        return this.isOperational() && HierarchyUtil.canCurrentUserViewHierarchy(this);
    }

    @Override
    public BHierarchy getHierarchy() {
        return this;
    }

    @Override
    public BLevelDef getPrevious() {
        return null;
    }

    @Override
    public BLevelDef getNext() {
        BLevelDef[] children = (BLevelDef[])this.getChildren(BLevelDef.class);
        if (children.length > 0) {
            return children[0];
        }
        return null;
    }

    public void descendantsStarted() {
        this.rebuildLevelDefCache();
    }

    public void added(Property property, Context context) {
        if (this.isRunning() && property.getType().is(BLevelDef.TYPE)) {
            this.rebuildLevelDefCache();
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.getType().is(BLevelDef.TYPE)) {
            this.rebuildLevelDefCache();
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (this.isRunning() && property.getType().is(BLevelDef.TYPE)) {
            this.rebuildLevelDefCache();
        }
    }

    public void reordered(Context context) {
        if (this.isRunning()) {
            this.rebuildLevelDefCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildLevelDefCache() {
        Object object = this.cachedRootLock;
        synchronized (object) {
            if (this.cachedRoot == null) {
                this.levelDefCache.set(Collections.unmodifiableList(Arrays.asList(this.getChildren(BLevelDef.class))));
            }
        }
    }

    public List<BLevelDef> getLevelDefCache() {
        return this.levelDefCache.get();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    public BOrd doCreateCache(Context context) {
        if (!this.isRunning() || !this.isOperational()) {
            return BOrd.NULL;
        }
        this.doClearCache();
        if (BHierarchy.isCachingDisabledBySystemProp()) {
            throw new LocalizableRuntimeException("hierarchy", DISABLE_CACHING_SYSPROP_MSG_LEX_KEY, new Object[]{DISABLE_CACHING_SYSPROP});
        }
        if (this.isCachingDisabledBySystemDbScope()) {
            throw new LocalizableRuntimeException("hierarchy", DISABLE_CACHING_SYSDB_MSG_LEX_KEY, new Object[]{this.getName()});
        }
        BHierarchyService hierarchyService = (BHierarchyService)Sys.getService((Type)BHierarchyService.TYPE);
        HierarchyCacheBuilder builder = new HierarchyCacheBuilder(this, hierarchyService);
        return new BHierarchyCachingJob(this, builder).submit(context);
    }

    private static boolean isCachingDisabledBySystemProp() {
        return AccessController.doPrivileged(() -> Boolean.getBoolean(DISABLE_CACHING_SYSPROP));
    }

    private boolean isCachingDisabledBySystemDbScope() {
        BHierarchyScope[] hierarchyScopes;
        TypeInfo systemDbTypeInfo = QueryUtil.getSystemDbType();
        if (systemDbTypeInfo == null) {
            return false;
        }
        for (BHierarchyScope hierarchyScope : hierarchyScopes = this.getScope().getHierarchyScopes()) {
            try {
                if (!hierarchyScope.getScopeOrd().get().getType().is(systemDbTypeInfo)) continue;
                return true;
            }
            catch (Exception e) {
                BHierarchyService.log.log(Level.FINE, e, () -> "Exception while checking the type of a hierarchy scope ord (" + hierarchyScope.getScopeOrd() + ") for hierarchy " + this.getName() + '.');
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClearCache() {
        Object object = this.cachedRootLock;
        synchronized (object) {
            this.cachedRoot = null;
            this.cachedElemCount = 0;
            this.cacheSizeEstimate = 0L;
            this.setCacheStatus(BHierarchyCacheStatus.notCached);
            this.setCacheCreationTime(BAbsTime.NULL);
            this.rebuildLevelDefCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 1304: {
                Object object = this.cachedRootLock;
                synchronized (object) {
                    this.cachedRoot = (BLevelElem)a;
                    this.cachedElemCount = (Integer)b;
                    this.cacheSizeEstimate = (Long)c;
                    this.levelDefCache.set(Collections.unmodifiableList(Arrays.asList((BLevelDef[])d)));
                    this.setCacheStatus(BHierarchyCacheStatus.cached);
                    this.setCacheCreationTime(BAbsTime.now());
                }
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.getCacheStatus().equals((Object)BHierarchyCacheStatus.cached)) {
            out.startProps();
            out.trTitle((Object)"Cache Info", 2);
            out.prop((Object)"cached element count", this.cachedElemCount);
            out.prop((Object)"estimated cache size [MB]", (double)this.cacheSizeEstimate / 1000000.0);
            out.endProps();
        }
        super.spy(out);
    }
}

