/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hierarchy.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BFoxHierarchyChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxHierarchyChannel.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFoxHierarchyChannel() {
        super("hierarchy");
    }

    public FoxResponse process(FoxRequest req) throws Throwable {
        throw new InvalidCommandException(req.command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Throwable {
        if (!"getLevelElems".equals(circuit.command)) {
            throw new InvalidCommandException(circuit.command);
        }
        this.getLevelElems(circuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLevelElems(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage msg = circuit.readMessage();
            BFacets contextParams = (BFacets)BFacets.DEFAULT.decodeFromString(msg.getString("contextParams"));
            BFacets tags = (BFacets)BFacets.DEFAULT.decodeFromString(msg.getString("tags"));
            BHierarchyService service = (BHierarchyService)Sys.getService((Type)BHierarchyService.TYPE);
            String levelDefPath = contextParams.gets("levelDefPath", "");
            BLevelElem[] elems = levelDefPath.isEmpty() ? service.getHierarchyRootElems(this.getSessionContext()) : service.getChildElems(levelDefPath, contextParams, tags, this.getSessionContext());
            ValueDocEncoder enc = new ValueDocEncoder(circuit.getOutputStream());
            FoxMessage header = new FoxMessage();
            header.add("count", elems.length);
            circuit.writeMessage(header);
            for (BLevelElem elem : elems) {
                enc.encode((BValue)elem);
                enc.flush();
            }
            enc.close();
        }
        finally {
            circuit.close();
        }
    }

    public BLevelElem[] getRootLevelElems() throws Exception {
        return this.getLevelElems(BFacets.NULL, BFacets.NULL);
    }

    public BLevelElem[] getLevelElems(BFacets contextParams, BFacets tags) throws Exception {
        FoxCircuit circuit = this.openCircuit("getLevelElems");
        FoxMessage msg = new FoxMessage();
        msg.add("contextParams", contextParams.encodeToString());
        msg.add("tags", tags.encodeToString());
        circuit.writeMessage(msg);
        circuit.flush();
        msg = circuit.readMessage();
        int count = msg.getInt("count", 0);
        ValueDocDecoder dec = new ValueDocDecoder(circuit.getInputStream());
        BLevelElem[] elems = new BLevelElem[count];
        for (int i = 0; i < count; ++i) {
            if (dec.next() == -1) {
                throw new IllegalStateException("Not enough elems in the circuit");
            }
            elems[i] = (BLevelElem)dec.decode();
        }
        if (dec.next() != -1) {
            throw new IllegalStateException("The number of elems in the circuit stream exceeds the count");
        }
        return elems;
    }
}

