/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hierarchy;

import com.tridium.box.json.AllPermissionsContext;
import com.tridium.box.json.BoxString;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.nre.util.Version;
import com.tridium.web.RestUtil;
import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HierarchyServlet
extends HttpServlet {
    private static final Version version = new Version("1");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RestUtil util = new RestUtil(req, resp);
        if (!util.acceptJson()) {
            resp.sendError(406);
            return;
        }
        RestUtil.Accept accept = util.getJsonAccept();
        if (accept == null || accept.isCustomMediaType() && (!accept.getCustomProtocol().equals("hierarchy") || !accept.getCustomVersion().equals((Object)version))) {
            resp.sendError(406);
            return;
        }
        String pathInfo = req.getPathInfo();
        String queryString = req.getQueryString();
        if (pathInfo != null && pathInfo.indexOf(47, 1) > 0 && queryString == null) {
            resp.sendError(406);
            return;
        }
        util.respond(accept, "application/json").respondNoCache();
        try {
            HierarchyServlet.load(new BoxWriter((Writer)resp.getWriter()), Objects.toString(pathInfo, ""), Objects.toString(req.getParameter("contextParams"), ""), Objects.toString(req.getParameter("tags"), ""), (Context)req.getAttribute("niagara.context"));
        }
        catch (ServiceNotFoundException snfe) {
            resp.sendError(404);
        }
        catch (Throwable e) {
            Logger.getLogger("web.reg").log(Level.SEVERE, "Error processing Hierarchy Level GET request: " + HierarchyServlet.toDebugString(req), e);
            resp.sendError(400);
        }
    }

    static void load(BoxWriter out, String path, String contextParamsStr, String tagsStr, Context cx) throws IOException {
        BLevelElem[] elems;
        BHierarchyService service = (BHierarchyService)Sys.getService((Type)BHierarchyService.TYPE);
        if (path.isEmpty()) {
            elems = service.getHierarchyRootElems(cx);
        } else {
            BFacets contextParams = BFacets.NULL;
            if (!contextParamsStr.isEmpty()) {
                contextParams = (BFacets)contextParams.decodeFromString(URLDecoder.decode(contextParamsStr, "UTF-8"));
            }
            BFacets tags = BFacets.NULL;
            if (!tagsStr.isEmpty()) {
                tags = (BFacets)tags.decodeFromString(URLDecoder.decode(tagsStr, "UTF-8"));
            }
            elems = service.getChildElems(path, contextParams, tags, cx);
        }
        out.array();
        for (BLevelElem elem : elems) {
            out.object();
            out.key("o").value((Object)new BoxString(BsonEncoderPlugin.marshal((BValue)elem, (Context)new AllPermissionsContext(null))));
            out.endObject();
        }
        out.endArray();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(406);
    }

    private static String toDebugString(HttpServletRequest req) {
        StringBuffer buff = req.getRequestURL();
        String query = req.getQueryString();
        if (query != null) {
            buff.append('?').append(query);
        }
        return buff.toString();
    }
}

