/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hierarchy;

import com.tridium.hierarchy.HierarchyUtil;
import com.tridium.hierarchy.IHierarchyCacheBuilder;
import com.tridium.hierarchy.MakeElemUtil;
import com.tridium.hierarchy.QueryUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Level;
import javax.baja.category.BCategoryMask;
import javax.baja.data.BIDataValue;
import javax.baja.hierarchy.BGroupLevelDef;
import javax.baja.hierarchy.BHierarchy;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BIEntityLevelDef;
import javax.baja.hierarchy.BIGroupingLevelDef;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.hierarchy.BListLevelDef;
import javax.baja.hierarchy.BNamedGroupDef;
import javax.baja.hierarchy.BQueryLevelDef;
import javax.baja.hierarchy.BRelationLevelDef;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.neql.AstNode;
import javax.baja.neql.Expression;
import javax.baja.neql.NeqlEntityEvaluator;
import javax.baja.neql.NeqlQuery;
import javax.baja.neql.Select;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tags;
import javax.baja.util.CloseableIterator;
import javax.baja.util.CloseableIteratorWrapper;

public class HierarchyCacheBuilder
implements IHierarchyCacheBuilder {
    private final BHierarchy hierarchy;
    private final BHierarchyService hierarchyService;
    private BLevelDef[] allDefs;
    private final Map<String, BIcon> entityIcons = new HashMap<String, BIcon>();
    private final Map<BComponent, BIcon> groupingIcons = new HashMap<BComponent, BIcon>();
    private final List<BLevelElem> cachedElems = new ArrayList<BLevelElem>();
    private final Map<BLevelElem, Integer> cachedElemChildCounts = new IdentityHashMap<BLevelElem, Integer>();
    private long cacheSizeEstimate;
    private final Map<BFacets, BFacets> visitedFacets = new IdentityHashMap<BFacets, BFacets>();
    private final Map<BObject, BObject> visitedFacetValues = new IdentityHashMap<BObject, BObject>();
    private static final int SIZEOF_OBJECT_HEADER = 12;
    private static final int SIZEOF_CHAR = 2;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_REFERENCE = 4;
    private static final int SIZEOF_LENGTH_FIELD = 4;
    private static final int SIZEOF_STRING = 24;
    private static final int SIZEOF_ARRAY_LIST = 24;
    private static final int SIZEOF_LEVEL_ELEM = 40;
    private static final int SIZEOF_LEVEL_ELEM_SLOTMAP = 88;
    private static final int SIZEOF_BSTRING = 16;
    private static final int SIZEOF_BORD = 24;
    private static final int SIZEOF_BFACETS = 32;
    private static final int SIZEOF_FROZENFLAGS = 32;

    public HierarchyCacheBuilder(BHierarchy hierarchy, BHierarchyService hierarchyService) {
        this.hierarchy = hierarchy;
        this.hierarchyService = hierarchyService;
    }

    @Override
    public BLevelElem buildCache(Context context) throws Exception {
        this.allDefs = (BLevelDef[])this.hierarchy.getChildren(BLevelDef.class);
        BLevelElem root = MakeElemUtil.makeHierarchyElem(this.hierarchy, context);
        root.fw(1301, null, null, null, null);
        this.cachedElems.add(root);
        ArrayList<BIGroupingLevelDef> groupingDefs = new ArrayList<BIGroupingLevelDef>();
        int defIndex = this.gatherGroupingDefs(0, groupingDefs);
        if (HierarchyCacheBuilder.areGroupingDefsValid(groupingDefs) && defIndex < this.allDefs.length && this.allDefs[defIndex] instanceof BIEntityLevelDef) {
            BIEntityLevelDef nextDef = (BIEntityLevelDef)((Object)this.allDefs[defIndex]);
            this.processEntityDef(nextDef, root, groupingDefs, defIndex + 1, 0, context);
        }
        this.estimateCacheSize();
        return root;
    }

    public int getElemCount() {
        return this.cachedElems.size();
    }

    public long getCacheSizeEstimate() {
        return this.cacheSizeEstimate;
    }

    public BLevelDef[] getLevelDefs() {
        return this.allDefs;
    }

    private int gatherGroupingDefs(int defIndex, ArrayList<BIGroupingLevelDef> groupingDefs) {
        BLevelDef def;
        for (int i = defIndex; i < this.allDefs.length && (def = this.allDefs[i]) instanceof BIGroupingLevelDef; ++i) {
            groupingDefs.add((BIGroupingLevelDef)((Object)def));
        }
        return defIndex + groupingDefs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntityDef(BIEntityLevelDef entityDef, BLevelElem parent, ArrayList<BIGroupingLevelDef> groupingDefs, int defIndex, int relationRepeat, Context context) throws Exception {
        BIEntityLevelDef nextDef = null;
        ArrayList<BIGroupingLevelDef> nextGroupingDefs = new ArrayList<BIGroupingLevelDef>();
        int nextIndex = -1;
        if (defIndex < this.allDefs.length) {
            nextIndex = this.gatherGroupingDefs(defIndex, nextGroupingDefs);
            if (HierarchyCacheBuilder.areGroupingDefsValid(nextGroupingDefs) && nextIndex < this.allDefs.length && this.allDefs[nextIndex] instanceof BIEntityLevelDef) {
                nextDef = (BIEntityLevelDef)((Object)this.allDefs[nextIndex]);
                ++nextIndex;
            }
        }
        try (CloseableIterator<Entity> queryResults = null;){
            int cachingRepeatLimit;
            boolean includeGroupingQueries;
            Context queryContext;
            Object object = queryContext = parent != null ? new BasicContext(context, parent.getContextParams()) : context;
            if (entityDef instanceof BQueryLevelDef) {
                BQueryLevelDef queryDef = (BQueryLevelDef)entityDef;
                includeGroupingQueries = queryDef.getIncludeGroupingQueries();
                cachingRepeatLimit = 0;
                String groupingBase = "";
                if (includeGroupingQueries) {
                    groupingBase = HierarchyCacheBuilder.generateGroupingBase(groupingDefs);
                }
                String neql = "neql: " + groupingBase + '(' + queryDef.getQuery() + ')';
                BHierarchyService.log.fine(() -> "HierarchyCacheBuilder.getAllElements: processEntityDef query=" + neql);
                if (BHierarchyService.log.isLoggable(Level.FINE)) {
                    BHierarchyService.log.fine("  context=" + queryContext.getFacets());
                }
                queryResults = QueryUtil.resolveQueryOnScopes(queryDef, BOrd.make((String)neql), null, this.hierarchyService.getHierarchyTimeout(), queryContext);
            } else if (entityDef instanceof BRelationLevelDef) {
                BRelationLevelDef relationDef = (BRelationLevelDef)entityDef;
                includeGroupingQueries = false;
                int repeatLimitValue = relationDef.getCachingRepeatLimit();
                cachingRepeatLimit = repeatLimitValue < 1 ? 1 : repeatLimitValue;
                queryResults = this.getRelationDefEntities(relationDef, parent, queryContext);
            } else {
                throw new IllegalArgumentException("Entity level def type " + entityDef.getType() + " is not supported");
            }
            LinkedList<BLevelElem> queryParents = new LinkedList<BLevelElem>();
            queryParents.addFirst(parent);
            HashMap<BLevelElem, HashMap<String, BLevelElem>> groupingElems = null;
            if (!groupingDefs.isEmpty()) {
                if (!includeGroupingQueries) {
                    HashMap<BGroupLevelDef, LinkedHashSet<BIDataValue>> groupDefValues = new HashMap<BGroupLevelDef, LinkedHashSet<BIDataValue>>();
                    queryResults = HierarchyCacheBuilder.gatherAllGroupDefValues(queryResults, groupingDefs, groupDefValues);
                    queryParents = this.appendAllGroupingElems(parent, groupingDefs, groupDefValues, queryContext);
                } else {
                    groupingElems = new HashMap<BLevelElem, HashMap<String, BLevelElem>>();
                }
            }
            while (queryResults.hasNext()) {
                Entity entity = (Entity)queryResults.next();
                if (!groupingDefs.isEmpty() && includeGroupingQueries && (queryParents = this.appendGroupElems(entity, groupingDefs, groupingElems, parent, queryContext)) == null) continue;
                for (BLevelElem queryParent : queryParents) {
                    BLevelElem entityElem = MakeElemUtil.makeEntityElem(entity, (BLevelDef)((Object)entityDef), queryParent, this.entityIcons, queryContext);
                    this.appendElem(queryParent, entityElem);
                    HierarchyCacheBuilder.setElemAndAncestorPermissions(entityElem, entity);
                    if (entityDef instanceof BRelationLevelDef && ((BRelationLevelDef)entityDef).getRepeatRelation() && relationRepeat < cachingRepeatLimit && this.repeatHasEntity((BRelationLevelDef)entityDef, entityElem, includeGroupingQueries, groupingDefs, queryContext)) {
                        this.processEntityDef(entityDef, entityElem, groupingDefs, defIndex, relationRepeat + 1, queryContext);
                        continue;
                    }
                    if (nextDef == null) continue;
                    this.processEntityDef(nextDef, entityElem, nextGroupingDefs, nextIndex, 0, queryContext);
                }
            }
        }
    }

    private boolean repeatHasEntity(BRelationLevelDef relationDef, BLevelElem parent, boolean includeGroupingQueries, ArrayList<BIGroupingLevelDef> groupingDefs, Context context) throws Exception {
        Optional<String> predicate;
        BOrd traverseBaseOrd = HierarchyUtil.getTraverseBaseOrd(parent);
        String filterExpression = relationDef.getFilterExpression().trim();
        for (String relationId : HierarchyUtil.RELATION_ID_SPLIT.split(relationDef.getOutboundRelationIds().trim())) {
            predicate = HierarchyUtil.getTraverseNeqlPredicate(relationId, false, filterExpression);
            if (!predicate.isPresent() || !this.foundValidEntity(relationDef, predicate.get(), traverseBaseOrd, includeGroupingQueries, groupingDefs, context)) continue;
            return true;
        }
        for (String relationId : HierarchyUtil.RELATION_ID_SPLIT.split(relationDef.getInboundRelationIds().trim())) {
            predicate = HierarchyUtil.getTraverseNeqlPredicate(relationId, true, filterExpression);
            if (!predicate.isPresent() || !this.foundValidEntity(relationDef, predicate.get(), traverseBaseOrd, includeGroupingQueries, groupingDefs, context)) continue;
            return true;
        }
        return false;
    }

    private boolean foundValidEntity(BRelationLevelDef relationDef, String predicate, BOrd traverseBaseOrd, boolean includeGroupingQueries, ArrayList<BIGroupingLevelDef> groupingDefs, Context context) throws Exception {
        try (CloseableIterator<Entity> entities = QueryUtil.resolveQueryOnScopes(relationDef, BOrd.make((String)predicate), traverseBaseOrd, this.hierarchyService.getHierarchyTimeout(), context);){
            while (entities.hasNext()) {
                Entity entity = (Entity)entities.next();
                if (includeGroupingQueries && !HierarchyCacheBuilder.belongsToGroups(entity, groupingDefs, null, null, context)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private CloseableIterator<Entity> getRelationDefEntities(BRelationLevelDef relationDef, BLevelElem parent, Context context) throws Exception {
        Optional<String> neql;
        LinkedHashMap<BOrd, Entity> results = new LinkedHashMap<BOrd, Entity>();
        BOrd traverseBaseOrd = HierarchyUtil.getTraverseBaseOrd(parent);
        String filterExpression = relationDef.getFilterExpression().trim();
        BRelTime queryTimeout = this.hierarchyService.getHierarchyTimeout();
        for (String id : HierarchyUtil.RELATION_ID_SPLIT.split(relationDef.getOutboundRelationIds().trim())) {
            neql = HierarchyUtil.getTraverseNeqlPredicate(id, false, filterExpression);
            if (!neql.isPresent()) continue;
            HierarchyCacheBuilder.resolveTraverseQuery(neql.get(), relationDef, traverseBaseOrd, queryTimeout, context, results);
        }
        for (String id : HierarchyUtil.RELATION_ID_SPLIT.split(relationDef.getInboundRelationIds().trim())) {
            neql = HierarchyUtil.getTraverseNeqlPredicate(id, true, filterExpression);
            if (!neql.isPresent()) continue;
            HierarchyCacheBuilder.resolveTraverseQuery(neql.get(), relationDef, traverseBaseOrd, queryTimeout, context, results);
        }
        return new CloseableIteratorWrapper(results.values().iterator());
    }

    private static void resolveTraverseQuery(String neql, BRelationLevelDef relationDef, BOrd traverseBaseOrd, BRelTime queryTimeout, Context context, LinkedHashMap<BOrd, Entity> results) throws Exception {
        try (CloseableIterator<Entity> entities = QueryUtil.resolveQueryOnScopes(relationDef, BOrd.make((String)neql), traverseBaseOrd, queryTimeout, context);){
            while (entities.hasNext()) {
                Entity entity = (Entity)entities.next();
                Optional entityOrd = entity.getOrdToEntity();
                if (!entityOrd.isPresent()) continue;
                results.putIfAbsent((BOrd)entityOrd.get(), entity);
            }
        }
    }

    private static boolean areGroupingDefsValid(List<BIGroupingLevelDef> groupingDefs) {
        for (BIGroupingLevelDef groupingDef : groupingDefs) {
            if (groupingDef instanceof BListLevelDef) {
                BListLevelDef listDef = (BListLevelDef)groupingDef;
                if (((BNamedGroupDef[])listDef.getChildren(BNamedGroupDef.class)).length > 0) continue;
                BHierarchyService.log.warning(() -> "HierarchyCacheBuilder.getAllElements: BListLevelDef (" + listDef + ") has no named group defs; caching aborted");
                return false;
            }
            if (groupingDef instanceof BGroupLevelDef) continue;
            BHierarchyService.log.warning(() -> "HierarchyCacheBuilder.getAllElements: BIGroupingLevelDef type not supported: " + groupingDef);
            return false;
        }
        return true;
    }

    private static String generateGroupingBase(List<BIGroupingLevelDef> groupingDefs) {
        if (groupingDefs.isEmpty()) {
            return "";
        }
        StringBuilder groupingBase = new StringBuilder();
        for (BIGroupingLevelDef groupingDef : groupingDefs) {
            if (groupingDef instanceof BGroupLevelDef) {
                BGroupLevelDef groupDef = (BGroupLevelDef)groupingDef;
                groupingBase.append('(').append(groupDef.getGroupBy()).append(") and ");
                continue;
            }
            if (!(groupingDef instanceof BListLevelDef)) continue;
            BListLevelDef listDef = (BListLevelDef)groupingDef;
            groupingBase.append('(');
            StringJoiner namedGroupBys = new StringJoiner(" or ");
            for (BNamedGroupDef namedGroupDef : (BNamedGroupDef[])listDef.getChildren(BNamedGroupDef.class)) {
                namedGroupBys.add('(' + namedGroupDef.getQuery() + ')');
            }
            groupingBase.append(namedGroupBys).append(") and ");
        }
        return groupingBase.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CloseableIterator<Entity> gatherAllGroupDefValues(CloseableIterator<Entity> queryResults, ArrayList<BIGroupingLevelDef> groupingDefs, HashMap<BGroupLevelDef, LinkedHashSet<BIDataValue>> groupDefValues) throws Exception {
        LinkedList results = new LinkedList();
        try {
            queryResults.forEachRemaining(entity -> {
                results.add(entity);
                Tags entityTags = entity.tags();
                groupingDefs.stream().filter(groupingDef -> groupingDef instanceof BGroupLevelDef).forEach(groupingDef -> {
                    BGroupLevelDef groupDef = (BGroupLevelDef)groupingDef;
                    LinkedHashSet groupValues = groupDefValues.computeIfAbsent(groupDef, k -> new LinkedHashSet());
                    entityTags.get(Id.newId((String)groupDef.getGroupBy().trim())).ifPresent(groupValues::add);
                });
            });
        }
        finally {
            queryResults.close();
        }
        return new CloseableIteratorWrapper(results.iterator());
    }

    private LinkedList<BLevelElem> appendAllGroupingElems(BLevelElem parent, ArrayList<BIGroupingLevelDef> groupingDefs, HashMap<BGroupLevelDef, LinkedHashSet<BIDataValue>> groupDefValues, Context context) {
        LinkedList<BLevelElem> leafElems = new LinkedList<BLevelElem>();
        this.appendAllGroupingElems(parent, groupingDefs, 0, groupDefValues, leafElems, context);
        return leafElems;
    }

    private void appendAllGroupingElems(BLevelElem parent, ArrayList<BIGroupingLevelDef> groupingDefs, int groupingDefIndex, HashMap<BGroupLevelDef, LinkedHashSet<BIDataValue>> groupDefValues, LinkedList<BLevelElem> leafElems, Context context) {
        block5: {
            BIGroupingLevelDef groupingDef;
            block4: {
                groupingDef = groupingDefs.get(groupingDefIndex);
                if (!(groupingDef instanceof BGroupLevelDef)) break block4;
                BGroupLevelDef groupDef = (BGroupLevelDef)groupingDef;
                BIcon groupIcon = this.groupingIcons.computeIfAbsent(groupDef, MakeElemUtil::getGroupIcon);
                for (BIDataValue groupByValue : groupDefValues.get(groupDef)) {
                    BLevelElem child = MakeElemUtil.makeGroupElem(groupDef, parent, HierarchyUtil.getGroupingBase(groupDef, true, parent), MakeElemUtil.getGroupName(groupByValue, context), groupByValue, groupIcon);
                    this.appendElem(parent, child);
                    int nextIndex = groupingDefIndex + 1;
                    if (nextIndex >= groupingDefs.size()) {
                        leafElems.add(child);
                        continue;
                    }
                    this.appendAllGroupingElems(child, groupingDefs, nextIndex, groupDefValues, leafElems, context);
                }
                break block5;
            }
            if (!(groupingDef instanceof BListLevelDef)) break block5;
            BListLevelDef listDef = (BListLevelDef)groupingDef;
            String groupingBase = HierarchyUtil.getGroupingBase(listDef, true, parent);
            for (BNamedGroupDef namedGroupDef : (BNamedGroupDef[])listDef.getChildren(BNamedGroupDef.class)) {
                BLevelElem child = MakeElemUtil.makeListElem(listDef, namedGroupDef, parent, this.groupingIcons.computeIfAbsent(namedGroupDef, MakeElemUtil::getGroupIcon), groupingBase, context);
                this.appendElem(parent, child);
                int nextIndex = groupingDefIndex + 1;
                if (nextIndex >= groupingDefs.size()) {
                    leafElems.add(child);
                    continue;
                }
                this.appendAllGroupingElems(child, groupingDefs, nextIndex, groupDefValues, leafElems, context);
            }
        }
    }

    private LinkedList<BLevelElem> appendGroupElems(Entity entity, ArrayList<BIGroupingLevelDef> groupingDefs, HashMap<BLevelElem, HashMap<String, BLevelElem>> groupingElems, BLevelElem parent, Context queryContext) {
        HashMap<BGroupLevelDef, BIDataValue> groupDefMap = new HashMap<BGroupLevelDef, BIDataValue>();
        HashMap<BListLevelDef, LinkedList<BNamedGroupDef>> listDefMap = new HashMap<BListLevelDef, LinkedList<BNamedGroupDef>>();
        if (!HierarchyCacheBuilder.belongsToGroups(entity, groupingDefs, groupDefMap, listDefMap, queryContext)) {
            return null;
        }
        LinkedList<BLevelElem> leafElems = new LinkedList<BLevelElem>();
        this.appendGroupElems(parent, groupingDefs, 0, groupingElems, leafElems, groupDefMap, listDefMap, queryContext);
        return leafElems;
    }

    private static boolean belongsToGroups(Entity entity, List<BIGroupingLevelDef> groupingDefs, HashMap<BGroupLevelDef, BIDataValue> groupDefMap, HashMap<BListLevelDef, LinkedList<BNamedGroupDef>> listDefMap, Context queryContext) {
        NeqlEntityEvaluator evaluator = new NeqlEntityEvaluator();
        Tags entityTags = entity.tags();
        for (BIGroupingLevelDef groupingDef : groupingDefs) {
            if (groupingDef instanceof BGroupLevelDef) {
                BGroupLevelDef groupDef = (BGroupLevelDef)groupingDef;
                String groupBy = groupDef.getGroupBy();
                Optional groupTag = entityTags.get(Id.newId((String)groupBy.trim()));
                if (!groupTag.isPresent()) {
                    return false;
                }
                if (groupDefMap == null) continue;
                groupDefMap.put(groupDef, (BIDataValue)groupTag.get());
                continue;
            }
            if (!(groupingDef instanceof BListLevelDef)) continue;
            BListLevelDef listDef = (BListLevelDef)groupingDef;
            LinkedList<BNamedGroupDef> entityNamedGroupDefs = new LinkedList<BNamedGroupDef>();
            for (BNamedGroupDef namedGroupDef : (BNamedGroupDef[])listDef.getChildren(BNamedGroupDef.class)) {
                AstNode astNode = new NeqlQuery(namedGroupDef.getQuery()).getAst();
                if (astNode.getNodeType() != 1) {
                    BHierarchyService.log.fine(() -> "HierarchyCacheBuilder.getAllElements: BNamedGroupDef query, " + namedGroupDef.getQuery() + ", not a select type");
                    continue;
                }
                Expression booleanExpression = ((Select)astNode).getPredicate();
                if (!evaluator.evalBoolean(booleanExpression, entity, queryContext)) continue;
                entityNamedGroupDefs.add(namedGroupDef);
            }
            if (entityNamedGroupDefs.isEmpty()) {
                return false;
            }
            if (listDefMap == null) continue;
            listDefMap.put(listDef, entityNamedGroupDefs);
        }
        return true;
    }

    private void appendGroupElems(BLevelElem parent, ArrayList<BIGroupingLevelDef> groupingDefs, int groupingDefIndex, HashMap<BLevelElem, HashMap<String, BLevelElem>> groupingElems, LinkedList<BLevelElem> leafElems, HashMap<BGroupLevelDef, BIDataValue> groupDefMap, HashMap<BListLevelDef, LinkedList<BNamedGroupDef>> listDefMap, Context context) {
        HashMap childGroups = groupingElems.computeIfAbsent(parent, k -> new HashMap());
        BIGroupingLevelDef groupingDef = groupingDefs.get(groupingDefIndex);
        if (groupingDef instanceof BGroupLevelDef) {
            BGroupLevelDef groupDef = (BGroupLevelDef)groupingDef;
            BIDataValue groupByValue = groupDefMap.get(groupDef);
            BLevelElem child = childGroups.computeIfAbsent(MakeElemUtil.getGroupName(groupByValue, context), name -> {
                BLevelElem elem = MakeElemUtil.makeGroupElem(groupDef, parent, HierarchyUtil.getGroupingBase(groupDef, true, parent), name, groupByValue, this.groupingIcons.computeIfAbsent(groupDef, MakeElemUtil::getGroupIcon));
                this.appendElem(parent, elem);
                return elem;
            });
            int nextIndex = groupingDefIndex + 1;
            if (nextIndex >= groupingDefs.size()) {
                leafElems.add(child);
            } else {
                this.appendGroupElems(child, groupingDefs, nextIndex, groupingElems, leafElems, groupDefMap, listDefMap, context);
            }
        } else if (groupingDef instanceof BListLevelDef) {
            BListLevelDef listDef = (BListLevelDef)groupingDef;
            String groupingBase = HierarchyUtil.getGroupingBase(listDef, true, parent);
            for (BNamedGroupDef namedGroupDef : listDefMap.get(listDef)) {
                BLevelElem child = childGroups.computeIfAbsent(namedGroupDef.getName(), k -> {
                    BLevelElem elem = MakeElemUtil.makeListElem(listDef, namedGroupDef, parent, this.groupingIcons.computeIfAbsent(namedGroupDef, MakeElemUtil::getGroupIcon), groupingBase, context);
                    this.appendElem(parent, elem);
                    return elem;
                });
                int nextIndex = groupingDefIndex + 1;
                if (nextIndex >= groupingDefs.size()) {
                    leafElems.add(child);
                    continue;
                }
                this.appendGroupElems(child, groupingDefs, nextIndex, groupingElems, leafElems, groupDefMap, listDefMap, context);
            }
        }
    }

    private void appendElem(BLevelElem parent, BLevelElem child) {
        child.setCategoryMask(BCategoryMask.NULL, null);
        parent.fw(1301, child, null, null, null);
        this.cachedElems.add(child);
        this.cachedElemChildCounts.compute(parent, (k, v) -> {
            int n;
            if (v == null) {
                n = 0;
            } else {
                v = v + 1;
                n = v;
            }
            return n;
        });
    }

    private static void setElemAndAncestorPermissions(BLevelElem elem, Entity entity) {
        BLevelElem parentElem;
        BLevelDef def;
        BCategoryMask entityMask = BCategoryMask.NULL;
        if (entity instanceof BComponent) {
            entityMask = ((BComponent)entity).getAppliedCategoryMask();
        }
        elem.setCategoryMask(entityMask, null);
        BINavNode parent = elem.getNavParent();
        while (parent instanceof BLevelElem && (def = (BLevelDef)((Object)(parentElem = (BLevelElem)parent).fw(1303))) instanceof BIGroupingLevelDef) {
            BCategoryMask groupMask = BCategoryMask.or((BCategoryMask)parentElem.getAppliedCategoryMask(), (BCategoryMask)entityMask);
            parentElem.setCategoryMask(groupMask, null);
            parent = parentElem.getNavParent();
        }
    }

    private void estimateCacheSize() {
        this.cacheSizeEstimate = 0L;
        this.visitedFacets.clear();
        this.visitedFacetValues.clear();
        for (BLevelElem elem : this.cachedElems) {
            this.cacheSizeEstimate += 40L;
            this.cacheSizeEstimate += 24L;
            Integer childCount = this.cachedElemChildCounts.get(elem);
            if (childCount != null) {
                this.cacheSizeEstimate += (long)HierarchyCacheBuilder.sizeOfObjectArray(childCount);
            }
            this.cacheSizeEstimate += 120L;
            this.cacheSizeEstimate += (long)HierarchyCacheBuilder.sizeOfString(elem.getElemName());
            this.cacheSizeEstimate += (long)this.sizeOfFacets(elem.getContextParams());
            this.cacheSizeEstimate += (long)this.sizeOfFacets(elem.getElemTags());
        }
    }

    private static int sizeOfCharArray(int length) {
        int sizePlusElems = 16 + length * 2;
        return sizePlusElems + HierarchyCacheBuilder.getPadding(sizePlusElems);
    }

    private static int sizeOfObjectArray(int length) {
        int sizePlusElems = 16 + length * 4;
        return sizePlusElems + HierarchyCacheBuilder.getPadding(sizePlusElems);
    }

    private static int getPadding(int dataSize) {
        return (8 - dataSize % 8) % 8;
    }

    private static int sizeOfString(String string) {
        return 24 + HierarchyCacheBuilder.sizeOfCharArray(string.length());
    }

    private int sizeOfDataValue(BObject value) {
        if (this.visitedFacetValues.containsKey(value)) {
            return 0;
        }
        this.visitedFacetValues.put(value, value);
        if (value instanceof BString) {
            return 16 + HierarchyCacheBuilder.sizeOfString(((BString)value).getString());
        }
        if (value instanceof BOrd) {
            return 24 + HierarchyCacheBuilder.sizeOfString(((BOrd)value).encodeToString());
        }
        return 0;
    }

    private int sizeOfFacets(BFacets facets) {
        String[] keys;
        if (this.visitedFacets.containsKey(facets)) {
            return 0;
        }
        this.visitedFacets.put(facets, facets);
        int size = 32;
        size += HierarchyCacheBuilder.sizeOfObjectArray(facets.size());
        for (String key : keys = facets.list()) {
            size += HierarchyCacheBuilder.sizeOfString(key);
        }
        size += HierarchyCacheBuilder.sizeOfObjectArray(facets.size());
        for (String key : keys) {
            size += this.sizeOfDataValue(facets.get(key));
        }
        try {
            size += HierarchyCacheBuilder.sizeOfString(facets.encodeToString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return size;
    }
}

