/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hierarchy;

import com.tridium.hierarchy.BHierarchyCacheStatus;
import com.tridium.hierarchy.HierarchyCacheBuilder;
import com.tridium.hierarchy.IHierarchyCacheBuilder;
import javax.baja.hierarchy.BHierarchy;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.job.BJobService;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="hierarchyName", type="String", defaultValue="", flags=7)
public class BHierarchyCachingJob
extends BSimpleJob {
    @Generated
    public static final Property hierarchyName = BHierarchyCachingJob.newProperty((int)7, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHierarchyCachingJob.class);
    private BHierarchy hierarchy;
    private IHierarchyCacheBuilder cacheBuilder;
    private static final BLevelDef[] EMPTY_LEVEL_DEFS = new BLevelDef[0];

    @Generated
    public String getHierarchyName() {
        return this.getString(hierarchyName);
    }

    @Generated
    public void setHierarchyName(String v) {
        this.setString(hierarchyName, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHierarchyCachingJob() {
        this.hierarchy = null;
        this.cacheBuilder = null;
    }

    public BHierarchyCachingJob(BHierarchy hierarchy, IHierarchyCacheBuilder cacheBuilder) {
        this.hierarchy = hierarchy;
        this.cacheBuilder = cacheBuilder;
    }

    public BOrd submit(Context context) {
        if (this.cacheBuilder == null) {
            throw new IllegalStateException("Must submit through hierarchy createCache action");
        }
        if (this.hierarchy != null) {
            this.setHierarchyName(this.hierarchy.getName());
        }
        BComponent jobService = (BComponent)BJobService.getService();
        for (BHierarchyCachingJob existingJob : (BHierarchyCachingJob[])jobService.getChildren(BHierarchyCachingJob.class)) {
            if (!existingJob.isAlive() || this.hierarchy != existingJob.hierarchy) continue;
            this.log().message("hierarchy", "hierarchyCachingJob.cancellingExisting");
            existingJob.cancel();
        }
        return super.submit(context);
    }

    public void run(Context context) throws Exception {
        if (this.cacheBuilder == null) {
            throw new IllegalStateException("Must submit through hierarchy createCache action");
        }
        String displayName = this.hierarchy.getDisplayName(context);
        this.log().start("hierarchy", "hierarchyCachingJob.startJob", new String[]{displayName});
        try {
            BLevelDef[] levelDefs;
            long cacheSizeEstimate;
            int elemCount;
            this.hierarchy.setCacheStatus(BHierarchyCacheStatus.caching);
            BLevelElem hierarchyRoot = this.cacheBuilder.buildCache(context);
            if (this.isAlive()) {
                elemCount = 0;
                cacheSizeEstimate = 0L;
                levelDefs = EMPTY_LEVEL_DEFS;
                if (this.cacheBuilder instanceof HierarchyCacheBuilder) {
                    elemCount = ((HierarchyCacheBuilder)this.cacheBuilder).getElemCount();
                    cacheSizeEstimate = ((HierarchyCacheBuilder)this.cacheBuilder).getCacheSizeEstimate();
                    levelDefs = ((HierarchyCacheBuilder)this.cacheBuilder).getLevelDefs();
                }
            } else {
                throw new JobCancelException();
            }
            this.hierarchy.fw(1304, hierarchyRoot, elemCount, cacheSizeEstimate, levelDefs);
            this.log().endSuccess("baja", "success", null);
            this.hierarchy = null;
            this.cacheBuilder = null;
        }
        catch (Throwable e) {
            try {
                this.hierarchy.setCacheStatus(BHierarchyCacheStatus.cachingFailed);
                this.log().endFailed("baja", "failed", null, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.hierarchy = null;
                this.cacheBuilder = null;
                this.log().message("hierarchy", "hierarchyCachingJob.endJob", new String[]{displayName});
                throw throwable;
            }
        }
        this.log().message("hierarchy", "hierarchyCachingJob.endJob", new String[]{displayName});
    }

    public String toString(Context cx) {
        return super.toString(cx) + " - " + this.getHierarchyName();
    }
}

