/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.tags.px;

import com.tridium.exporttags.BNiagaraExportTag;
import com.tridium.exporttags.tags.BFileImportTag;
import com.tridium.exporttags.tags.px.BPxViewTagValidationJob;
import com.tridium.exporttags.tags.px.BSubstitutePxView;
import com.tridium.exporttags.util.BJobNotification;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.exporttags.util.OrdVariableProcessor;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.file.BFileOverwritePolicy;
import com.tridium.nd.file.BNiagaraFileImport;
import com.tridium.nd.ui.px.BAbstractSubstitutePxView;
import com.tridium.nd.util.BSimpleMap;
import com.tridium.nv.NiagaraVirtualUtil;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.baja.agent.BPxView;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.history.HistoryQuery;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.ViewQuery;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pxView", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"wbutil:PxViewSelectFE\"")}), @NiagaraProperty(name="requiredPermissions", type="BPermissions", defaultValue="BPermissions.operatorRead"), @NiagaraProperty(name="orderNumber", type="int", defaultValue="0"), @NiagaraProperty(name="createFileImport", type="boolean", defaultValue="true"), @NiagaraProperty(name="fileImportName", type="BFormat", defaultValue="BFormat.make(\"%defaultFileImportName%\")"), @NiagaraProperty(name="fileImportOverwritePolicy", type="BFileOverwritePolicy", defaultValue="BFileOverwritePolicy.checksum"), @NiagaraProperty(name="fileImportExecutionTime", type="BTriggerMode", defaultValue="BManualTriggerMode.make()"), @NiagaraProperty(name="fileImportUseCategoryMask", type="boolean", defaultValue="true"), @NiagaraProperty(name="supervisorPxFileDirectory", type="BOrd", defaultValue="BOrd.make(\"file:^nstations$(stationName)$(currentLocation)\")", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"exportTags:OrdVariableFE\"")}), @NiagaraProperty(name="supervisorPxFileMediaDirectory", type="BOrd", defaultValue="BOrd.make(\"file:^nstations$(stationName)$(currentLocation)\")", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"exportTags:OrdVariableFE\"")}), @NiagaraProperty(name="substituteOverrideOrds", type="BSimpleMap", defaultValue="BSimpleMap.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"exportTags:SubstituteOrdsFE\"")})})
@NiagaraAction(name="validate")
public final class BPxViewTag
extends BNiagaraExportTag {
    @Generated
    public static final Property pxView = BPxViewTag.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"wbutil:PxViewSelectFE"));
    @Generated
    public static final Property requiredPermissions = BPxViewTag.newProperty((int)0, (BValue)BPermissions.operatorRead, null);
    @Generated
    public static final Property orderNumber = BPxViewTag.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property createFileImport = BPxViewTag.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property fileImportName = BPxViewTag.newProperty((int)0, (BValue)BFormat.make((String)"%defaultFileImportName%"), null);
    @Generated
    public static final Property fileImportOverwritePolicy = BPxViewTag.newProperty((int)0, (BValue)BFileOverwritePolicy.checksum, null);
    @Generated
    public static final Property fileImportExecutionTime = BPxViewTag.newProperty((int)0, (BValue)BManualTriggerMode.make(), null);
    @Generated
    public static final Property fileImportUseCategoryMask = BPxViewTag.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property supervisorPxFileDirectory = BPxViewTag.newProperty((int)0, (BValue)BOrd.make((String)"file:^nstations$(stationName)$(currentLocation)"), (BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:OrdVariableFE"));
    @Generated
    public static final Property supervisorPxFileMediaDirectory = BPxViewTag.newProperty((int)0, (BValue)BOrd.make((String)"file:^nstations$(stationName)$(currentLocation)"), (BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:OrdVariableFE"));
    @Generated
    public static final Property substituteOverrideOrds = BPxViewTag.newProperty((int)0, (BValue)BSimpleMap.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:SubstituteOrdsFE"));
    @Generated
    public static final Action validate = BPxViewTag.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPxViewTag.class);

    @Generated
    public String getPxView() {
        return this.getString(pxView);
    }

    @Generated
    public void setPxView(String v) {
        this.setString(pxView, v, null);
    }

    @Generated
    public BPermissions getRequiredPermissions() {
        return (BPermissions)this.get(requiredPermissions);
    }

    @Generated
    public void setRequiredPermissions(BPermissions v) {
        this.set(requiredPermissions, (BValue)v, null);
    }

    @Generated
    public int getOrderNumber() {
        return this.getInt(orderNumber);
    }

    @Generated
    public void setOrderNumber(int v) {
        this.setInt(orderNumber, v, null);
    }

    @Generated
    public boolean getCreateFileImport() {
        return this.getBoolean(createFileImport);
    }

    @Generated
    public void setCreateFileImport(boolean v) {
        this.setBoolean(createFileImport, v, null);
    }

    @Generated
    public BFormat getFileImportName() {
        return (BFormat)this.get(fileImportName);
    }

    @Generated
    public void setFileImportName(BFormat v) {
        this.set(fileImportName, (BValue)v, null);
    }

    @Generated
    public BFileOverwritePolicy getFileImportOverwritePolicy() {
        return (BFileOverwritePolicy)this.get(fileImportOverwritePolicy);
    }

    @Generated
    public void setFileImportOverwritePolicy(BFileOverwritePolicy v) {
        this.set(fileImportOverwritePolicy, (BValue)v, null);
    }

    @Generated
    public BTriggerMode getFileImportExecutionTime() {
        return (BTriggerMode)this.get(fileImportExecutionTime);
    }

    @Generated
    public void setFileImportExecutionTime(BTriggerMode v) {
        this.set(fileImportExecutionTime, (BValue)v, null);
    }

    @Generated
    public boolean getFileImportUseCategoryMask() {
        return this.getBoolean(fileImportUseCategoryMask);
    }

    @Generated
    public void setFileImportUseCategoryMask(boolean v) {
        this.setBoolean(fileImportUseCategoryMask, v, null);
    }

    @Generated
    public BOrd getSupervisorPxFileDirectory() {
        return (BOrd)this.get(supervisorPxFileDirectory);
    }

    @Generated
    public void setSupervisorPxFileDirectory(BOrd v) {
        this.set(supervisorPxFileDirectory, (BValue)v, null);
    }

    @Generated
    public BOrd getSupervisorPxFileMediaDirectory() {
        return (BOrd)this.get(supervisorPxFileMediaDirectory);
    }

    @Generated
    public void setSupervisorPxFileMediaDirectory(BOrd v) {
        this.set(supervisorPxFileMediaDirectory, (BValue)v, null);
    }

    @Generated
    public BSimpleMap getSubstituteOverrideOrds() {
        return (BSimpleMap)this.get(substituteOverrideOrds);
    }

    @Generated
    public void setSubstituteOverrideOrds(BSimpleMap v) {
        this.set(substituteOverrideOrds, (BValue)v, null);
    }

    @Generated
    public void validate() {
        this.invoke(validate, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (this.isMounted()) {
            if (slot == pxView) {
                return BFacets.make((BFacets)super.getSlotFacets(slot), (String)"handleOrd", (BIDataValue)BString.make((String)((BComponent)this.getParent()).getHandleOrd().toString()));
            }
            if (slot == substituteOverrideOrds) {
                return BFacets.make((BFacets)super.getSlotFacets(slot), (String)"handleOrd", (BIDataValue)BString.make((String)this.getHandleOrd().toString()));
            }
        }
        return super.getSlotFacets(slot);
    }

    protected Type getFolderType() {
        return BFolder.TYPE;
    }

    protected void doJoin(BINiagaraStation station, BJob job, Subscriber sub, BCategoryMask mask, Context cx) throws Exception {
        if (this.getPxView().length() == 0) {
            throw new ExportTagException("pxViewExpTag.noPxViewSelected");
        }
        BNiagaraStation niagaraStation = (BNiagaraStation)station;
        if (!niagaraStation.getVirtualsEnabled()) {
            niagaraStation.setBoolean(BNiagaraStation.virtualsEnabled, true, cx);
            job.log().message(this.getType().getModule().getModuleName(), "pxViewExpTag.enabledVirtuals");
        }
        BComponent base = (BComponent)this.getParent();
        sub.subscribe(base);
        BOrd virtualBaseOrd = BOrd.make((BOrd)niagaraStation.getHandleOrd(), (String)"slot:virtual");
        String stationName = niagaraStation.getName();
        PxOrdVisitor visitor = new PxOrdVisitor(virtualBaseOrd, job, stationName, base);
        BIFile sourcePxFile = this.startProcessPx(visitor);
        OrdVariableProcessor processor = new OrdVariableProcessor();
        processor.add((OrdVariableProcessor.IVarHandler)new OrdVariableProcessor.Replace("stationName", "/" + stationName));
        processor.add((OrdVariableProcessor.IVarHandler)new BFileImportTag.CurrentLocationHandler(sourcePxFile));
        BOrd newPxFileOrd = BOrd.make((String)(processor.process(this.getSupervisorPxFileDirectory()).toString() + "/" + sourcePxFile.getFileName()));
        if (this.getCreateFileImport()) {
            visitor.getOrdFileMap().put(newPxFileOrd, BOrd.make((OrdQuery)sourcePxFile.getFilePath()));
            BSimpleMap fileImpMap = BSimpleMap.make((Map)visitor.getOrdFileMap());
            String fileImpName = this.getFileImportName().format((Object)this);
            if (!SlotPath.isValidName((String)fileImpName)) {
                fileImpName = SlotPath.escape((String)fileImpName);
            }
            BNiagaraFileImport imp = (BNiagaraFileImport)NiagaraVirtualUtil.findInstance((BComponent)niagaraStation.getFiles(), (String)fileImpName, (Type)BNiagaraFileImport.TYPE);
            imp.set(BNiagaraFileImport.fileOverwritePolicy, (BValue)this.getFileImportOverwritePolicy(), cx);
            imp.getExecutionTime().set(BTimeTrigger.triggerMode, (BValue)this.getFileImportExecutionTime(), cx);
            imp.set(BNiagaraFileImport.files, (BValue)fileImpMap, cx);
            if (this.getFileImportUseCategoryMask()) {
                BCategoryService categoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
                BOrdToCategoryMap map = categoryService.getOrdMap();
                BOrd[] supFileOrds = visitor.getSupFileOrds();
                for (int i = 0; i < supFileOrds.length; ++i) {
                    map = map.setCategoryMask(supFileOrds[i], mask);
                }
                categoryService.setOrdMap(map);
            }
            this.addTarget((BComponent)niagaraStation.getFiles(), fileImpName, (BComplex)imp, cx);
            imp.doExecute();
        } else {
            job.log().message(this.getType().getModule().getModuleName(), "pxViewExpTag.noPxFilesCopied");
        }
        final BOrd slotPathOrd = BOrd.make((BOrd)this.getParent().asComponent().getSlotPathOrd(), (BOrd)BOrd.make((OrdQuery)new ViewQuery(this.getPxView())));
        IFilter filter = new IFilter(){

            public boolean accept(Object obj) {
                BSubstitutePxView v;
                return obj instanceof BSubstitutePxView && (v = (BSubstitutePxView)((Object)obj)).getSourceSlotPathOrd().equals((Object)slotPathOrd);
            }
        };
        BSubstitutePxView view = (BSubstitutePxView)NiagaraVirtualUtil.findInstance((BComponent)this.getTargetParent(), (IFilter)filter, (Type)BSubstitutePxView.TYPE);
        BPxView sourceView = this.findPxView();
        view.set(BSubstitutePxView.sourceSlotPathOrd, (BValue)slotPathOrd, cx);
        view.setInt(BSubstitutePxView.orderNumber, this.getOrderNumber(), cx);
        view.set(BSubstitutePxView.requiredPermissions, (BValue)this.getRequiredPermissions(), cx);
        view.set(BSubstitutePxView.media, (BValue)sourceView.getMedia(), cx);
        view.set(BSubstitutePxView.icon, (BValue)sourceView.getIcon(), cx);
        view.set(BSubstitutePxView.pxFile, (BValue)newPxFileOrd, cx);
        view.set(BSubstitutePxView.substituteOrds, (BValue)BSimpleMap.make((Map)visitor.getOrdMap()), cx);
        String name = view.getName();
        boolean addedNew = false;
        if (name == null) {
            name = BPxViewTag.getUniqueName((BComponent)this.getTargetParent(), (String)this.getPxView());
            addedNew = true;
        }
        int originalFlags = sourceView.getParent().getFlags((Slot)sourceView.getPropertyInParent());
        this.addTarget(name, (BComplex)view, originalFlags | 1, cx);
        if (addedNew) {
            job.log().message(this.getType().getModule().getModuleName(), "pxViewExpTag.addedPxView", view.getName());
        }
        job.log().message(this.getType().getModule().getModuleName(), "pxViewExpTag.completedPxView", String.valueOf(visitor.failureCount));
        this.reorderPxViews(cx);
    }

    public void doValidate(Context cx) {
        BJobNotification notify = new BJobNotification(new BPxViewTagValidationJob(this).submit(cx));
        notify.raise(false);
    }

    public BIFile startProcessPx(BAbstractSubstitutePxView.IPxOrdVisitor visitor) throws Exception {
        BPxView currentView = this.findPxView();
        BIFile sourcePxFile = (BIFile)currentView.getPxFile().get((BObject)this);
        PxDecoder decoder = new PxDecoder(sourcePxFile);
        BWidget root = decoder.decodeDocument();
        decoder.close();
        BAbstractSubstitutePxView.processPx((BComplex)root, (BObject)this, null, (BAbstractSubstitutePxView.IPxOrdVisitor)visitor, (BSimpleMap)this.getSubstituteOverrideOrds(), null);
        return sourcePxFile;
    }

    private BPxView findPxView() throws Exception {
        if (this.getPxView().length() == 0) {
            throw new ExportTagException("pxViewExpTag.noPxViewSelected");
        }
        BComponent base = (BComponent)this.getParent();
        BValue val = base.get(this.getPxView());
        if (val != null) {
            if (!val.getType().is(BPxView.TYPE)) {
                throw new ExportTagException("pxViewExpTag.pxViewPropNoType", val.getType().toString());
            }
        } else {
            throw new ExportTagException("pxViewExpTag.noPxView", this.getPxView().toString());
        }
        return (BPxView)val;
    }

    private void reorderPxViews(Context cx) {
        Property[] dynProps = this.getTargetParent().getDynamicPropertiesArray();
        Array propArray = new Array(Property.class);
        Array subPropArray = new Array(Property.class);
        for (int i = 0; i < dynProps.length; ++i) {
            if (dynProps[i].getType().is(BSubstitutePxView.TYPE)) {
                subPropArray.add((Object)dynProps[i]);
                continue;
            }
            propArray.add((Object)dynProps[i]);
        }
        subPropArray = subPropArray.sort((Comparator)new ViewOrderComparator(this.getTargetParent()));
        ListIterator it = subPropArray.iterator();
        while (it.hasNext()) {
            propArray.add(0, it.next());
        }
        try {
            this.getTargetParent().reorder((Property[])propArray.trim(), cx);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDefaultFileImportName() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getParent().getName());
        buff.append("_");
        buff.append(this.getPxView());
        buff.append("_");
        buff.append("Import");
        return buff.toString();
    }

    private static class ViewOrderComparator
    implements Comparator<Property> {
        private BComponent comp;

        ViewOrderComparator(BComponent comp) {
            this.comp = comp;
        }

        @Override
        public int compare(Property arg1, Property arg2) {
            BSubstitutePxView view1 = (BSubstitutePxView)this.comp.get(arg1);
            BSubstitutePxView view2 = (BSubstitutePxView)this.comp.get(arg2);
            if (view1.getOrderNumber() == view2.getOrderNumber()) {
                return 0;
            }
            if (view1.getOrderNumber() > view2.getOrderNumber()) {
                return 1;
            }
            return -1;
        }
    }

    private final class PxOrdVisitor
    implements BAbstractSubstitutePxView.IPxOrdVisitor {
        private Map<BOrd, BOrd> ordMap = new LinkedHashMap<BOrd, BOrd>();
        private Map<BOrd, BOrd> ordFileMap = new LinkedHashMap<BOrd, BOrd>();
        private BOrd virtualBaseOrd;
        private BJob job;
        private String stationName;
        private BComponent base;
        private int failureCount = 0;

        PxOrdVisitor(BOrd virtualBaseOrd, BJob job, String stationName, BComponent base) {
            this.virtualBaseOrd = virtualBaseOrd;
            this.job = job;
            this.stationName = stationName;
            this.base = base;
        }

        public boolean handlePreprocessOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
            return this.ordMap.get(ord) == null;
        }

        public void handleVirtualOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
            try {
                BOrd newOrd = BOrd.make((BOrd)this.virtualBaseOrd, (BOrd)NiagaraVirtualUtil.convertOrdTargetToClientVirtual((OrdTarget)ord.resolve((BObject)this.base)));
                this.ordMap.put(ord, newOrd);
            }
            catch (Exception e) {
                ++this.failureCount;
                this.job.log().failed(BPxViewTag.this.getType().getModule().getModuleName(), "pxViewExpTag.couldNotResolveOrd", ord.toString(), (Throwable)e);
            }
        }

        public void handleHyperlinkOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
        }

        public void handleFileOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
            try {
                ord.resolve((BObject)this.base);
                BIFile sourceFile = (BIFile)BOrd.make((OrdQuery)queries[queryIndex]).get((BObject)this.base);
                OrdVariableProcessor processor = new OrdVariableProcessor();
                processor.add((OrdVariableProcessor.IVarHandler)new OrdVariableProcessor.Replace("stationName", "/" + this.stationName));
                processor.add((OrdVariableProcessor.IVarHandler)new BFileImportTag.CurrentLocationHandler(sourceFile));
                BOrd newFileOrd = BOrd.make((String)(processor.process(BPxViewTag.this.getSupervisorPxFileMediaDirectory()).toString() + "/" + sourceFile.getFileName()));
                queries[queryIndex] = newFileOrd.parse()[0];
                newFileOrd = BOrd.make((OrdQuery[])queries);
                this.ordFileMap.put(newFileOrd, BOrd.make((OrdQuery)sourceFile.getFilePath()));
                if (!ord.equals((Object)newFileOrd)) {
                    this.ordMap.put(ord, newFileOrd);
                }
            }
            catch (Exception e) {
                ++this.failureCount;
                this.job.log().failed(BPxViewTag.this.getType().getModule().getModuleName(), "pxViewExpTag.couldNotResolveFileOrd", ord.toString(), (Throwable)e);
            }
        }

        public void handleModuleOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
            try {
                ord.resolve();
            }
            catch (Exception e) {
                ++this.failureCount;
                this.job.log().failed(BPxViewTag.this.getType().getModule().getModuleName(), "pxViewExpTag.couldNotResolveModuleOrd", ord.toString(), (Throwable)e);
            }
        }

        public void handleHistoryOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
            try {
                ord.resolve((BObject)this.base);
                HistoryQuery query = (HistoryQuery)queries[queryIndex];
                if (query.getDeviceName().equals("^")) {
                    queries[queryIndex] = new HistoryQuery("@" + query.getHistoryName());
                    BOrd newHistoryOrd = BOrd.make((OrdQuery[])queries);
                    if (!ord.equals((Object)newHistoryOrd)) {
                        this.ordMap.put(ord, newHistoryOrd);
                    }
                }
            }
            catch (Exception e) {
                ++this.failureCount;
                this.job.log().failed(BPxViewTag.this.getType().getModule().getModuleName(), "pxViewExpTag.couldNotResolveHistoryOrd", ord.toString(), (Throwable)e);
            }
        }

        public void handleUnknownOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
            ++this.failureCount;
            this.job.log().failed(BPxViewTag.this.getType().getModule().getModuleName(), "pxViewExpTag.ordNotSupported", ord.toString());
        }

        public void handleOverrideOrd(BComplex clx, Property prop, BOrd ord, BOrd overrideOrd) throws Exception {
            if (this.ordMap.get(ord) == null) {
                this.ordMap.put(ord, overrideOrd);
            }
        }

        private Map<BOrd, BOrd> getOrdMap() {
            return this.ordMap;
        }

        private Map<BOrd, BOrd> getOrdFileMap() {
            return this.ordFileMap;
        }

        private BOrd[] getSupFileOrds() {
            return this.ordFileMap.keySet().toArray(new BOrd[0]);
        }
    }
}

