/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.xml;

import com.tridiumX.knxnetIp.ets.enums.BEtsAttributeTypeEnum;
import javax.baja.sys.Property;

public final class XmlPropertyImportSpec {
    private String propertyName;
    private String elementName;
    private String attributeName;
    private BEtsAttributeTypeEnum attributeType = BEtsAttributeTypeEnum.DEFAULT;
    private boolean attributeIsOptional;
    private String defaultValue;

    private XmlPropertyImportSpec() {
    }

    public static XmlPropertyImportSpec make(Property property, String elementName, String attributeName, BEtsAttributeTypeEnum attributeType) {
        return XmlPropertyImportSpec.factory(property, elementName, attributeName, attributeType, false, "");
    }

    public static XmlPropertyImportSpec make(Property property, String elementName, String attributeName, BEtsAttributeTypeEnum attributeType, boolean attributeIsOptional) {
        return XmlPropertyImportSpec.factory(property, elementName, attributeName, attributeType, attributeIsOptional, "");
    }

    public static XmlPropertyImportSpec make(Property property, String elementName, String attributeName, BEtsAttributeTypeEnum attributeType, boolean attributeIsOptional, String defaultValue) {
        return XmlPropertyImportSpec.factory(property, elementName, attributeName, attributeType, attributeIsOptional, defaultValue);
    }

    private static XmlPropertyImportSpec factory(Property property, String elementName, String attributeName, BEtsAttributeTypeEnum attributeType, boolean attributeIsOptional, String defaultValue) {
        XmlPropertyImportSpec spec = new XmlPropertyImportSpec();
        spec.propertyName = property.getName();
        spec.elementName = elementName;
        spec.attributeName = attributeName;
        spec.attributeType = attributeType;
        spec.attributeIsOptional = attributeIsOptional;
        spec.defaultValue = defaultValue;
        return spec;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public BEtsAttributeTypeEnum getAttributeType() {
        return this.attributeType;
    }

    public boolean getAttributeIsOptional() {
        return this.attributeIsOptional;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

