/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui.editors;

import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyle;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextController;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"knxnetIp:IndividualDeviceAddress"})})
@NiagaraActions(value={@NiagaraAction(name="propagateFocusEvent", parameterType="BFocusEvent", defaultValue="new BFocusEvent()", flags=4), @NiagaraAction(name="propagateKeyEvent", parameterType="BKeyEvent", defaultValue="new BKeyEvent()", flags=4), @NiagaraAction(name="propagateMouseEvent", parameterType="BMouseEvent", defaultValue="new BMouseEvent()", flags=4)})
public class BIndividualDeviceAddressFE
extends BWbFieldEditor {
    public static final Action propagateFocusEvent = BIndividualDeviceAddressFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    public static final Action propagateKeyEvent = BIndividualDeviceAddressFE.newAction((int)4, (BValue)new BKeyEvent(), null);
    public static final Action propagateMouseEvent = BIndividualDeviceAddressFE.newAction((int)4, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BIndividualDeviceAddressFE.class);
    private final BTextField field = new BTextField("", 9);

    public void propagateFocusEvent(BFocusEvent parameter) {
        this.invoke(propagateFocusEvent, (BValue)parameter, null);
    }

    public void propagateKeyEvent(BKeyEvent parameter) {
        this.invoke(propagateKeyEvent, (BValue)parameter, null);
    }

    public void propagateMouseEvent(BMouseEvent parameter) {
        this.invoke(propagateMouseEvent, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIndividualDeviceAddressFE() {
        this.field.setController((TextController)new Controller());
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.field, (Slot)BTextField.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo("lk3", (BComponent)this.field, (Slot)BTextField.keyEvent, (Slot)propagateKeyEvent);
        this.linkTo("lk4", (BComponent)this.field, (Slot)BTextField.mouseEvent, (Slot)propagateMouseEvent);
        this.setContent((BWidget)this.field);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.field.setText(value.toString(cx));
        TextController ctrlr = this.field.getController();
        BKnxAddressStyle addressStyle = ((BKnxAddress)value).getAddressStyle();
        ((Controller)ctrlr).setAddressStyle(addressStyle);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BIndividualDeviceAddress gp = (BIndividualDeviceAddress)value;
        String s = this.field.getText();
        try {
            gp.setFriendlyAddress(s);
        }
        catch (Exception ex) {
            throw new CannotSaveException("Improper 'GroupAddress' format.\n" + ex.getLocalizedMessage());
        }
        return gp;
    }

    public void setEnabled(boolean value) {
        this.field.setEditable(value);
    }

    protected void doSetReadonly(boolean readonly) {
        this.setEnabled(!readonly);
    }

    public void doPropagateFocusEvent(BFocusEvent evt) {
        this.fireFocusEvent(new BFocusEvent(evt.getId(), (BWidget)this, evt.isTemporary()));
    }

    public void doPropagateKeyEvent(BKeyEvent evt) {
        this.fireKeyEvent(new BKeyEvent(evt.getId(), (BWidget)this, evt.getModifiers(), evt.getKeyCode(), evt.getKeyChar()));
    }

    public void doPropagateMouseEvent(BMouseEvent evt) {
        this.fireMouseEvent(new BMouseEvent(evt.getId(), (BWidget)this, evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger()));
    }

    private class Controller
    extends TextController {
        private BKnxAddressStyle addressStyle;

        private Controller() {
        }

        public void setAddressStyle(BKnxAddressStyle addressStyle) {
            this.addressStyle = addressStyle;
        }

        public void keyTyped(BKeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == ' ') {
                keyChar = this.addressStyle.getSeparator();
                int modifiers = event.getModifiers();
                int keyCode = event.getKeyCode();
                int id = event.getId();
                BWidget source = event.getWidget();
                event.consume();
                super.keyTyped(new BKeyEvent(id, source, modifiers, keyCode, keyChar));
            } else {
                super.keyTyped(event);
            }
            this.valid(((BTextEditor)event.getWidget()).getText());
        }

        protected boolean valid(String updatedText) {
            boolean valid = true;
            int slashes = 0;
            int digit = 0;
            int positionOfLastSlash = -1;
            for (int i = 0; valid && i < updatedText.length(); ++i) {
                char c = updatedText.charAt(i);
                if (c == this.addressStyle.getSeparator()) {
                    if (i == 0 || positionOfLastSlash == i - 1) {
                        valid = false;
                    }
                    if (++slashes >= this.addressStyle.getFieldLengths().length) {
                        valid = false;
                    }
                    digit = 0;
                    positionOfLastSlash = i;
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (!(slashes == 0 && digit > 2 || slashes == 1 && digit > 4) && (slashes != 2 || ++digit <= 3)) continue;
                    valid = false;
                    continue;
                }
                valid = false;
            }
            try {
                if (valid) {
                    this.addressStyle.getFriendlyAddress(updatedText);
                }
            }
            catch (IllegalArgumentException ex) {
                valid = false;
            }
            this.setOkButtonEnabled(valid);
            return true;
        }

        protected void setOkButtonEnabled(boolean b) {
            BWidget[] aWidgets;
            for (BWidget widget : aWidgets = this.getShell().getChildWidgets()) {
                if (!"okButton".equals(widget.getName())) continue;
                widget.setEnabled(b);
            }
        }
    }
}

