/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ets.project;

import com.tridiumX.knxnetIp.enums.BKnxComObjectSizeEnum;
import com.tridiumX.knxnetIp.ets.BEtsImportableComponent;
import com.tridiumX.knxnetIp.ets.BEtsProjectFile;
import com.tridiumX.knxnetIp.ets.enums.BEtsAttributeTypeEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsComObjectPriorityEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsEnableEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsNameSpaceEnum;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsApplicationProgramRef;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsComObjectRef;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsHardware2Program;
import com.tridiumX.knxnetIp.ets.project.BEtsDeviceInstance;
import com.tridiumX.knxnetIp.ets.project.BEtsReceive;
import com.tridiumX.knxnetIp.ets.project.BEtsSend;
import com.tridiumX.knxnetIp.ets.project.IFlagsAncestor;
import com.tridiumX.knxnetIp.wb.BImportedEtsProjectFile;
import com.tridiumX.knxnetIp.xml.XmlChildImportSpec;
import com.tridiumX.knxnetIp.xml.XmlPropertyImportSpec;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="comObjectInstanceRefId", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="refId", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="groupAddressLinks", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="priority", type="BEtsComObjectPriorityEnum", defaultValue="BEtsComObjectPriorityEnum.DEFAULT", flags=1), @NiagaraProperty(name="readFlag", type="BEtsEnableEnum", defaultValue="BEtsEnableEnum.DEFAULT", flags=1), @NiagaraProperty(name="writeFlag", type="BEtsEnableEnum", defaultValue="BEtsEnableEnum.DEFAULT", flags=1), @NiagaraProperty(name="communicationFlag", type="BEtsEnableEnum", defaultValue="BEtsEnableEnum.DEFAULT", flags=1), @NiagaraProperty(name="transmitFlag", type="BEtsEnableEnum", defaultValue="BEtsEnableEnum.DEFAULT", flags=1), @NiagaraProperty(name="updateFlag", type="BEtsEnableEnum", defaultValue="BEtsEnableEnum.DEFAULT", flags=1), @NiagaraProperty(name="readOnInitFlag", type="BEtsEnableEnum", defaultValue="BEtsEnableEnum.DEFAULT", flags=1), @NiagaraProperty(name="datapointType", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="isActive", type="boolean", defaultValue="false", flags=1)})
public final class BEtsComObjectInstanceRef
extends BEtsImportableComponent
implements IFlagsAncestor {
    public static final Property comObjectInstanceRefId = BEtsComObjectInstanceRef.newProperty((int)1, (String)"", null);
    public static final Property refId = BEtsComObjectInstanceRef.newProperty((int)1, (String)"", null);
    public static final Property groupAddressLinks = BEtsComObjectInstanceRef.newProperty((int)1, (String)"", null);
    public static final Property priority = BEtsComObjectInstanceRef.newProperty((int)1, (BValue)BEtsComObjectPriorityEnum.DEFAULT, null);
    public static final Property readFlag = BEtsComObjectInstanceRef.newProperty((int)1, (BValue)BEtsEnableEnum.DEFAULT, null);
    public static final Property writeFlag = BEtsComObjectInstanceRef.newProperty((int)1, (BValue)BEtsEnableEnum.DEFAULT, null);
    public static final Property communicationFlag = BEtsComObjectInstanceRef.newProperty((int)1, (BValue)BEtsEnableEnum.DEFAULT, null);
    public static final Property transmitFlag = BEtsComObjectInstanceRef.newProperty((int)1, (BValue)BEtsEnableEnum.DEFAULT, null);
    public static final Property updateFlag = BEtsComObjectInstanceRef.newProperty((int)1, (BValue)BEtsEnableEnum.DEFAULT, null);
    public static final Property readOnInitFlag = BEtsComObjectInstanceRef.newProperty((int)1, (BValue)BEtsEnableEnum.DEFAULT, null);
    public static final Property datapointType = BEtsComObjectInstanceRef.newProperty((int)1, (String)"", null);
    public static final Property isActive = BEtsComObjectInstanceRef.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BEtsComObjectInstanceRef.class);
    private String comObjectRefId;
    private BEtsComObjectRef referee;
    private static final Pattern ALT_COMOBJECT_REFID = Pattern.compile("M.*_.*_O-.*_.*");
    public static final XmlPropertyImportSpec[] XML_PROPERTY_SPECS = new XmlPropertyImportSpec[]{XmlPropertyImportSpec.make(comObjectInstanceRefId, "ComObjectInstanceRef", "Id", BEtsAttributeTypeEnum.xs_ID, true), XmlPropertyImportSpec.make(refId, "ComObjectInstanceRef", "RefId", BEtsAttributeTypeEnum.knx_IDREF), XmlPropertyImportSpec.make(groupAddressLinks, "ComObjectInstanceRef", "Links", BEtsAttributeTypeEnum.knx_RELIDREFS, true), XmlPropertyImportSpec.make(priority, "ComObjectInstanceRef", "Priority", BEtsAttributeTypeEnum.knx_ComObjectPriority_t, true), XmlPropertyImportSpec.make(readFlag, "ComObjectInstanceRef", "ReadFlag", BEtsAttributeTypeEnum.knx_Enable_t, true), XmlPropertyImportSpec.make(writeFlag, "ComObjectInstanceRef", "WriteFlag", BEtsAttributeTypeEnum.knx_Enable_t, true), XmlPropertyImportSpec.make(communicationFlag, "ComObjectInstanceRef", "CommunicationFlag", BEtsAttributeTypeEnum.knx_Enable_t, true), XmlPropertyImportSpec.make(transmitFlag, "ComObjectInstanceRef", "TransmitFlag", BEtsAttributeTypeEnum.knx_Enable_t, true), XmlPropertyImportSpec.make(updateFlag, "ComObjectInstanceRef", "UpdateFlag", BEtsAttributeTypeEnum.knx_Enable_t, true), XmlPropertyImportSpec.make(readOnInitFlag, "ComObjectInstanceRef", "ReadOnInitFlag", BEtsAttributeTypeEnum.knx_Enable_t, true), XmlPropertyImportSpec.make(datapointType, "ComObjectInstanceRef", "DatapointType", BEtsAttributeTypeEnum.knx_IDREFS, true), XmlPropertyImportSpec.make(isActive, "ComObjectInstanceRef", "IsActive", BEtsAttributeTypeEnum.xs_boolean, true)};
    public static final XmlChildImportSpec[] XML_CHILDREN_SPECS = new XmlChildImportSpec[]{XmlChildImportSpec.make("Send", BEtsSend.TYPE.getTypeName(), "Connectors"), XmlChildImportSpec.make("Receive", BEtsReceive.TYPE.getTypeName(), "Connectors")};

    public String getComObjectInstanceRefId() {
        return this.getString(comObjectInstanceRefId);
    }

    public void setComObjectInstanceRefId(String v) {
        this.setString(comObjectInstanceRefId, v, null);
    }

    public String getRefId() {
        return this.getString(refId);
    }

    public void setRefId(String v) {
        this.setString(refId, v, null);
    }

    public String getGroupAddressLinks() {
        return this.getString(groupAddressLinks);
    }

    public void setGroupAddressLinks(String v) {
        this.setString(groupAddressLinks, v, null);
    }

    public BEtsComObjectPriorityEnum getPriority() {
        return (BEtsComObjectPriorityEnum)this.get(priority);
    }

    public void setPriority(BEtsComObjectPriorityEnum v) {
        this.set(priority, (BValue)v, null);
    }

    public BEtsEnableEnum getReadFlag() {
        return (BEtsEnableEnum)this.get(readFlag);
    }

    public void setReadFlag(BEtsEnableEnum v) {
        this.set(readFlag, (BValue)v, null);
    }

    public BEtsEnableEnum getWriteFlag() {
        return (BEtsEnableEnum)this.get(writeFlag);
    }

    public void setWriteFlag(BEtsEnableEnum v) {
        this.set(writeFlag, (BValue)v, null);
    }

    public BEtsEnableEnum getCommunicationFlag() {
        return (BEtsEnableEnum)this.get(communicationFlag);
    }

    public void setCommunicationFlag(BEtsEnableEnum v) {
        this.set(communicationFlag, (BValue)v, null);
    }

    public BEtsEnableEnum getTransmitFlag() {
        return (BEtsEnableEnum)this.get(transmitFlag);
    }

    public void setTransmitFlag(BEtsEnableEnum v) {
        this.set(transmitFlag, (BValue)v, null);
    }

    public BEtsEnableEnum getUpdateFlag() {
        return (BEtsEnableEnum)this.get(updateFlag);
    }

    public void setUpdateFlag(BEtsEnableEnum v) {
        this.set(updateFlag, (BValue)v, null);
    }

    public BEtsEnableEnum getReadOnInitFlag() {
        return (BEtsEnableEnum)this.get(readOnInitFlag);
    }

    public void setReadOnInitFlag(BEtsEnableEnum v) {
        this.set(readOnInitFlag, (BValue)v, null);
    }

    public String getDatapointType() {
        return this.getString(datapointType);
    }

    public void setDatapointType(String v) {
        this.setString(datapointType, v, null);
    }

    public boolean getIsActive() {
        return this.getBoolean(isActive);
    }

    public void setIsActive(boolean v) {
        this.setBoolean(isActive, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private String getComObjectRefId(BEtsProjectFile kpf) throws Exception {
        if (this.comObjectRefId == null) {
            this.comObjectRefId = this.findComObjectRefId(kpf, this.getRefId());
        }
        return this.comObjectRefId;
    }

    private String findComObjectRefId(BEtsProjectFile kpf, String refId) throws Exception {
        String comObjectRefId = null;
        String rawRefId = refId;
        if (rawRefId.equals("")) {
            comObjectRefId = "";
        } else {
            BEtsNameSpaceEnum etsNameSpace = BEtsComObjectInstanceRef.getEtsNameSpaceEnum(kpf);
            if (etsNameSpace.getOrdinal() < 6) {
                comObjectRefId = rawRefId;
            } else {
                BEtsApplicationProgramRef[] applicationProgramRefs;
                String hardware2ProgramRefId = ((BEtsDeviceInstance)this.getParent()).getHardware2ProgramRefId();
                BEtsHardware2Program hardware2Program = (BEtsHardware2Program)kpf.getReferee(hardware2ProgramRefId);
                if (hardware2Program != null && (applicationProgramRefs = (BEtsApplicationProgramRef[])hardware2Program.getChildren(BEtsApplicationProgramRef.class)).length > 0) {
                    String refIdPrefix = applicationProgramRefs[0].getRefId();
                    comObjectRefId = refIdPrefix + '_' + rawRefId;
                }
                if (comObjectRefId == null) {
                    comObjectRefId = "";
                }
            }
        }
        return comObjectRefId;
    }

    private static BEtsNameSpaceEnum getEtsNameSpaceEnum(BEtsProjectFile kpf) {
        BImportedEtsProjectFile importedEtsProjectFile = (BImportedEtsProjectFile)kpf.getParent();
        if (importedEtsProjectFile == null) {
            return BEtsNameSpaceEnum.unknown;
        }
        return importedEtsProjectFile.getEtsNamespace();
    }

    private Optional<BEtsComObjectRef> getReferee(BEtsProjectFile kpf) throws Exception {
        if (this.referee == null) {
            String refId;
            String altRefId;
            BEtsImportableComponent ref;
            this.referee = (BEtsComObjectRef)kpf.getReferee(this.getComObjectRefId(kpf));
            if (this.referee == null && ALT_COMOBJECT_REFID.matcher(this.getRefId()).matches() && (ref = kpf.getReferee(this.findComObjectRefId(kpf, altRefId = (refId = this.getRefId()).substring(0, refId.indexOf(95) + 1) + this.getRefId().substring(refId.indexOf("O-"))))) instanceof BEtsComObjectRef) {
                this.referee = (BEtsComObjectRef)ref.as(BEtsComObjectRef.class);
            }
        }
        return Optional.ofNullable(this.referee);
    }

    public String getDatapointType(BEtsProjectFile kpf) throws Exception {
        String sRefId;
        String s = this.getDatapointType();
        if (s.equals("") && !(sRefId = this.getComObjectRefId(kpf)).equals("")) {
            BEtsComObjectRef comObjectRef = (BEtsComObjectRef)kpf.getReferee(sRefId);
            s = comObjectRef != null ? comObjectRef.getDatapointType(kpf) : "Unknown - unable to locate the ComObjectRef in kpf Referees with ID = '" + sRefId + "'.";
        }
        return s;
    }

    @Override
    public BEtsComObjectPriorityEnum getPriority(BEtsProjectFile kpf) throws Exception {
        Optional<BEtsComObjectRef> referee;
        if (this.getPriority().equals((Object)BEtsComObjectPriorityEnum.unspecified) && (referee = this.getReferee(kpf)).isPresent()) {
            return referee.get().getPriority(kpf);
        }
        return this.getPriority();
    }

    @Override
    public BKnxComObjectSizeEnum getObjectSize(BEtsProjectFile kpf) throws Exception {
        Optional<BEtsComObjectRef> referee = this.getReferee(kpf);
        return referee.isPresent() ? referee.get().getObjectSize(kpf) : BKnxComObjectSizeEnum.unknownSize;
    }

    @Override
    public boolean getReadFlag(BEtsProjectFile kpf) throws Exception {
        if (this.getReadFlag().equals((Object)BEtsEnableEnum.unspecified)) {
            Optional<BEtsComObjectRef> referee = this.getReferee(kpf);
            return referee.isPresent() && referee.get().getReadFlag(kpf);
        }
        return this.getReadFlag().equals((Object)BEtsEnableEnum.Enabled);
    }

    @Override
    public boolean getWriteFlag(BEtsProjectFile kpf) throws Exception {
        if (this.getWriteFlag().equals((Object)BEtsEnableEnum.unspecified)) {
            Optional<BEtsComObjectRef> referee = this.getReferee(kpf);
            return referee.isPresent() && referee.get().getWriteFlag(kpf);
        }
        return this.getWriteFlag().equals((Object)BEtsEnableEnum.Enabled);
    }

    @Override
    public boolean getCommunicationFlag(BEtsProjectFile kpf) throws Exception {
        if (this.getCommunicationFlag().equals((Object)BEtsEnableEnum.unspecified)) {
            Optional<BEtsComObjectRef> referee = this.getReferee(kpf);
            return referee.isPresent() && referee.get().getCommunicationFlag(kpf);
        }
        return this.getCommunicationFlag().equals((Object)BEtsEnableEnum.Enabled);
    }

    @Override
    public boolean getTransmitFlag(BEtsProjectFile kpf) throws Exception {
        if (this.getTransmitFlag().equals((Object)BEtsEnableEnum.unspecified)) {
            Optional<BEtsComObjectRef> referee = this.getReferee(kpf);
            return referee.isPresent() && referee.get().getTransmitFlag(kpf);
        }
        return this.getTransmitFlag().equals((Object)BEtsEnableEnum.Enabled);
    }

    @Override
    public boolean getUpdateFlag(BEtsProjectFile kpf) throws Exception {
        if (this.getUpdateFlag().equals((Object)BEtsEnableEnum.unspecified)) {
            Optional<BEtsComObjectRef> referee = this.getReferee(kpf);
            return referee.isPresent() && referee.get().getUpdateFlag(kpf);
        }
        return this.getUpdateFlag().equals((Object)BEtsEnableEnum.Enabled);
    }

    @Override
    public boolean getReadOnInitFlag(BEtsProjectFile kpf) throws Exception {
        if (this.getReadOnInitFlag().equals((Object)BEtsEnableEnum.unspecified)) {
            Optional<BEtsComObjectRef> referee = this.getReferee(kpf);
            return referee.isPresent() && referee.get().getReadOnInitFlag(kpf);
        }
        return this.getReadOnInitFlag().equals((Object)BEtsEnableEnum.Enabled);
    }

    @Override
    public String getIdPropertyName() {
        return comObjectInstanceRefId.getName();
    }

    @Override
    public XmlPropertyImportSpec[] getImportSpecs() {
        return XML_PROPERTY_SPECS;
    }

    @Override
    public XmlChildImportSpec[] getImportChildSpecs() {
        return XML_CHILDREN_SPECS;
    }
}

