/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.poll;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.poll.BIDdfPollable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDdfPollGroup
extends BStruct
implements BIDdfPollable,
IDdfFacetConst,
BIPollable {
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfPollGroup.class);
    static HashMap<Integer, Hashtable<Object, BDdfPollGroup>> reqTypesToGroupCodes = new HashMap();
    Object code = null;
    Vector<BIDdfPollable> mySubscribedPollables = new Vector(8);
    Vector<BIDdfPollable> myDdfPollables = new Vector(8);
    boolean subscribed = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void readFail(String reason) {
    }

    @Override
    public void readOk(BStatusValue out) {
    }

    protected final BIDdfPollable[] getPollables() {
        Object[] ddfPollables = new BIDdfPollable[this.myDdfPollables.size()];
        this.myDdfPollables.copyInto(ddfPollables);
        return ddfPollables;
    }

    protected final BIDdfPollable[] getSubscribedPollables() {
        Object[] ddfPollables = new BIDdfPollable[this.mySubscribedPollables.size()];
        this.mySubscribedPollables.copyInto(ddfPollables);
        return ddfPollables;
    }

    protected void registerPollable(BIDdfPollable ddfPollable) {
        if (!this.myDdfPollables.contains(ddfPollable)) {
            this.myDdfPollables.add(ddfPollable);
        }
    }

    protected void unregisterPollable(BIDdfPollable ddfPollable) {
        try {
            this.readUnsubscribed(ddfPollable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myDdfPollables.remove(ddfPollable);
    }

    protected void readSubscribed(BIDdfPollable ddfPollable) throws Exception {
        if (!this.mySubscribedPollables.contains(ddfPollable)) {
            this.mySubscribedPollables.add(ddfPollable);
        }
        if (!this.subscribed) {
            ddfPollable.getDdfCommunicator().getDdfPollScheduler().subscribe(this);
            this.subscribed = true;
        }
    }

    protected void readUnsubscribed(BIDdfPollable ddfPollable) throws Exception {
        this.mySubscribedPollables.remove(ddfPollable);
        if (this.mySubscribedPollables.size() == 0) {
            ddfPollable.getDdfCommunicator().getDdfPollScheduler().unsubscribe(this);
            this.subscribed = false;
        }
    }

    protected BIDdfPollable getDefaultPollable() {
        BIDdfPollable[] ddfPollables = this.getPollables();
        if (ddfPollables != null && ddfPollables.length > 0) {
            return this.getPollables()[0];
        }
        throw new IllegalStateException("No BIDdfPollables in BDdfPollGroup: " + this);
    }

    public BPollFrequency getPollFrequency() {
        BPollFrequency fastestYet = BPollFrequency.slow;
        for (BIDdfPollable ddfPollable : this.mySubscribedPollables) {
            BPollFrequency fr;
            if (!(ddfPollable instanceof BIPollable) || (fr = ((BIPollable)ddfPollable).getPollFrequency()).compareTo((Object)fastestYet) >= 0) continue;
            fastestYet = fr;
        }
        return fastestYet;
    }

    @Override
    public BIDdfReadRequest makePollRequest() {
        BIDdfReadRequest defaultReadRequest = this.getDefaultPollable().makePollRequest();
        defaultReadRequest.setReadableSource(this.getPollables());
        return defaultReadRequest;
    }

    @Override
    public BIDdfCommunicator getDdfCommunicator() {
        return this.getDefaultPollable().getDdfCommunicator();
    }

    @Override
    public Object getPollGroupCode() {
        return this.code;
    }

    @Override
    public Type getReadRequestType() {
        return this.getDefaultPollable().getReadRequestType();
    }

    public static void readSubscribed(BIDdfPollable valueToBePolled, Context cx) throws Exception {
        Object ddfPollGroupCode = valueToBePolled.getPollGroupCode();
        if (ddfPollGroupCode != null) {
            BDdfPollGroup pg = BDdfPollGroup.getPollGroup(valueToBePolled);
            pg.readSubscribed(valueToBePolled);
        }
    }

    public static void readUnsubscribed(BIDdfPollable ddfValueToBePolled, Context cx) throws Exception {
        Object ddfPollGroupCode = ddfValueToBePolled.getPollGroupCode();
        if (ddfPollGroupCode != null) {
            BDdfPollGroup ezPg = BDdfPollGroup.getPollGroup(ddfValueToBePolled);
            ezPg.readUnsubscribed(ddfValueToBePolled);
        }
    }

    public static void register(BIDdfPollable valueToBePolled) throws Exception {
        Object ddfPollGroupCode = valueToBePolled.getPollGroupCode();
        if (ddfPollGroupCode != null) {
            BDdfPollGroup pg = BDdfPollGroup.getPollGroup(valueToBePolled);
            pg.registerPollable(valueToBePolled);
        }
    }

    public static void unregister(BIDdfPollable ddfValueToBePolled) throws Exception {
        Object ddfPollGroupCode = ddfValueToBePolled.getPollGroupCode();
        if (ddfPollGroupCode != null) {
            BDdfPollGroup ezPg = BDdfPollGroup.getPollGroup(ddfValueToBePolled);
            ezPg.unregisterPollable(ddfValueToBePolled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BDdfPollGroup getPollGroup(BIDdfPollable ddfPollable) {
        Type readReqType = ddfPollable.getReadRequestType();
        Object pgCode = ddfPollable.getPollGroupCode();
        Type type = readReqType;
        synchronized (type) {
            BDdfPollGroup pg;
            Hashtable<Object, BDdfPollGroup> codesToGroups = reqTypesToGroupCodes.get(readReqType.getId());
            if (codesToGroups == null) {
                codesToGroups = new Hashtable();
                reqTypesToGroupCodes.put(readReqType.getId(), codesToGroups);
            }
            if ((pg = codesToGroups.get(pgCode)) == null) {
                pg = new BDdfPollGroup();
                pg.code = pgCode;
                codesToGroups.put(pgCode, pg);
            }
            return pg;
        }
    }
}

