/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.discover.auto;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.BDdfPointDeviceExt;
import com.tridium.ddf.DdfLexicon;
import com.tridium.ddf.comm.req.BIDdfDiscoverRequest;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.discover.BDdfDiscoveryJob;
import com.tridium.ddf.discover.BIDdfDiscoveryHost;
import com.tridium.ddf.discover.BIDdfDiscoveryObject;
import com.tridium.ddf.discover.IDdfDiscoverer;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences;
import com.tridium.ddf.discover.auto.DdfAutoDiscoveryLexicon;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfDiscoverParams;
import com.tridium.ddf.point.BDdfProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperty(name="discoveryPreferences", type="BDdfAutoDiscoveryPreferences", defaultValue="new BDdfAutoDiscoveryPreferences()")
public class BDdfAutoDiscoveryJob
extends BDdfDiscoveryJob {
    @Generated
    public static final Property discoveryPreferences = BDdfAutoDiscoveryJob.newProperty((int)0, (BValue)new BDdfAutoDiscoveryPreferences(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfAutoDiscoveryJob.class);
    private BIDdfDiscoveryHost discoveryHost = null;

    @Generated
    public BDdfAutoDiscoveryPreferences getDiscoveryPreferences() {
        return (BDdfAutoDiscoveryPreferences)this.get(discoveryPreferences);
    }

    @Generated
    public void setDiscoveryPreferences(BDdfAutoDiscoveryPreferences v) {
        this.set(discoveryPreferences, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDdfAutoDiscoveryJob() {
    }

    public BDdfAutoDiscoveryJob(BIDdfDiscoveryHost databaseParent) {
        this.discoveryHost = databaseParent;
        BFolder discoveryFolder = databaseParent.getDiscoveryFolder();
        if (discoveryFolder != null) {
            this.setDiscoveryFolder(discoveryFolder.getSlotPathOrd());
        }
    }

    @Override
    public void run(Context cx) throws Exception {
        this.clearRootDiscoveryObjects();
        this.autoLearn();
        BIDdfDiscoveryObject[] discoveryObjects = this.getRootDiscoveryObjects();
        if (discoveryObjects != null && discoveryObjects.length < 1) {
            if (this.discoveryHost instanceof BDdfNetwork) {
                throw new BajaRuntimeException(DdfAutoDiscoveryLexicon.noDevicesFound);
            }
            throw new BajaRuntimeException(DdfAutoDiscoveryLexicon.noPointsFound);
        }
    }

    protected Type[] getDiscoveryRequestTypes() {
        BDdfIdParams minDiscoveryId = this.getDiscoveryPreferences().getMin();
        if (minDiscoveryId instanceof BIDdfDiscoverParams) {
            return ((BIDdfDiscoverParams)((Object)minDiscoveryId)).getDiscoverRequestTypes();
        }
        throw new BajaRuntimeException(DdfLexicon.ddfDiscoverParamsNeedsImplemented(minDiscoveryId.getType()));
    }

    protected void autoLearn() throws Exception {
        Type[] discoverReqTypes = this.getDiscoveryRequestTypes();
        for (int i = 0; i < discoverReqTypes.length; ++i) {
            if (discoverReqTypes[i].is(BIDdfDiscoverRequest.TYPE)) {
                this.learnFromRequestType(discoverReqTypes[i], 100 / discoverReqTypes.length);
                continue;
            }
            this.discoveryHost.getDdfCommunicator().getLog().error(DdfAutoDiscoveryLexicon.typeMustImplementDiscoveryRequest(discoverReqTypes[i]));
        }
    }

    protected void learnFromRequestType(Type requestType, int progressValueOfMethod) {
        BIDdfDiscoverParams minDiscoverId = (BIDdfDiscoverParams)this.getDiscoveryPreferences().getMin().newCopy();
        BIDdfDiscoverParams maxDiscoverId = (BIDdfDiscoverParams)this.getDiscoveryPreferences().getMax().newCopy();
        int numRequestsToTry = minDiscoverId.countTo(maxDiscoverId);
        BIDdfDiscoverParams currentDiscoverId = minDiscoverId;
        BIDdfDiscoverParams previousDiscoverId = minDiscoverId;
        while (!previousDiscoverId.isAfter(currentDiscoverId) && !currentDiscoverId.isAfter(maxDiscoverId)) {
            if (this.getJobState() == BJobState.canceling) {
                throw new JobCancelException();
            }
            this.learn((BIDdfDiscoverRequest)requestType.getInstance(), currentDiscoverId);
            this.progress(this.getProgress() + (int)((float)progressValueOfMethod / (float)numRequestsToTry));
            previousDiscoverId = currentDiscoverId;
            currentDiscoverId = currentDiscoverId.getNext();
        }
        if (numRequestsToTry == Integer.MAX_VALUE) {
            this.progress(this.getProgress() + progressValueOfMethod);
        }
    }

    private BComponent[] getDatabaseObjects() {
        if (this.discoveryHost instanceof BDdfNetwork) {
            BDdfNetwork network = (BDdfNetwork)((Object)this.discoveryHost);
            BDevice[] dbDevices = network.getDevices();
            return dbDevices;
        }
        if (this.discoveryHost instanceof BDdfPointDeviceExt) {
            Array controlPointsArray = new Array(BControlPoint.class);
            BDdfDevice device = (BDdfDevice)((BDdfPointDeviceExt)this.discoveryHost).getDevice();
            BDeviceExt[] deviceExts = device.getDeviceExts();
            for (int i = 0; i < deviceExts.length; ++i) {
                if (!(deviceExts[i] instanceof BPointDeviceExt)) continue;
                BPointDeviceExt ptDvExt = (BPointDeviceExt)deviceExts[i];
                controlPointsArray.addAll((Object[])ptDvExt.getPoints());
            }
            return (BComponent[])controlPointsArray.trim();
        }
        throw new IllegalStateException("Not Implemented For Database Parent Type: " + this.discoveryHost.getType().getTypeName());
    }

    private IDdfPingable[] getPingableSource(BDdfIdParams devicePingId) {
        Array pingableSource = new Array(IDdfPingable.class);
        BComponent[] dbDevices = this.getDatabaseObjects();
        for (int i = 0; i < dbDevices.length; ++i) {
            BDdfDevice ddfDevice;
            BDdfIdParams deviceId;
            if (!(dbDevices[i] instanceof BDdfDevice) || !(deviceId = (ddfDevice = (BDdfDevice)dbDevices[i]).getDeviceId()).getType().equals(devicePingId.getType()) || !ddfDevice.getDeviceId().equals(devicePingId)) continue;
            pingableSource.add((Object)ddfDevice);
        }
        return (IDdfPingable[])pingableSource.trim();
    }

    private IDdfReadable[] getReadableSource(BDdfIdParams readParameters) {
        Array readableSource = new Array(IDdfReadable.class);
        BComponent[] dbPoints = this.getDatabaseObjects();
        for (int i = 0; i < dbPoints.length; ++i) {
            BDdfIdParams requestId;
            BAbstractProxyExt proxy;
            if (!(dbPoints[i] instanceof BControlPoint) || !((proxy = ((BControlPoint)dbPoints[i]).getProxyExt()) instanceof BDdfProxyExt) || !(requestId = ((BDdfProxyExt)proxy).getReadParameters()).getType().equals(readParameters.getType()) || !requestId.equivalent(readParameters)) continue;
            readableSource.add((Object)((IDdfReadable)proxy));
        }
        return (IDdfReadable[])readableSource.trim();
    }

    protected void learn(BIDdfDiscoverRequest discoverReq, BIDdfDiscoverParams discoverId) {
        discoverReq.setResponseTimeout(this.getDiscoveryPreferences().getTimeout());
        discoverReq.setRemainingRetryCount(this.getDiscoveryPreferences().getRetryCount());
        discoverReq.setDiscoverParameters((BDdfIdParams)((Object)discoverId));
        discoverReq.setDiscoverer(new IDdfDiscoverer(){

            @Override
            public BJob getJob() {
                return BDdfAutoDiscoveryJob.this;
            }

            @Override
            public void discoverFail(String reason) {
                BDdfAutoDiscoveryJob.this.log().message(reason);
            }

            @Override
            public void discoverOk(BIDdfDiscoveryObject[] discoveryObjects) {
                Object discoveryFolder = BDdfAutoDiscoveryJob.this.discoveryHost.getDiscoveryFolder();
                if (discoveryFolder == null) {
                    discoveryFolder = BDdfAutoDiscoveryJob.this;
                }
                for (int i = 0; i < discoveryObjects.length; ++i) {
                    discoveryFolder.add("d?", (BValue)discoveryObjects[i]);
                }
            }

            @Override
            public Context getDiscoverContext() {
                if (BDdfAutoDiscoveryJob.this.discoveryHost instanceof BDdfNetwork) {
                    return CONTEXT_DISCOVERING_DEVICES;
                }
                return CONTEXT_DISCOVERING_POINTS;
            }
        });
        if (this.discoveryHost instanceof BDdfNetwork) {
            if (discoverReq instanceof BIDdfPingRequest) {
                discoverReq.setDeviceId((BDdfIdParams)((BDdfIdParams)((Object)discoverId)).newCopy());
                ((BIDdfPingRequest)((Object)discoverReq)).setPingableSource(this.getPingableSource((BDdfIdParams)((BDdfIdParams)((Object)discoverId)).newCopy()));
            }
        } else if (this.discoveryHost instanceof BDdfPointDeviceExt) {
            discoverReq.setDeviceId((BDdfIdParams)((BDdfDevice)((BDdfPointDeviceExt)this.discoveryHost).getDevice()).getDeviceId().newCopy());
            if (discoverReq instanceof BIDdfReadRequest) {
                ((BIDdfReadRequest)((Object)discoverReq)).setReadParameters((BDdfIdParams)((BDdfIdParams)((Object)discoverId)).newCopy());
                ((BIDdfReadRequest)((Object)discoverReq)).setReadableSource(this.getReadableSource((BDdfIdParams)((Object)discoverId)));
            }
        }
        DdfRequestUtil.communicateSync(this.discoveryHost.getDdfCommunicator(), discoverReq);
    }

    public BIDdfDiscoveryHost getDiscoveryHost() {
        return this.discoveryHost;
    }
}

