/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.singleTransaction;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.comm.rsp.BIDdfMultiFrameResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.comm.rsp.IDdfTransmitAckResponse;
import com.tridium.ddf.comm.singleTransaction.BIDdfSingleTransactionMgr;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDdfSingleTransactionMgr
extends BDdfTransactionMgr
implements BIDdfSingleTransactionMgr {
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfSingleTransactionMgr.class);
    BIDdfRequest outstandingRequest = null;
    Object internalSynchronizer = new Object();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void stopTransactionMgr() {
        try {
            super.stopTransactionMgr();
        }
        finally {
            if (this.outstandingRequest != null) {
                if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.requestTimedOut(this.outstandingRequest));
                }
                DdfRequestUtil.processTimeout(this.outstandingRequest);
                this.outstandingRequest = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beginTransaction(BIDdfRequest req) throws Exception {
        Object object = this.internalSynchronizer;
        synchronized (object) {
            while (this.outstandingRequest != null) {
                this.internalSynchronizer.wait();
            }
            if (!req.getResponseTimeout().equals((Object)BRelTime.DEFAULT)) {
                this.outstandingRequest = req;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCheckOutstandingTimeout(BIDdfRequest ddfRequest) {
        Object object = this.internalSynchronizer;
        synchronized (object) {
            if (this.outstandingRequest != null && this.outstandingRequest == ddfRequest) {
                if (ddfRequest.getRemainingRetryCount() > 0) {
                    try {
                        ddfRequest.setRemainingRetryCount(ddfRequest.getRemainingRetryCount() - 1);
                        this.getDdfCommunicator().getDdfTransmitter().forceTransmit(ddfRequest);
                        this.getDdfCommunicator().getDdfTransmitter().setRetransmissionCount(this.getDdfCommunicator().getDdfTransmitter().getRetransmissionCount() + 1L);
                    }
                    catch (Exception e) {
                        this.getDdfCommunicator().getLog().error("RetransmissionError", (Throwable)e);
                    }
                    finally {
                        this.scheduleToCheckForTimeout(ddfRequest);
                    }
                } else {
                    try {
                        if (this.getDdfCommunicator().getLog().isTraceOn()) {
                            this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.requestTimedOut(ddfRequest));
                        }
                        DdfRequestUtil.processTimeout(ddfRequest);
                    }
                    finally {
                        this.outstandingRequest = null;
                        this.internalSynchronizer.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void frameReceived(IDdfDataFrame ddfReceiveFrame) {
        Object object = this.internalSynchronizer;
        synchronized (object) {
            boolean frameConsumed;
            block18: {
                frameConsumed = false;
                if (this.outstandingRequest != null) {
                    try {
                        BIDdfResponse ddfRsp = DdfRequestUtil.processReceive(this.outstandingRequest, ddfReceiveFrame);
                        if (ddfRsp == null) break block18;
                        frameConsumed = true;
                        if (ddfRsp instanceof IDdfTransmitAckResponse) {
                            this.transmitRspAckBytes((IDdfTransmitAckResponse)((Object)ddfRsp));
                        }
                        if (ddfRsp instanceof BIDdfMultiFrameResponse) {
                            this.reScheduleToCheckForTimeout(this.outstandingRequest);
                        }
                        if (!this.isCompletedResponse(ddfRsp)) break block18;
                        try {
                            if (this.getDdfCommunicator().getLog().isTraceOn()) {
                                this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.receivedResponseForRequest(this.outstandingRequest));
                            }
                            DdfRequestUtil.processResponse(this.outstandingRequest, ddfRsp);
                        }
                        finally {
                            this.outstandingRequest = null;
                            this.internalSynchronizer.notifyAll();
                        }
                    }
                    catch (DdfResponseException errorResponse) {
                        try {
                            if (errorResponse instanceof IDdfTransmitAckResponse) {
                                this.transmitRspAckBytes((IDdfTransmitAckResponse)((Object)errorResponse));
                            }
                            frameConsumed = true;
                            if (this.getDdfCommunicator().getLog().isTraceOn()) {
                                this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.receivedErrorResponseForRequest(this.outstandingRequest, errorResponse));
                            }
                            DdfRequestUtil.processErrorResponse(this.outstandingRequest, errorResponse);
                        }
                        finally {
                            this.outstandingRequest = null;
                            this.internalSynchronizer.notifyAll();
                        }
                    }
                }
            }
            if (!frameConsumed) {
                this.routeToUnsolicited(ddfReceiveFrame);
            }
        }
    }

    public BIDdfRequest getOutstandingRequest() {
        return this.outstandingRequest;
    }
}

