/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.req.util;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.identify.BDdfIdParams;

public class DdfPingRequestUtil
implements IDdfFacetConst {
    public static void processResponse(BIDdfPingRequest pingReq, BIDdfResponse ddfRsp) {
        IDdfPingable[] pingableSource;
        if (pingReq.getAutoPingOk() && (pingableSource = pingReq.getPingableSource()) != null) {
            for (int i = 0; i < pingableSource.length; ++i) {
                pingableSource[i].setDeviceId((BDdfIdParams)ddfRsp.getDeviceId().newCopy());
                pingableSource[i].pingOk();
            }
        }
    }

    public static void processTimeout(BIDdfPingRequest pingReq) {
        IDdfPingable[] pingableSource;
        if (pingReq.getAutoPingFailOnTimeout() && (pingableSource = pingReq.getPingableSource()) != null) {
            for (int i = 0; i < pingableSource.length; ++i) {
                pingableSource[i].pingFail(DdfDefaultCommLexicon.requestTimeOut);
            }
        }
    }

    public static void processLateResponse(BIDdfPingRequest pingReq, BIDdfResponse ddfRsp) {
        IDdfPingable[] pingableSource;
        if (pingReq.getAutoPingOkLate() && (pingableSource = pingReq.getPingableSource()) != null) {
            for (int i = 0; i < pingableSource.length; ++i) {
                pingableSource[i].setDeviceId((BDdfIdParams)ddfRsp.getDeviceId().newCopy());
                pingableSource[i].pingOk();
            }
        }
    }

    public static void processErrorResponse(BIDdfPingRequest pingReq, DdfResponseException errorRsp) {
        IDdfPingable[] pingableSource;
        if (pingReq.getAutoPingFailOnError() && (pingableSource = pingReq.getPingableSource()) != null) {
            for (int i = 0; i < pingableSource.length; ++i) {
                pingableSource[i].pingFail(DdfDefaultCommLexicon.responseError(errorRsp));
            }
        }
    }
}

