/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client.ui;

import com.tridium.opc.client.BOpcDaClient;
import com.tridium.opc.client.BOpcDevice;
import com.tridium.opc.client.BOpcDeviceDiscoveryResult;
import com.tridium.opc.client.ui.BOpcDeviceManager;
import com.tridium.opc.client.ui.OpcDeviceModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class OpcDeviceLearn
extends MgrLearn {
    private static BImage iconImg = BImage.make((BIcon)BIcon.std((String)"device.png"));

    public OpcDeviceLearn(BOpcDeviceManager mgr) {
        super((BAbstractManager)mgr);
    }

    public final BImage getIcon(Object d) {
        return iconImg;
    }

    public final boolean isExisting(Object discovered, BComponent db) {
        if (!(db instanceof BOpcDaClient)) {
            return false;
        }
        BOpcDeviceDiscoveryResult res = (BOpcDeviceDiscoveryResult)discovered;
        BOpcDevice dev = (BOpcDevice)db;
        return res.getAddress().equals(dev.getAddress()) && res.getClassId().equals(dev.getClassId()) && res.getProgId().equals(dev.getProgramId());
    }

    public final boolean isMatchable(Object discovered, BComponent db) {
        return true;
    }

    public final void jobComplete(BJob job) {
        job.lease(Integer.MAX_VALUE);
        this.updateRoots(job.getChildComponents());
    }

    public void toRow(Object discovered, MgrEditRow row) throws Exception {
        BOpcDeviceDiscoveryResult r = (BOpcDeviceDiscoveryResult)discovered;
        OpcDeviceModel m = (OpcDeviceModel)this.getManager().getModel();
        row.setCell(m.address, (BValue)BString.make((String)r.getAddress()));
        row.setCell(m.classId, (BValue)BString.make((String)r.getClassId()));
        row.setCell(m.desc, (BValue)BString.make((String)r.getDescription()));
        row.setCell(m.name, (BValue)BString.make((String)r.getName()));
        row.setCell(m.programId, (BValue)BString.make((String)r.getProgId()));
        row.setCell(m.vipId, (BValue)BString.make((String)r.getVersionIndependentProgId()));
    }

    public final MgrTypeInfo[] toTypes(Object discovered) {
        return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BOpcDaClient.TYPE)};
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Prop(BOpcDeviceDiscoveryResult.address), new MgrColumn.Prop(BOpcDeviceDiscoveryResult.classId), new MgrColumn.Prop(BOpcDeviceDiscoveryResult.progId), new MgrColumn.Prop(BOpcDeviceDiscoveryResult.versionIndependentProgId), new MgrColumn.Prop(BOpcDeviceDiscoveryResult.catId)};
    }
}

