/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client.point.ui;

import com.tridium.opc.client.point.BOpcPointDeviceExt;
import com.tridium.opc.client.point.BOpcPointDiscoveryResult;
import com.tridium.opc.client.point.BOpcPointFolder;
import com.tridium.opc.client.point.ui.BOpcPointManager;
import javax.baja.control.BControlPoint;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.BLearnTable;

public class OpcPointController
extends PointController {
    Log opcLog = Log.getLog((String)"OpcDaLog");

    public OpcPointController(BOpcPointManager mgr) {
        super((BPointManager)mgr);
    }

    public final CommandArtifact doAdd(Context cx) throws Exception {
        BComponent parent = (BComponent)this.getManager().getCurrentValue();
        int[] learnSel = this.getLearnSelectedRows();
        BLearnTable tbl = this.getLearnTable();
        for (int i = 0; i < learnSel.length; ++i) {
            BOpcPointDiscoveryResult res = (BOpcPointDiscoveryResult)tbl.getObjectAt(learnSel[i]);
            if (!res.getFolder()) continue;
            BOpcPointFolder fol = new BOpcPointFolder();
            parent.add(res.getName() + "?", (BValue)fol);
        }
        CommandArtifact cmdArt = super.doAdd(cx);
        parent.lease(2, 60000L);
        return cmdArt;
    }

    public final CommandArtifact doDiscover(Context cx) throws Exception {
        super.doDiscover(cx);
        BObject o = this.getManager().getCurrentValue();
        BValue args = this.getDiscoveryArgs();
        if (o instanceof BOpcPointDeviceExt) {
            this.getManager().getLearn().setJob(((BOpcPointDeviceExt)o).submitPointDiscoveryJob(args));
        } else {
            this.getManager().getLearn().setJob(((BOpcPointFolder)o).submitPointDiscoveryJob(args));
        }
        this.getManager().registerForComponentEvents((BComponent)this.getManager().getLearn().getJob());
        return null;
    }

    public final CommandArtifact doMatch(Object discovery, BComponent existing, Context cx) throws Exception {
        if (existing instanceof BControlPoint) {
            return super.doMatch(discovery, existing, cx);
        }
        BOpcPointDiscoveryResult res = (BOpcPointDiscoveryResult)discovery;
        BOpcPointFolder fol = (BOpcPointFolder)existing;
        BComponent parent = (BComponent)fol.getParent();
        Property p = parent.getProperty(fol.getName());
        parent.rename(p, fol.getName());
        return null;
    }

    public BValue getDiscoveryArgs() {
        return null;
    }
}

