/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.analyzer.ui;

import com.tridium.box.BBoxRecordType;
import com.tridium.box.analyzer.BBoxAnalyzer;
import com.tridium.box.analyzer.BBoxFrameRecord;
import com.tridium.ui.UiEnv;
import java.io.PrintWriter;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"boxAnalyzer:BoxAnalyzer"})})
public final class BBoxAnalyzerView
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BBoxAnalyzerView.class);
    private Array<BBoxFrameRecord> records = new Array(BBoxFrameRecord.class);
    private TableModel model = new Model();
    private BTable table = new BTable(this.model);
    private Renderer renderer = new Renderer();
    private volatile boolean pause = false;
    private static final Lexicon lex = Lexicon.make(BBoxAnalyzerView.class);
    private static final BImage requestIcon = BImage.make((BIcon)BIcon.std((String)"arrowRight.png"));
    private static final BImage responseIcon = BImage.make((BIcon)BIcon.std((String)"arrowLeft.png"));
    private static final BImage blankIcon = BImage.make((BIcon)BIcon.std((String)"blank.png"));
    private static final BBrush requestBrush = BColor.make((int)255, (int)220, (int)220).toBrush();
    private static final BBrush responseBrush = BColor.make((int)230, (int)255, (int)230).toBrush();
    private static final BBrush statusBrush = BColor.lightYellow.toBrush();
    private static final BBrush errorBrush = BColor.tomato.toBrush();
    private static final int maxCellStrSize = 200;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBoxAnalyzerView() {
        this.table.setCellRenderer((TableCellRenderer)this.renderer);
        this.table.setMultipleSelection(false);
        this.table.setController((TableController)new Controller());
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)BTitlePane.makePane((String)lex.getText("box.analyzer.view.title"), (BTable)this.table));
        BGridPane actionPane = new BGridPane(3);
        actionPane.setColumnGap(10.0);
        actionPane.add(null, (BValue)new BToggleButton((Command)new PauseCmd((BWidget)this)));
        actionPane.add(null, (BValue)new BButton((Command)new ClearCmd((BWidget)this)));
        pane.setBottom((BWidget)new BBorderPane((BWidget)actionPane, 5.0, 5.0, 5.0, 5.0));
        this.setContent((BWidget)pane);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.pause = false;
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (event.getSourceComponent() == this.getAnalyzer() && event.getId() == 5 && event.getSlot() == BBoxAnalyzer.newFrame) {
            if (this.pause) {
                return;
            }
            final BBoxFrameRecord record = (BBoxFrameRecord)event.getValue();
            if (record == null) {
                return;
            }
            UiEnv.get().invokeLater(new Runnable(){

                @Override
                public void run() {
                    BBoxAnalyzerView.this.records.add((Object)record);
                    while (BBoxAnalyzerView.this.records.size() > BBoxAnalyzerView.this.getAnalyzer().getViewLogLimit()) {
                        BBoxAnalyzerView.this.records.remove(0);
                    }
                    BBoxAnalyzerView.this.updateTable();
                }
            });
        }
    }

    private void updateTable() {
        this.model.updateTable();
        this.table.ensureRowIsVisible(this.model.getRowCount());
        this.table.sizeColumnsToFit();
    }

    private BValue getValFromProp(BBoxFrameRecord event, Property prop, boolean ui) {
        return event.propToString(prop, this.getCurrentContext(), ui);
    }

    private BBoxAnalyzer getAnalyzer() {
        return (BBoxAnalyzer)this.getCurrentValue();
    }

    public void writeExport(PrintWriter writer) {
        BBoxFrameRecord[] recs = (BBoxFrameRecord[])this.records.copy().trim();
        if (recs.length == 0) {
            return;
        }
        Property[] props = recs[0].getFrozenPropertiesArray();
        for (int i = 0; i < recs.length; ++i) {
            for (int x = 0; x < props.length; ++x) {
                writer.print(props[x].getDefaultDisplayName(null));
                writer.print(": ");
                String valStr = this.getValFromProp(recs[i], props[x], false).toString();
                String[] vals = TextUtil.splitAndTrim((String)valStr, (char)'\n');
                for (int j = 0; j < vals.length; ++j) {
                    if (j > 0) {
                        writer.print("      ");
                    }
                    writer.println(vals[j]);
                }
            }
            writer.println();
        }
    }

    private class ClearCmd
    extends Command {
        private ClearCmd(BWidget owner) {
            super(owner, lex.getText("box.analyzer.view.cmd.clear.label"), BImage.make((BIcon)BIcon.std((String)"delete.png")), BAccelerator.DEFAULT, lex.getText("box.analyzer.view.cmd.clear.description"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BBoxAnalyzerView.this.records.clear();
            BBoxAnalyzerView.this.updateTable();
            return null;
        }
    }

    private class PauseCmd
    extends ToggleCommand {
        private PauseCmd(BWidget owner) {
            super(owner, lex.getText("box.analyzer.view.cmd.pause.label"), BImage.make((BIcon)BIcon.std((String)"mediaPause.png")), BAccelerator.DEFAULT, lex.getText("box.analyzer.view.cmd.pause.description"));
        }

        public synchronized void setSelected(boolean selected) {
            super.setSelected(selected);
            BBoxAnalyzerView.this.pause = selected;
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BGridPane pane = new BGridPane(2);
            BBoxFrameRecord rec = (BBoxFrameRecord)BBoxAnalyzerView.this.records.get(row);
            Property[] props = rec.getFrozenPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                pane.add(null, (BValue)new BLabel(props[i].getDefaultDisplayName(null) + ": ", BHalign.left));
                pane.add(null, (BValue)new BLabel(BBoxAnalyzerView.this.getValFromProp(rec, props[i], false).toString(), BHalign.left));
            }
            BConstrainedPane constPane = new BConstrainedPane((BWidget)new BScrollPane((BWidget)pane));
            constPane.setMinSize(550.0, 600.0);
            BDialog.open((BWidget)BBoxAnalyzerView.this, (String)lex.getText("box.analyzer.view.dlg.title"), (Object)constPane, (int)1);
        }
    }

    private class Renderer
    extends TableCellRenderer {
        private Renderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BBoxRecordType recordType = ((BBoxFrameRecord)BBoxAnalyzerView.this.records.get(cell.row)).getRecordType();
            if (recordType == BBoxRecordType.request) {
                return requestBrush;
            }
            if (recordType == BBoxRecordType.response) {
                return responseBrush;
            }
            if (recordType == BBoxRecordType.error) {
                return errorBrush;
            }
            return statusBrush;
        }
    }

    private class Model
    extends TableModel {
        private BBoxFrameRecord dummyEvent = new BBoxFrameRecord();
        private Property[] props = this.dummyEvent.getFrozenPropertiesArray();

        private Model() {
        }

        public int getColumnCount() {
            return this.props.length;
        }

        public String getColumnName(int col) {
            return this.props[col].getDefaultDisplayName(null);
        }

        public int getRowCount() {
            return BBoxAnalyzerView.this.records.size();
        }

        public Object getValueAt(int row, int col) {
            BString valStr;
            BValue val = BBoxAnalyzerView.this.getValFromProp((BBoxFrameRecord)BBoxAnalyzerView.this.records.get(row), this.props[col], true);
            if (val instanceof BString && (valStr = (BString)val).getString().length() > 200) {
                return BString.make((String)(valStr.getString().substring(0, 199) + "..."));
            }
            return val;
        }

        public BImage getRowIcon(int row) {
            BBoxRecordType recordType = ((BBoxFrameRecord)BBoxAnalyzerView.this.records.get(row)).getRecordType();
            if (recordType == BBoxRecordType.request) {
                return requestIcon;
            }
            if (recordType == BBoxRecordType.response) {
                return responseIcon;
            }
            return blankIcon;
        }
    }
}

