/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibImport;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class Mib
implements MibContext {
    private File file;
    private MibLoader loader;
    private MibLoaderLog log;
    private boolean loaded = false;
    private String name = null;
    private int smiVersion = 1;
    private String headerComment = null;
    private String footerComment = null;
    private ArrayList imports = new ArrayList();
    private ArrayList symbolList = new ArrayList();
    private HashMap symbolNameMap = new HashMap();
    private HashMap symbolValueMap = new HashMap();

    Mib(File file, MibLoader loader, MibLoaderLog log) {
        this.file = file;
        this.loader = loader;
        this.log = log;
    }

    void initialize() throws MibLoaderException {
        int errors = this.log.errorCount();
        for (int i = 0; i < this.imports.size(); ++i) {
            MibImport imp = (MibImport)this.imports.get(i);
            try {
                imp.initialize(this.log);
                continue;
            }
            catch (MibException e) {
                this.log.addError(e.getLocation(), e.getMessage());
            }
        }
        if (errors != this.log.errorCount()) {
            throw new MibLoaderException(this.log);
        }
    }

    void validate() throws MibLoaderException {
        int errors = this.log.errorCount();
        for (int i = 0; i < this.symbolList.size(); ++i) {
            MibValueSymbol value;
            MibSymbol symbol = (MibSymbol)this.symbolList.get(i);
            try {
                symbol.initialize(this.log);
            }
            catch (MibException e) {
                this.log.addError(e.getLocation(), e.getMessage());
            }
            if (!(symbol instanceof MibValueSymbol) || !((value = (MibValueSymbol)symbol).getValue() instanceof NumberValue) && !(value.getValue() instanceof ObjectIdentifierValue)) continue;
            this.symbolValueMap.put(value.getValue().toString(), symbol);
        }
        if (errors != this.log.errorCount()) {
            throw new MibLoaderException(this.log);
        }
    }

    void clear() {
        this.loader = null;
        this.log = null;
        if (this.imports != null) {
            this.imports.clear();
        }
        this.imports = null;
        if (this.symbolList != null) {
            for (int i = 0; i < this.symbolList.size(); ++i) {
                ((MibSymbol)this.symbolList.get(i)).clear();
            }
            this.symbolList.clear();
        }
        this.symbolList = null;
        if (this.symbolNameMap != null) {
            this.symbolNameMap.clear();
        }
        this.symbolNameMap = null;
        if (this.symbolValueMap != null) {
            this.symbolValueMap.clear();
        }
        this.symbolValueMap = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.name.equals(obj);
        }
        if (this.file != null && obj instanceof File) {
            return this.file.equals(obj);
        }
        if (obj instanceof Mib) {
            return obj.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
        if (this.file == null) {
            this.file = new File(name);
        }
    }

    public File getFile() {
        return this.file;
    }

    public MibLoader getLoader() {
        return this.loader;
    }

    public MibLoaderLog getLog() {
        return this.log;
    }

    public int getSmiVersion() {
        return this.smiVersion;
    }

    void setSmiVersion(int version) {
        this.smiVersion = version;
    }

    public String getHeaderComment() {
        return this.headerComment;
    }

    void setHeaderComment(String comment) {
        this.headerComment = comment;
    }

    public String getFooterComment() {
        return this.footerComment;
    }

    void setFooterComment(String comment) {
        this.footerComment = comment;
    }

    public Collection getAllImports() {
        ArrayList<MibImport> res = new ArrayList<MibImport>();
        for (int i = 0; i < this.imports.size(); ++i) {
            MibImport imp = (MibImport)this.imports.get(i);
            if (!imp.hasSymbols()) continue;
            res.add(imp);
        }
        return res;
    }

    MibImport getImport(String name) {
        for (int i = 0; i < this.imports.size(); ++i) {
            MibImport imp = (MibImport)this.imports.get(i);
            if (!imp.getName().equals(name)) continue;
            return imp;
        }
        return null;
    }

    void addImport(MibImport ref) {
        this.imports.add(ref);
    }

    public Mib[] getImportingMibs() {
        ArrayList<Mib> res = new ArrayList<Mib>();
        Mib[] mibs = this.loader.getAllMibs();
        for (int i = 0; i < mibs.length; ++i) {
            if (mibs[i] == this || mibs[i].getImport(this.name) == null) continue;
            res.add(mibs[i]);
        }
        mibs = new Mib[res.size()];
        res.toArray(mibs);
        return mibs;
    }

    public Collection getAllSymbols() {
        return this.symbolList;
    }

    public MibSymbol getSymbol(String name) {
        return (MibSymbol)this.symbolNameMap.get(name);
    }

    public MibValueSymbol getSymbolByValue(String value) {
        return (MibValueSymbol)this.symbolValueMap.get(value);
    }

    public MibValueSymbol getSymbolByValue(MibValue value) {
        return (MibValueSymbol)this.symbolValueMap.get(value.toString());
    }

    public MibValueSymbol getSymbolByOid(String oid) {
        int pos;
        do {
            MibValueSymbol sym;
            if ((sym = this.getSymbolByValue(oid)) != null) {
                return sym;
            }
            pos = oid.lastIndexOf(".");
            if (pos <= 0) continue;
            oid = oid.substring(0, pos);
        } while (pos > 0);
        return null;
    }

    public MibValueSymbol getRootSymbol() {
        MibValueSymbol parent;
        MibValueSymbol root = null;
        for (int i = 0; i < this.symbolList.size(); ++i) {
            if (!(this.symbolList.get(i) instanceof MibValueSymbol)) continue;
            root = (MibValueSymbol)this.symbolList.get(i);
            break;
        }
        while (root != null && (parent = root.getParent()) != null && root.getMib().equals(parent.getMib())) {
            root = parent;
        }
        return root;
    }

    void addSymbol(MibSymbol symbol) {
        this.symbolList.add(symbol);
        this.symbolNameMap.put(symbol.getName(), symbol);
    }

    @Override
    public MibSymbol findSymbol(String name, boolean expanded) {
        return this.getSymbol(name);
    }

    public String toString() {
        return this.getName();
    }
}

