/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.HashMap;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.type.ObjectIdentifierType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

class DefaultContext
implements MibContext {
    public static final String CCITT = "ccitt";
    public static final String ISO = "iso";
    public static final String JOINT_ISO_CCITT = "joint-iso-ccitt";
    private HashMap symbols = new HashMap();

    DefaultContext() {
        this.initialize();
    }

    private void initialize() {
        ObjectIdentifierValue oid = new ObjectIdentifierValue(CCITT, 0);
        MibValueSymbol symbol = new MibValueSymbol(new FileLocation(null, -1, -1), null, CCITT, new ObjectIdentifierType(), oid);
        oid.setSymbol(symbol);
        this.symbols.put(CCITT, symbol);
        oid = new ObjectIdentifierValue(ISO, 1);
        symbol = new MibValueSymbol(new FileLocation(null, -1, -1), null, ISO, new ObjectIdentifierType(), oid);
        oid.setSymbol(symbol);
        this.symbols.put(ISO, symbol);
        oid = new ObjectIdentifierValue(JOINT_ISO_CCITT, 2);
        symbol = new MibValueSymbol(new FileLocation(null, -1, -1), null, JOINT_ISO_CCITT, new ObjectIdentifierType(), oid);
        oid.setSymbol(symbol);
        this.symbols.put(JOINT_ISO_CCITT, symbol);
    }

    @Override
    public MibSymbol findSymbol(String name, boolean expanded) {
        return (MibSymbol)this.symbols.get(name);
    }

    public String toString() {
        return "<defaults>";
    }
}

