/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

public class RegExpException
extends Exception {
    public static final int UNEXPECTED_CHARACTER = 1;
    public static final int UNTERMINATED_PATTERN = 2;
    public static final int UNSUPPORTED_SPECIAL_CHARACTER = 3;
    public static final int UNSUPPORTED_ESCAPE_CHARACTER = 4;
    public static final int INVALID_REPEAT_COUNT = 5;
    private int type;
    private int position;
    private String pattern;

    public RegExpException(int type, int pos, String pattern) {
        this.type = type;
        this.position = pos;
        this.pattern = pattern;
    }

    @Override
    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        switch (this.type) {
            case 1: {
                buffer.append("unexpected character");
                break;
            }
            case 2: {
                buffer.append("unterminated pattern");
                break;
            }
            case 3: {
                buffer.append("unsupported character");
                break;
            }
            case 4: {
                buffer.append("unsupported escape character");
                break;
            }
            case 5: {
                buffer.append("invalid repeat count");
                break;
            }
            default: {
                buffer.append("internal error");
            }
        }
        buffer.append(": ");
        if (this.position < this.pattern.length()) {
            buffer.append('\'');
            buffer.append(this.pattern.substring(this.position));
            buffer.append('\'');
        } else {
            buffer.append("<end of pattern>");
        }
        buffer.append(" at position ");
        buffer.append(this.position);
        return buffer.toString();
    }
}

