/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import java.io.Reader;

public class ReaderBuffer
implements CharSequence {
    public static final int BLOCK_SIZE = 1024;
    private char[] buffer = new char[4096];
    private int pos = 0;
    private int length = 0;
    private Reader input = null;
    private int line = 1;
    private int column = 1;

    public ReaderBuffer(Reader input) {
        this.input = input;
    }

    public void dispose() {
        this.buffer = null;
        this.pos = 0;
        this.length = 0;
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.input = null;
        }
    }

    public int position() {
        return this.pos;
    }

    public int lineNumber() {
        return this.line;
    }

    public int columnNumber() {
        return this.column;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.buffer[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        return new String(this.buffer, start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public int peek(int offset) throws IOException {
        int index = this.pos + offset;
        if (index >= this.length) {
            this.ensureBuffered(offset + 1);
            index = this.pos + offset;
        }
        return index >= this.length ? -1 : this.buffer[index];
    }

    public String read(int offset) throws IOException {
        this.ensureBuffered(offset + 1);
        if (this.pos >= this.length) {
            return null;
        }
        int count = this.length - this.pos;
        if (count > offset) {
            count = offset;
        }
        this.updateLineColumnNumbers(count);
        String result = new String(this.buffer, this.pos, count);
        this.pos += count;
        if (this.input == null && this.pos >= this.length) {
            this.dispose();
        }
        return result;
    }

    private void updateLineColumnNumbers(int offset) {
        for (int i = 0; i < offset; ++i) {
            if (this.buffer[this.pos + i] == '\n') {
                ++this.line;
                this.column = 1;
                continue;
            }
            ++this.column;
        }
    }

    private void ensureBuffered(int offset) throws IOException {
        int size;
        if (this.input == null || this.pos + offset < this.length) {
            return;
        }
        if (this.pos > 1024) {
            this.length -= this.pos - 16;
            System.arraycopy(this.buffer, this.pos - 16, this.buffer, 0, this.length);
            this.pos = 16;
        }
        if ((size = this.pos + offset - this.length + 1) % 1024 != 0) {
            size = (1 + size / 1024) * 1024;
        }
        this.ensureCapacity(this.length + size);
        try {
            while (this.input != null && size > 0) {
                int readSize = this.input.read(this.buffer, this.length, size);
                if (readSize > 0) {
                    this.length += readSize;
                    size -= readSize;
                    continue;
                }
                this.input.close();
                this.input = null;
            }
        }
        catch (IOException e) {
            this.input = null;
            throw e;
        }
    }

    private void ensureCapacity(int size) {
        if (this.buffer.length >= size) {
            return;
        }
        if (size % 1024 != 0) {
            size = (1 + size / 1024) * 1024;
        }
        char[] newbuf = new char[size];
        System.arraycopy(this.buffer, 0, newbuf, 0, this.length);
        this.buffer = newbuf;
    }
}

