/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;

public class Analyzer {
    public void reset() {
    }

    public Node analyze(Node node) throws ParserLogException {
        ParserLogException log = new ParserLogException();
        node = this.analyze(node, log);
        if (log.getErrorCount() > 0) {
            throw log;
        }
        return node;
    }

    private Node analyze(Node node, ParserLogException log) {
        block13: {
            int errorCount = log.getErrorCount();
            if (node instanceof Production) {
                Production prod = (Production)node;
                prod = this.newProduction(prod.getPattern());
                try {
                    this.enter(prod);
                }
                catch (ParseException e) {
                    log.addError(e);
                }
                for (int i = 0; i < node.getChildCount(); ++i) {
                    try {
                        this.child(prod, this.analyze(node.getChildAt(i), log));
                        continue;
                    }
                    catch (ParseException e) {
                        log.addError(e);
                    }
                }
                try {
                    return this.exit(prod);
                }
                catch (ParseException e) {
                    if (errorCount == log.getErrorCount()) {
                        log.addError(e);
                    }
                    break block13;
                }
            }
            node.removeAllValues();
            try {
                this.enter(node);
            }
            catch (ParseException e) {
                log.addError(e);
            }
            try {
                return this.exit(node);
            }
            catch (ParseException e) {
                if (errorCount != log.getErrorCount()) break block13;
                log.addError(e);
            }
        }
        return null;
    }

    protected Production newProduction(ProductionPattern pattern) {
        return new Production(pattern);
    }

    protected void enter(Node node) throws ParseException {
    }

    protected Node exit(Node node) throws ParseException {
        return node;
    }

    protected void child(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected Node getChildAt(Node node, int pos) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        Node child = node.getChildAt(pos);
        if (child == null) {
            throw new ParseException(0, "node '" + node.getName() + "' has no child at position " + pos, node.getStartLine(), node.getStartColumn());
        }
        return child;
    }

    protected Node getChildWithId(Node node, int id) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            if (child == null || child.getId() != id) continue;
            return child;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no child with id " + id, node.getStartLine(), node.getStartColumn());
    }

    protected Object getValue(Node node, int pos) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        Object value = node.getValue(pos);
        if (value == null) {
            throw new ParseException(0, "node '" + node.getName() + "' has no value at position " + pos, node.getStartLine(), node.getStartColumn());
        }
        return value;
    }

    protected int getIntValue(Node node, int pos) throws ParseException {
        Object value = this.getValue(node, pos);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no integer value at position " + pos, node.getStartLine(), node.getStartColumn());
    }

    protected String getStringValue(Node node, int pos) throws ParseException {
        Object value = this.getValue(node, pos);
        if (value instanceof String) {
            return (String)value;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no string value at position " + pos, node.getStartLine(), node.getStartColumn());
    }

    protected ArrayList getChildValues(Node node) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            ArrayList values = child.getAllValues();
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }
}

