/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicEnumeration;
import net.percederberg.grammatica.code.visualbasic.VisualBasicFile;
import net.percederberg.grammatica.code.visualbasic.VisualBasicNamespace;
import net.percederberg.grammatica.output.VisualBasicParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class VisualBasicConstantsFile {
    private static final String TYPE_COMMENT = "<remarks>An enumeration with token and production node\nconstants.</remarks>";
    private VisualBasicParserGenerator gen;
    private VisualBasicFile file;
    private VisualBasicEnumeration enm;
    private HashMap constantNames = new HashMap();

    public VisualBasicConstantsFile(VisualBasicParserGenerator gen) {
        String name = gen.getBaseName() + "Constants";
        this.gen = gen;
        this.file = new VisualBasicFile(gen.getBaseDir(), name);
        int modifiers = gen.getPublicAccess() ? 1 : 4;
        this.enm = new VisualBasicEnumeration(modifiers, name);
        this.initializeCode();
    }

    private void initializeCode() {
        if (this.gen.getNamespace() == null) {
            this.file.addEnumeration(this.enm);
        } else {
            VisualBasicNamespace n = new VisualBasicNamespace(this.gen.getNamespace());
            n.addEnumeration(this.enm);
            this.file.addNamespace(n);
        }
        String str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new VisualBasicComment(1, str));
        this.enm.addComment(new VisualBasicComment(TYPE_COMMENT));
    }

    public void addToken(TokenPattern pattern) {
        String constant = this.gen.getCodeStyle().getUpperCase(pattern.getName());
        this.enm.addConstant(constant, String.valueOf(pattern.getId()));
        this.constantNames.put(new Integer(pattern.getId()), constant);
    }

    public void addProduction(ProductionPattern pattern) {
        if (!pattern.isSynthetic()) {
            String constant = this.gen.getCodeStyle().getUpperCase(pattern.getName());
            this.enm.addConstant(constant, String.valueOf(pattern.getId()));
            this.constantNames.put(new Integer(pattern.getId()), constant);
        }
    }

    public String getConstant(int id) {
        String name = (String)this.constantNames.get(new Integer(id));
        if (name == null) {
            return null;
        }
        return this.enm.toString() + "." + name;
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

