/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.visualbasic;

import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicType;

public class VisualBasicEnumeration
extends VisualBasicType {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_FRIEND = 2;
    public static final int PROTECTED = 3;
    public static final int FRIEND = 4;
    public static final int PRIVATE = 5;
    public static final int SHADOWS = 64;
    Constant last = null;

    public VisualBasicEnumeration(String name) {
        this(1, name);
    }

    public VisualBasicEnumeration(int modifiers, String name) {
        super(modifiers, name, "");
    }

    @Override
    public int category() {
        return 3;
    }

    public void addConstant(String name) {
        this.addConstant(name, null);
    }

    public void addConstant(String name, String value) {
        this.addConstant(name, value, null);
    }

    public void addConstant(String name, String value, VisualBasicComment comment) {
        Constant c = new Constant(name, value);
        if (comment != null) {
            c.setComment(comment);
        }
        this.addElement(c);
        this.last = c;
    }

    @Override
    public void print(PrintWriter out, CodeStyle style, int indent) {
        this.print(out, style, indent, "Enum");
    }

    @Override
    protected void printSeparator(PrintWriter out, CodeStyle style, CodeElement prev, CodeElement next) {
    }

    private class Constant
    extends CodeElement {
        private String name;
        private String value;
        private VisualBasicComment comment;

        public Constant(String name, String value) {
            this.name = name;
            this.value = value;
            this.comment = null;
        }

        @Override
        public int category() {
            return 0;
        }

        public void setComment(VisualBasicComment comment) {
            this.comment = comment;
        }

        @Override
        public void print(PrintWriter out, CodeStyle style, int indent) {
            if (this.comment != null) {
                out.println();
                this.comment.print(out, style, indent);
            }
            out.print(style.getIndent(indent));
            out.print("[" + this.name + "]");
            if (this.value != null) {
                out.print(" = ");
                out.print(this.value);
            }
            out.println();
        }
    }
}

