/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.messages;

import com.tridium.flexSerial.enums.BEncodeTypeEnum;
import com.tridium.flexSerial.messages.BFlexMessageElement;
import java.io.ByteArrayInputStream;
import javax.baja.sys.BFacets;

public class FlexInputStream
extends ByteArrayInputStream {
    private static final int MAX_BYTES_IN_INT = 4;

    public FlexInputStream(byte[] buf) {
        super(buf);
    }

    public FlexInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public int read(BEncodeTypeEnum encode, BFacets facets) {
        if (encode.equals((Object)BEncodeTypeEnum.AsciiHex)) {
            return this.readHexByte();
        }
        if (encode.equals((Object)BEncodeTypeEnum.Ascii)) {
            return this.readStringInt(encode, facets);
        }
        return this.read();
    }

    public int readInt(int size, BEncodeTypeEnum encode, BFacets facets) {
        boolean isBigEndian;
        if (encode.equals((Object)BEncodeTypeEnum.Ascii)) {
            return this.readStringInt(encode, facets);
        }
        if (size > 4 || size < 1) {
            System.out.println("\n**************************************************");
            System.out.println("         Invalid int size: " + size);
            System.out.println("**************************************************\n");
            if (size > 4) {
                size = 4;
            }
            if (size < 1) {
                size = 1;
            }
        }
        if (isBigEndian = BFlexMessageElement.isBigEndian(facets)) {
            return this.readBigEndianInt(size, encode, facets);
        }
        return this.readLittleEndianInt(size, encode, facets);
    }

    private int readBigEndianInt(int size, BEncodeTypeEnum encode, BFacets facets) {
        int rawInt = 0;
        if (size <= 4) {
            for (int index = size - 1; index >= 0; --index) {
                int byteValue = this.read(encode, facets);
                rawInt |= byteValue << index * 8;
            }
        }
        return rawInt;
    }

    private int readLittleEndianInt(int size, BEncodeTypeEnum encode, BFacets facets) {
        int rawInt = 0;
        if (size <= 4) {
            for (int index = 0; index < size; ++index) {
                rawInt |= this.read(encode, facets) << index * 8;
            }
        }
        return rawInt;
    }

    public float readFloat(BEncodeTypeEnum encode, BFacets facets) {
        if (encode.equals((Object)BEncodeTypeEnum.Ascii)) {
            String value = this.readString(encode, facets);
            try {
                return Float.parseFloat(value.trim());
            }
            catch (Exception e) {
                return Float.NaN;
            }
        }
        try {
            return Float.intBitsToFloat(this.readInt(4, encode, facets));
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }

    public int readWord(BEncodeTypeEnum encode, BFacets facets) {
        boolean isBigEndian = BFlexMessageElement.isBigEndian(facets);
        if (encode.equals((Object)BEncodeTypeEnum.AsciiHex)) {
            return this.readHexWord(isBigEndian);
        }
        if (encode.equals((Object)BEncodeTypeEnum.Ascii)) {
            String value = this.readString(encode, facets);
            try {
                return Integer.parseInt(value.trim());
            }
            catch (Exception e) {
                return -1;
            }
        }
        int value = this.read() & 0xFF;
        if (isBigEndian) {
            return value << 8 | this.read() & 0xFF;
        }
        return (this.read() & 0xFF) << 8 | value;
    }

    public int readHexWord(boolean isBigEndian) {
        if (isBigEndian) {
            return this.readHexByte() << 8 | this.readHexByte();
        }
        return this.readHexByte() | this.readHexByte() << 8;
    }

    public int readHexByte() {
        int rawValue = this.readDigit();
        rawValue = rawValue << 4 | this.readDigit();
        return rawValue;
    }

    public int readDigit() {
        return Character.digit((char)(this.read() & 0xFF), 16) & 0xF;
    }

    private int readStringInt(BEncodeTypeEnum encode, BFacets facets) {
        String value = this.readString(encode, facets);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String readString(BEncodeTypeEnum encode, BFacets facets) {
        String delimiter = facets.gets("endDelimiter", "");
        int fieldSize = facets.geti("fieldWidth", -1);
        boolean nullTerminate = facets.getb("nullTerminate", false);
        StringBuilder sb = new StringBuilder();
        boolean done = false;
        if (delimiter.length() > 0) {
            while (!done) {
                int value = this.read();
                if (value < 0) {
                    done = true;
                    continue;
                }
                if (value == delimiter.charAt(0)) {
                    done = true;
                    continue;
                }
                sb.append((char)value);
            }
        } else if (fieldSize > 0) {
            int value;
            for (int i = 0; i < fieldSize && (value = this.read()) >= 0; ++i) {
                sb.append((char)value);
            }
        } else {
            while (!done) {
                int value = this.read();
                if (value < 0) {
                    done = true;
                    continue;
                }
                if (value == 0) {
                    done = true;
                    continue;
                }
                sb.append((char)value);
            }
        }
        return sb.toString();
    }
}

