/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.flexSerial.messages.SerialMessageConst;
import com.tridium.flexSerial.messages.SerialReceivedMessage;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.Clock;

public class FlexSerialCommReceiver
extends CommReceiver
implements SerialMessageConst {
    private static Integer DEFAULT_TAG = -1;
    private static final int WAIT_FOR_FRAME_START = 0;
    private static final int READ_DATA = 20;
    private static final int READ_FRAME_END = 30;
    private long lastCharTicks = 0L;
    private long maxReceiveSilentTime = 0L;
    private byte[] frameStart = new byte[0];
    private byte[] frameEnd = new byte[]{13};
    private boolean stripReceiveFraming = false;
    private int state = 0;
    private ByteBuffer rcvBuffer = new ByteBuffer();
    private SerialReceivedMessage msg = null;

    public void setFrameStart(byte[] start) {
        this.frameStart = start;
    }

    public void setFrameEnd(byte[] end) {
        this.frameEnd = end;
    }

    public void setStripReceiveFraming(boolean strip) {
        this.stripReceiveFraming = strip;
    }

    public void setMaxReceiveSilentTime(int time) {
        this.maxReceiveSilentTime = time;
    }

    protected ReceivedMessage receive() throws Exception {
        this.state = this.frameStart.length == 0 ? 0 : 0;
        boolean done = false;
        this.rcvBuffer.reset();
        while (!done) {
            int charIn = this.getInputStream().read();
            boolean newChar = charIn != -1;
            charIn &= 0xFF;
            if (newChar) {
                this.getLog().trace("state= " + this.state + "; rx= " + Integer.toHexString(charIn));
                switch (this.state) {
                    case 0: {
                        if (this.frameStart.length == 0) {
                            this.rcvBuffer.reset();
                            this.rcvBuffer.write((int)((byte)charIn));
                            this.state = 20;
                            break;
                        }
                        if (charIn != (this.frameStart[0] & 0xFF)) break;
                        this.rcvBuffer.reset();
                        if (!this.stripReceiveFraming) {
                            this.rcvBuffer.write((int)((byte)charIn));
                        }
                        if (this.frameStart.length == 1) {
                            this.state = 20;
                            break;
                        }
                        this.state = 1;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        int index;
                        if (!this.stripReceiveFraming) {
                            this.rcvBuffer.write((int)((byte)charIn));
                        }
                        if (charIn == (this.frameStart[index = this.state - 0] & 0xFF)) {
                            ++this.state;
                            if (this.frameStart.length != ++index) break;
                            this.state = 20;
                            break;
                        }
                        this.state = 0;
                        break;
                    }
                    case 20: {
                        if (this.frameEnd.length > 0) {
                            if (charIn == (this.frameEnd[0] & 0xFF)) {
                                if (!this.stripReceiveFraming) {
                                    this.rcvBuffer.write((int)((byte)charIn));
                                }
                                if (this.frameEnd.length == 1) {
                                    done = true;
                                    break;
                                }
                                this.state = 31;
                                break;
                            }
                            this.rcvBuffer.write((int)((byte)charIn));
                            break;
                        }
                        this.rcvBuffer.write((int)((byte)charIn));
                        break;
                    }
                    default: {
                        int index;
                        if (!this.stripReceiveFraming) {
                            this.rcvBuffer.write((int)((byte)charIn));
                        }
                        if (charIn == (this.frameEnd[index = this.state - 30] & 0xFF)) {
                            ++this.state;
                            if (this.frameEnd.length != ++index) break;
                            done = true;
                            break;
                        }
                        this.state = 20;
                    }
                }
                if (this.rcvBuffer.getLength() > 0) {
                    this.lastCharTicks = Clock.ticks();
                }
            }
            if (this.frameEnd.length != 0 || this.rcvBuffer.getLength() <= 0 || this.maxReceiveSilentTime <= 0L || Clock.ticks() - this.lastCharTicks <= this.maxReceiveSilentTime) continue;
            done = true;
        }
        if (this.msg == null) {
            this.msg = new SerialReceivedMessage(this.rcvBuffer.getBytes(), this.rcvBuffer.getLength(), DEFAULT_TAG);
        } else {
            this.msg.setBytes(this.rcvBuffer.getBytes());
            this.msg.setLength(this.rcvBuffer.getLength());
            this.msg.setTag(DEFAULT_TAG);
        }
        return this.msg;
    }

    Log getLog() {
        Log netLog = this.getComm().getNetwork().getLog();
        return Log.getLog((String)(netLog.getLogName() + ".rx"));
    }
}

