/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial;

import com.tridium.flexSerial.BFlexSerialNetwork;
import com.tridium.flexSerial.messages.SerialMessage;
import com.tridium.flexSerial.messages.SerialResponse;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="request", type="BStatusString", defaultValue="new BStatusString(\"\")", flags=264), @NiagaraProperty(name="addFrameStart", type="boolean", defaultValue="true"), @NiagaraProperty(name="addFrameEnd", type="boolean", defaultValue="true"), @NiagaraProperty(name="response", type="BStatusString", defaultValue="new BStatusString(\"\")", flags=264), @NiagaraProperty(name="responseExpected", type="boolean", defaultValue="true"), @NiagaraProperty(name="stripFrameStart", type="boolean", defaultValue="true"), @NiagaraProperty(name="stripFrameEnd", type="boolean", defaultValue="true")})
@NiagaraAction(name="sendRequest")
public class BSerialRequest
extends BComponent {
    @Generated
    public static final Property request = BSerialRequest.newProperty((int)264, (BValue)new BStatusString(""), null);
    @Generated
    public static final Property addFrameStart = BSerialRequest.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property addFrameEnd = BSerialRequest.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property response = BSerialRequest.newProperty((int)264, (BValue)new BStatusString(""), null);
    @Generated
    public static final Property responseExpected = BSerialRequest.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property stripFrameStart = BSerialRequest.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property stripFrameEnd = BSerialRequest.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action sendRequest = BSerialRequest.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSerialRequest.class);
    BFlexSerialNetwork network;
    static BStatusString nre = new BStatusString("Response Not Expected");

    @Generated
    public BStatusString getRequest() {
        return (BStatusString)this.get(request);
    }

    @Generated
    public void setRequest(BStatusString v) {
        this.set(request, (BValue)v, null);
    }

    @Generated
    public boolean getAddFrameStart() {
        return this.getBoolean(addFrameStart);
    }

    @Generated
    public void setAddFrameStart(boolean v) {
        this.setBoolean(addFrameStart, v, null);
    }

    @Generated
    public boolean getAddFrameEnd() {
        return this.getBoolean(addFrameEnd);
    }

    @Generated
    public void setAddFrameEnd(boolean v) {
        this.setBoolean(addFrameEnd, v, null);
    }

    @Generated
    public BStatusString getResponse() {
        return (BStatusString)this.get(response);
    }

    @Generated
    public void setResponse(BStatusString v) {
        this.set(response, (BValue)v, null);
    }

    @Generated
    public boolean getResponseExpected() {
        return this.getBoolean(responseExpected);
    }

    @Generated
    public void setResponseExpected(boolean v) {
        this.setBoolean(responseExpected, v, null);
    }

    @Generated
    public boolean getStripFrameStart() {
        return this.getBoolean(stripFrameStart);
    }

    @Generated
    public void setStripFrameStart(boolean v) {
        this.setBoolean(stripFrameStart, v, null);
    }

    @Generated
    public boolean getStripFrameEnd() {
        return this.getBoolean(stripFrameEnd);
    }

    @Generated
    public void setStripFrameEnd(boolean v) {
        this.setBoolean(stripFrameEnd, v, null);
    }

    @Generated
    public void sendRequest() {
        this.invoke(sendRequest, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.network = this.getNetwork();
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property == request) {
            this.doSendRequest();
        }
    }

    public void doSendRequest() {
        if (this.getNetwork() == null) {
            return;
        }
        String frameStart = new String(this.network.getMessageBlocks().getFrameStart().getByteArray());
        String frameEnd = new String(this.network.getMessageBlocks().getFrameEnd().getByteArray());
        String reqData = this.getRequest().getValue();
        if (this.getAddFrameStart()) {
            reqData = frameStart + reqData;
        }
        if (this.getAddFrameEnd()) {
            reqData = reqData + frameEnd;
        }
        SerialMessage req = new SerialMessage(reqData);
        boolean isResponseExpected = this.getResponseExpected();
        req.setResponseExpected(isResponseExpected);
        if (isResponseExpected) {
            SerialResponse resp = (SerialResponse)this.network.sendSync(req);
            if (resp == null) {
                System.out.println(" null response received");
            }
            if (resp != null && resp.getBytes() != null) {
                String respString = new String(resp.getBytes());
                if (this.getStripFrameStart() && respString.startsWith(frameStart)) {
                    respString = respString.substring(frameStart.length());
                }
                if (this.getStripFrameEnd() && respString.endsWith(frameEnd)) {
                    respString = respString.substring(0, respString.length() - frameEnd.length());
                }
                this.getResponse().setValue(respString);
                this.getResponse().setStatusDown(false);
            } else {
                this.getResponse().setStatusDown(true);
            }
        } else {
            this.network.sendSync(req);
            this.setResponse(nre);
        }
    }

    BFlexSerialNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BFlexSerialNetwork)) continue;
            this.network = (BFlexSerialNetwork)parent;
            return this.network;
        }
        return null;
    }
}

