/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BacnetDiscoveryUtil;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.transport.TransactionException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.bacnet.point.BBacnetTuningPolicyMap;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.MetaDataContext;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.bacnet.virtual.BBacnetVirtualArray;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;

@NiagaraType
@Deprecated
@NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.NULL")
@NiagaraAction(name="subscribe", flags=20)
public class BBacnetVirtualComponent
extends BVirtualComponent
implements BIBacnetPollable,
BacnetConst {
    @Generated
    public static final Property facets = BBacnetVirtualComponent.newProperty((int)0, (BValue)BFacets.NULL, null);
    @Generated
    public static final Action subscribe = BBacnetVirtualComponent.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetVirtualComponent.class);
    private BBacnetObjectIdentifier objectId = BBacnetObjectIdentifier.DEFAULT;
    private String tpName = "defaultPolicy";
    private BBacnetTuningPolicy cachedPolicy = null;
    private int writePriority = -1;
    private PollListEntry[] ples = null;
    private Hashtable<String, Property> propsMap = new Hashtable();
    private Hashtable<Property, Hashtable<PollListEntry, BStatus>> propsStatusMap = null;
    private boolean isPollSubscribed = false;
    private static AsnInputStream asnIn = new AsnInputStream();
    private static Logger log = Logger.getLogger("bacnet.virtual");
    static final String USE_FACETS = "useFacets";
    static final String PROPERTY_ID = "propertyId";
    public static final String INDEX = "index";
    static final String POLICY_DEF = "policy=";
    static final int POLICY_DEF_LEN = 7;
    static final String PRIORITY_DEF = "priority=";
    static final int PRIORITY_DEF_LEN = 9;
    static final String STATUS_TAG = "status=";
    static final int STATUS_TAG_LEN = 7;
    static final String STATUS_SOURCE_FACET = "statusSrc";

    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    @Generated
    public void subscribe() {
        this.invoke(subscribe, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetVirtualComponent() {
    }

    public BBacnetVirtualComponent(String virtualPathName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BVC ctor(): vpath=" + virtualPathName);
        }
        try {
            StringTokenizer st = new StringTokenizer(virtualPathName, ";");
            this.objectId = (BBacnetObjectIdentifier)BBacnetObjectIdentifier.DEFAULT.decodeFromString(st.nextToken());
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith(POLICY_DEF)) {
                    this.tpName = s.substring(7);
                    continue;
                }
                if (!s.startsWith(PRIORITY_DEF)) continue;
                try {
                    this.writePriority = Integer.parseInt(s.substring(9));
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Invalid priority: " + s + " in virtualPathName");
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "IOException occurred in BBacnetVirtualComponent", e);
        }
    }

    public void doSubscribe() {
        BBacnetPoll pollService = (BBacnetPoll)this.network().getPollService(this);
        pollService.subscribe(this);
        this.isPollSubscribed = true;
    }

    public String toString(Context cx) {
        return this.getName() + " (V)";
    }

    public boolean isChildLegal(BComponent c) {
        return true;
    }

    public void stopped() throws Exception {
        super.stopped();
        BBacnetPoll pollService = (BBacnetPoll)this.network().getPollService(this);
        pollService.unsubscribe(this);
    }

    public void added(Property p, Context cx) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + ".added(): " + p.getName() + " [" + p + "] cx=" + cx + (this.isSubscribed() ? " subscribed" : " unsubscribed") + (this.ples != null ? "  ples:" + this.ples.length : " ples=null"));
        }
        if (!this.isRunning()) {
            return;
        }
        if (this.isSubscribed()) {
            Array a = this.ples == null ? new Array(PollListEntry.class) : new Array((Object[])this.ples);
            this.addPolledProperty(p, (Array<PollListEntry>)a);
            if (a.size() > 0) {
                this.ples = (PollListEntry[])a.trim();
            }
            if (!this.isPollSubscribed) {
                this.subscribe();
            }
        }
    }

    public void removed(Property p, BValue oldValue, Context cx) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + ".removed(): " + p.getName() + " [" + p + "] ov=" + oldValue + " cx=" + cx + (this.isSubscribed() ? " subscribed" : " unsubscribed"));
        }
        if (!this.isRunning()) {
            return;
        }
        if (this.isSubscribed()) {
            Array a = this.ples == null ? new Array(PollListEntry.class) : new Array((Object[])this.ples);
            this.removePolledProperty(p, oldValue, (Array<PollListEntry>)a);
            this.ples = (PollListEntry[])a.trim();
        }
    }

    public void subscribed() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + ".subscribed(): path=" + this.getSlotPathOrd());
        }
        this.network().postAsync(new Runnable(){

            @Override
            public void run() {
                HashMap<String, BIDataValue> m = BacnetDiscoveryUtil.discoverFacets(BBacnetVirtualComponent.this.objectId, BBacnetVirtualComponent.this.device());
                BBacnetVirtualComponent.this.setFacets(BFacets.make(m));
            }
        });
        if (this.getPollListEntries() != null) {
            this.isPollSubscribed = true;
            this.subscribe();
        }
    }

    public void unsubscribed() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + ".unsubscribed(): path=" + this.getSlotPathOrd());
        }
        BBacnetPoll pollService = (BBacnetPoll)this.network().getPollService(this);
        pollService.unsubscribe(this);
        this.ples = null;
        this.isPollSubscribed = false;
        this.propsMap.clear();
    }

    public void changed(Property p, Context cx) {
        BInteger pid;
        super.changed(p, cx);
        if (cx == noWrite) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BFacets f = p.getFacets();
        if (log.isLoggable(Level.FINE)) {
            log.fine("changed(" + p + ", " + cx + ") on " + this + " prop facets=" + f);
        }
        if ((pid = (BInteger)f.getFacet(PROPERTY_ID)) != null) {
            BStatusValue sv;
            BInteger ndx;
            BValue v = this.get(p);
            int index = -1;
            if (v instanceof BBacnetVirtualArray && cx != null && (ndx = (BInteger)cx.getFacet(INDEX)) != null) {
                index = ndx.getInt();
                v = ((BBacnetVirtualArray)v).getElement(index);
            }
            byte[] encodedValue = null;
            PropertyInfo pi = this.device().getPropertyInfo(this.objectId.getObjectType(), pid.getInt());
            encodedValue = v instanceof BStatusValue ? ((sv = (BStatusValue)v).getStatus().isNull() ? AsnUtil.toAsnNull() : (pi != null ? AsnUtil.toAsn(pi.getAsnType(), sv.getValueValue()) : AsnUtil.toAsn(v))) : (pi != null ? AsnUtil.toAsn(pi.getAsnType(), v) : AsnUtil.toAsn(v));
            this.network().postWrite(new Write(pid.getInt(), index, encodedValue, this.writePriority));
        }
    }

    protected BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public int getWritePriority() {
        return this.writePriority;
    }

    public BBacnetTuningPolicy getPolicy() {
        if (this.cachedPolicy == null) {
            BBacnetTuningPolicyMap map = this.getPolicyMap();
            BValue x = map.get(this.tpName);
            if (x instanceof BBacnetTuningPolicy) {
                this.cachedPolicy = (BBacnetTuningPolicy)x;
            } else {
                log.warning("TuningPolicy not found: " + this.tpName);
                this.cachedPolicy = (BBacnetTuningPolicy)map.getDefaultPolicy();
            }
        }
        return this.cachedPolicy;
    }

    public BFacets getSlotFacets(Slot s) {
        BFacets f = s.getFacets();
        BBoolean useFacets = (BBoolean)f.getFacet(USE_FACETS);
        if (useFacets != null && useFacets.getBoolean()) {
            BFacets vcfac = this.getFacets();
            if (vcfac.equals((Object)BFacets.NULL)) {
                return f;
            }
            return vcfac;
        }
        return f;
    }

    public static boolean isStatusProp(String virtualPathName) {
        return virtualPathName.indexOf(STATUS_TAG) >= 0;
    }

    public static BString getStatusSource(String propertyName) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(propertyName, ";");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s == null || !s.startsWith(STATUS_TAG)) continue;
            sb.append(s.substring(7)).append(';');
        }
        return BString.make((String)sb.toString());
    }

    public void updateStatus() {
        BStatus devStatus = this.device().getStatus();
        SlotCursor sc = this.getProperties();
        while (sc.next(BStatusValue.class)) {
            BStatusValue sv = (BStatusValue)sc.get();
            int oldStatus = sv.getStatus().getBits();
            int newStatus = sv.getStatus().getBits();
            newStatus = devStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
            newStatus = devStatus.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
            newStatus = devStatus.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
            if (oldStatus == newStatus) continue;
            sv.setStatus(BStatus.make((int)newStatus));
        }
    }

    public BPollFrequency getPollFrequency() {
        BBacnetTuningPolicy policy = this.getPolicy();
        if (policy != null) {
            return policy.getPollFrequency();
        }
        return BPollFrequency.normal;
    }

    @Override
    public BBacnetDevice device() {
        return (BBacnetDevice)((BVirtualComponentSpace)this.getComponentSpace()).getVirtualGateway().getParent();
    }

    @Override
    public int getPollableType() {
        return 3;
    }

    @Override
    @Deprecated
    public boolean poll() {
        return false;
    }

    @Override
    public void readFail(String failureMsg) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("readFail(" + failureMsg + ") on " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromEncodedValue(byte[] encodedValue, BStatus status, Context cx) {
        block11: {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + ".fromEncodedValue:" + ByteArrayUtil.toHexString((byte[])encodedValue) + " status=" + status + "  cx=" + cx);
            }
            try {
                PollListEntry ple = (PollListEntry)cx;
                Context baseCx = cx.getBase();
                if (baseCx instanceof MetaDataContext) {
                    this.readMetaData(encodedValue, cx, (MetaDataContext)baseCx);
                    return;
                }
                Property p = this.getProperty(ple.getPropertyId(), ple.getPropertyArrayIndex());
                if (p == null) {
                    this.readFail("No property in virtual point for " + ple);
                    ((BBacnetPoll)this.network().getPollService(this)).removePLE(this, ple);
                    return;
                }
                BValue v = this.get(p);
                BStatusValue sv = null;
                if (v instanceof BStatusValue) {
                    sv = (BStatusValue)v.newCopy();
                }
                AsnInputStream asnInputStream = asnIn;
                synchronized (asnInputStream) {
                    this.setProp(p, encodedValue, v, sv, ple.getPropertyArrayIndex());
                    SlotCursor c = this.getProperties();
                    String pname = p.getName();
                    while (c.next()) {
                        if (!c.property().getName().startsWith(pname)) continue;
                        v = c.get();
                        sv = null;
                        if (v instanceof BStatusValue) {
                            sv = (BStatusValue)v.newCopy();
                        }
                        this.setProp(c.property(), encodedValue, v, sv, ple.getPropertyArrayIndex());
                    }
                }
                this.readOk(p, ple);
            }
            catch (AsnException e) {
                this.readFail(e.toString());
                if (!log.isLoggable(Level.FINE)) break block11;
                log.log(Level.FINE, "Exception decoding value for " + this + ":" + (Object)((Object)e) + " ev=" + ByteArrayUtil.toHexString((byte[])encodedValue), (Throwable)((Object)e));
            }
        }
    }

    @Override
    public PollListEntry[] getPollListEntries() {
        if (!this.isRunning()) {
            return null;
        }
        if (this.ples == null) {
            Array a = new Array(PollListEntry.class);
            SlotCursor sc = this.getProperties();
            while (sc.next()) {
                this.addPolledProperty(sc.property(), (Array<PollListEntry>)a);
            }
            if (a.size() > 0) {
                this.ples = (PollListEntry[])a.trim();
            }
        }
        return this.ples;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetVirtualComponent", 2);
        out.prop((Object)"objectId", (Object)this.objectId);
        out.prop((Object)"tpName", (Object)this.tpName);
        out.prop((Object)"cachedPolicy", (Object)this.cachedPolicy);
        out.prop((Object)"writePriority", this.writePriority);
        out.prop((Object)"isPollSubscribed", this.isPollSubscribed);
        if (this.ples != null) {
            out.prop((Object)"PollListEntries (unsynch)", this.ples.length);
            for (int i = 0; i < this.ples.length; ++i) {
                out.prop((Object)("  " + i), (Object)this.ples[i]);
            }
        }
        out.prop((Object)"props", this.propsMap.size());
        Enumeration<String> e = this.propsMap.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement();
            out.prop((Object)(" " + k), (Object)this.propsMap.get(k));
        }
        out.endProps();
    }

    private Property getProperty(int propertyId, int index) {
        return this.propsMap.get(String.valueOf(propertyId << 16 | index & 0xFFFF));
    }

    private BBacnetNetwork network() {
        return (BBacnetNetwork)this.device().getNetwork();
    }

    private BBacnetTuningPolicyMap getPolicyMap() {
        BBacnetTuningPolicyMap map = (BBacnetTuningPolicyMap)this.network().get("tuningPolicies");
        if (map != null) {
            return map;
        }
        throw new IllegalStateException("Network missing tuningPolicies property");
    }

    private void readOk(Property p, PollListEntry ple) {
        if (this.get(p) instanceof BStatusValue) {
            this.updateStatus(p, ple, BStatus.ok);
        }
    }

    private void addPolledProperty(Property p, Array<PollListEntry> a) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + ".addPolledProperty(): " + p + " facets=" + this.getFacets());
        }
        int index = -1;
        BFacets f = p.getFacets();
        BInteger pid = (BInteger)f.getFacet(PROPERTY_ID);
        if (pid == null) {
            return;
        }
        BValue v = this.get(p);
        if (v instanceof BBacnetVirtualArray) {
            BBacnetVirtualArray va = (BBacnetVirtualArray)this.get(p);
            SlotCursor sc = va.getProperties();
            sc.next();
            sc.next();
            while (sc.next()) {
                index = BBacnetVirtualArray.index(sc.property().getName());
                a.add((Object)new PollListEntry(this.objectId, pid.getInt(), index, this.device(), this));
                String key = String.valueOf(pid.getInt() << 16 | index & 0xFFFF);
                this.propsMap.put(key, sc.property());
            }
        } else {
            BInteger ndx = (BInteger)f.getFacet(INDEX);
            if (ndx != null) {
                index = ndx.getInt();
            }
            a.add((Object)new PollListEntry(this.objectId, pid.getInt(), index, this.device(), this));
            String key = String.valueOf(pid.getInt() << 16 | index & 0xFFFF);
            this.propsMap.put(key, p);
            BString statusSourceFacet = (BString)f.getFacet(STATUS_SOURCE_FACET);
            if (v instanceof BStatusValue && statusSourceFacet != null) {
                StringTokenizer st = new StringTokenizer(statusSourceFacet.getString(), ";");
                while (st.hasMoreTokens()) {
                    this.addDoprPLE(st.nextToken(), a, p);
                    key = p.getName();
                }
            }
            this.propsMap.put(key, p);
        }
    }

    private void addDoprPLE(String token, Array<PollListEntry> a, Property baseProp) {
        BBacnetDeviceObjectPropertyReference dopr = BBacnetDeviceObjectPropertyReference.fromString(token);
        if (dopr != null) {
            BBacnetObjectIdentifier deviceId = dopr.getDeviceId();
            if (!dopr.isDeviceIdUsed() || deviceId.hashCode() == this.device().getObjectId().hashCode()) {
                a.add((Object)new PollListEntry(dopr.getObjectId(), dopr.getPropertyId(), dopr.getPropertyArrayIndex(), this.device(), this, (Context)new MetaDataContext(baseProp.getName())));
                this.propsMap.put(baseProp.getName(), baseProp);
            } else {
                BBacnetDevice dev = this.network().doLookupDeviceById(deviceId);
                if (dev != null) {
                    a.add((Object)new PollListEntry(dopr.getObjectId(), dopr.getPropertyId(), dopr.getPropertyArrayIndex(), dev, this, (Context)new MetaDataContext(baseProp.getName())));
                    this.propsMap.put(baseProp.getName(), baseProp);
                } else {
                    throw new IllegalStateException("Cannot find BACnet device for virtual component metadata:" + this + "  ref=" + dopr);
                }
            }
        }
    }

    private void removePolledProperty(Property p, BValue oldValue, Array<PollListEntry> a) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + ".removePolledProperty(): " + p);
        }
        int index = -1;
        BFacets f = p.getFacets();
        BInteger pid = (BInteger)f.getFacet(PROPERTY_ID);
        if (pid == null) {
            return;
        }
        PollListEntry ple = null;
        BBacnetPoll pollService = (BBacnetPoll)this.network().getPollService(this);
        if (oldValue instanceof BBacnetVirtualArray) {
            BBacnetVirtualArray va = (BBacnetVirtualArray)oldValue;
            SlotCursor sc = va.getProperties();
            sc.next();
            sc.next();
            while (sc.next()) {
                index = Integer.parseInt(sc.property().getName().substring(7));
                ple = new PollListEntry(this.objectId, pid.getInt(), index, this.device(), this);
                a.remove((Object)ple);
                this.propsMap.remove(String.valueOf(pid.getInt() << 16 | index & 0xFFFF));
                pollService.removePLE(this, ple);
            }
        } else {
            BInteger ndx = (BInteger)f.getFacet(INDEX);
            if (ndx != null) {
                index = ndx.getInt();
            }
            ple = new PollListEntry(this.objectId, pid.getInt(), index, this.device(), this);
            a.remove((Object)ple);
            this.propsMap.remove(String.valueOf(pid.getInt() << 16 | index & 0xFFFF));
            pollService.removePLE(this, ple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProp(Property p, byte[] encodedValue, BValue v, BStatusValue sv, int index) throws AsnException {
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            asnIn.setBuffer(encodedValue);
            if (v instanceof BBacnetVirtualArray) {
                ((BBacnetVirtualArray)v).readAsn(asnIn, index);
            } else if (v instanceof BIBacnetDataType) {
                BIBacnetDataType obj = (BIBacnetDataType)v;
                obj.readAsn(asnIn);
            } else {
                v = this.readAsn(v, sv, p.getFacets(), encodedValue);
                if (sv != null) {
                    this.set(p, (BValue)sv, noWrite);
                } else {
                    this.set(p, v, noWrite);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMetaData(byte[] encodedValue, Context cx, MetaDataContext meta) throws AsnException {
        PollListEntry ple = (PollListEntry)cx;
        Property p = this.getProperty(meta.getPropertyName());
        BStatus metaStatus = null;
        StringBuilder sb = new StringBuilder();
        if (ple.getObjectId().hashCode() != this.objectId.hashCode()) {
            sb.append(ple.getObjectId().toString(facetsContext)).append('_');
        }
        sb.append(BBacnetPropertyIdentifier.tag(ple.getPropertyId()));
        String propertyName = sb.toString();
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            asnIn.setBuffer(encodedValue);
            metaStatus = this.readAsnMetaData(encodedValue, ple.getObjectId(), ple.getPropertyId(), propertyName);
        }
        this.updateStatus(p, ple, metaStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BValue readAsn(BValue val, BStatusValue sv, BFacets f, byte[] encodedValue) throws AsnException {
        Object v = null;
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            int tag = asnIn.peekApplicationTag();
            switch (tag) {
                case 0: {
                    v = BBacnetNull.DEFAULT;
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 1: {
                    v = BBoolean.make((boolean)asnIn.readBoolean());
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 2: {
                    BBacnetUnsigned u = asnIn.readUnsigned();
                    v = u;
                    if (sv == null) break;
                    sv.setStatusNull(false);
                    if (sv instanceof BStatusEnum) break;
                    sv.setValueValue((BValue)BString.make((String)v.toString()));
                    break;
                }
                case 3: {
                    v = asnIn.readSigned();
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 4: {
                    v = BDouble.make((double)asnIn.readReal());
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 5: {
                    v = BDouble.make((double)asnIn.readDouble());
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 6: {
                    v = BBacnetOctetString.make(asnIn.readOctetString());
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 7: {
                    v = BString.make((String)asnIn.readCharacterString());
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 8: {
                    v = asnIn.readBitString();
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 9: {
                    int en = asnIn.readEnumerated();
                    BEnumRange r = (BEnumRange)f.getFacet("range");
                    if (val instanceof BIEnum && r == null) {
                        r = (BEnumRange)((BIEnum)val).getEnumFacets().getFacet("range");
                    }
                    v = r != null ? r.get(en) : BDynamicEnum.make((int)en);
                    this.setValueValue((BValue)BInteger.make((int)en), sv, r);
                    break;
                }
                case 10: {
                    v = asnIn.readDate();
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 11: {
                    v = asnIn.readTime();
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 12: {
                    v = asnIn.readObjectIdentifier();
                    this.setValueValue((BValue)v, sv, null);
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + ": unexpected tag:" + tag);
                    }
                    BIBacnetDataType obj = (BIBacnetDataType)val;
                    obj.readAsn(asnIn);
                    if (!(obj instanceof BValue)) break;
                    v = (BValue)obj;
                    this.setValueValue((BValue)v, sv, null);
                }
            }
        }
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValueValue(BValue v, BStatusValue sv, BEnumRange r) {
        if (sv == null) {
            return;
        }
        if (v == null || v instanceof BBacnetNull) {
            sv.setStatusNull(true);
            return;
        }
        sv.setStatusNull(false);
        if (sv instanceof BStatusNumeric) {
            if (v instanceof BDouble) {
                sv.setValueValue(v);
                return;
            } else {
                if (!(v instanceof BNumber)) throw new IllegalArgumentException("Can't setValueValue: v=" + v + " [" + v.getType() + "] sv=" + sv + " [baja:StatusNumeric]");
                ((BStatusNumeric)sv).setValue(((BNumber)v).getDouble());
            }
            return;
        } else if (sv instanceof BStatusBoolean) {
            if (v instanceof BBoolean) {
                sv.setValueValue(v);
                return;
            } else {
                if (!(v instanceof BNumber)) throw new IllegalArgumentException("Can't setValueValue: v=" + v + " [" + v.getType() + "] sv=" + sv + " [baja:StatusBoolean]");
                ((BStatusBoolean)sv).setValue(((BNumber)v).getInt() != 0);
            }
            return;
        } else if (sv instanceof BStatusEnum) {
            if (v instanceof BDynamicEnum) {
                sv.setValueValue(v);
                return;
            } else {
                if (!(v instanceof BNumber)) throw new IllegalArgumentException("Can't setValueValue: v=" + v + " [" + v.getType() + "] sv=" + sv + " [baja:StatusEnum]");
                ((BStatusEnum)sv).setValue(BDynamicEnum.make((int)((BNumber)v).getInt(), (BEnumRange)r));
            }
            return;
        } else if (sv instanceof BStatusString) {
            sv.setValueValue((BValue)BString.make((String)v.toString()));
            return;
        } else {
            sv.setValueValue(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BStatus readAsnMetaData(byte[] encodedValue, BBacnetObjectIdentifier objectId, int propertyId, String propertyName) throws AsnException {
        int bits = 0;
        BFacets f = BFacets.NULL;
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            int tag = asnIn.peekApplicationTag();
            switch (tag) {
                case 0: {
                    bits |= 0x40;
                    break;
                }
                case 1: {
                    f = BFacets.make((String)propertyName, (BIDataValue)BBoolean.make((boolean)asnIn.readBoolean()));
                    break;
                }
                case 2: {
                    f = BFacets.make((String)propertyName, (BIDataValue)BLong.make((long)asnIn.readUnsignedInteger()));
                    break;
                }
                case 3: {
                    f = BFacets.make((String)propertyName, (BIDataValue)asnIn.readSigned());
                    break;
                }
                case 4: {
                    f = BFacets.make((String)propertyName, (BIDataValue)asnIn.readFloat());
                    break;
                }
                case 5: {
                    f = BFacets.make((String)propertyName, (BIDataValue)BDouble.make((double)asnIn.readDouble()));
                    break;
                }
                case 6: {
                    f = BFacets.make((String)propertyName, (BIDataValue)BString.make((String)ByteArrayUtil.toHexString((byte[])asnIn.readOctetString())));
                    break;
                }
                case 7: {
                    f = BFacets.make((String)propertyName, (BIDataValue)BString.make((String)asnIn.readCharacterString()));
                    break;
                }
                case 8: {
                    if (propertyId == 111) {
                        bits |= asnIn.readStatusFlags().getBits();
                        break;
                    }
                    f = BFacets.make((String)propertyName, (String)asnIn.readBitString().toString(BacnetBitStringUtil.getBitStringTags(objectId.getObjectType(), propertyId)));
                    break;
                }
                case 9: {
                    f = BFacets.make((String)propertyName, (BIDataValue)BString.make((String)this.device().getEnumRange(objectId.getObjectType(), propertyId).getTag(asnIn.readEnumerated())));
                    break;
                }
                case 10: {
                    f = BFacets.make((String)propertyName, (BIDataValue)BString.make((String)asnIn.readDate().toString()));
                    break;
                }
                case 11: {
                    f = BFacets.make((String)propertyName, (BIDataValue)BString.make((String)asnIn.readTime().toString()));
                    break;
                }
                case 12: {
                    f = BFacets.make((String)propertyName, (BIDataValue)BString.make((String)asnIn.readObjectIdentifier().toString()));
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    f = BFacets.make((String)propertyName, (BIDataValue)BString.make((String)AsnUtil.fromAsn(encodedValue)[0].toString()));
                }
            }
        }
        return BStatus.make((int)bits, (BFacets)f);
    }

    private void updateStatus(Property p, PollListEntry ple, BStatus status) {
        Hashtable<PollListEntry, Object> propMap;
        if (this.propsStatusMap == null) {
            this.propsStatusMap = new Hashtable();
        }
        if ((propMap = this.propsStatusMap.get(p)) == null) {
            propMap = new Hashtable();
            this.propsStatusMap.put(p, propMap);
        }
        propMap.put(ple, status);
        this.updateStatus(p, 0);
    }

    private void updateStatus(Property p, int bits) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("updateStatus(" + p.getName() + ", " + bits + ")");
        }
        if (this.propsStatusMap == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("no propsStatusMap");
            }
            return;
        }
        if (!(this.get(p) instanceof BStatusValue)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("prop not a statusValue");
            }
            return;
        }
        BStatusValue sv = (BStatusValue)this.get(p).newCopy();
        Hashtable<PollListEntry, BStatus> propMap = this.propsStatusMap.get(p);
        if (propMap == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("no propMap for " + p.getName());
            }
            return;
        }
        Enumeration<BStatus> e = propMap.elements();
        BFacets facets = BFacets.NULL;
        while (e.hasMoreElements()) {
            BStatus s = e.nextElement();
            bits |= s.getBits();
            facets = BFacets.make((BFacets)facets, (BFacets)s.getFacets());
        }
        sv.setStatus(BStatus.make((int)bits, (BFacets)facets));
        this.set(p, (BValue)sv, noWrite);
    }

    class Write
    implements Runnable {
        int propertyId;
        int propertyArrayIndex = -1;
        byte[] ev = null;
        int priority = -1;

        Write(int propertyId, int propertyArrayIndex, byte[] ev, int pri) {
            if (propertyId == 87) {
                this.propertyId = 85;
                this.priority = propertyArrayIndex;
            } else {
                this.propertyId = propertyId;
                this.propertyArrayIndex = propertyArrayIndex;
                this.priority = pri;
            }
            this.ev = ev;
        }

        @Override
        public void run() {
            try {
                BBacnetVirtualComponent.this.network().getBacnetComm().writeProperty(BBacnetVirtualComponent.this.device().getAddress(), BBacnetVirtualComponent.this.objectId, this.propertyId, this.propertyArrayIndex, this.ev, this.priority);
            }
            catch (TransactionException e) {
                BBacnetVirtualComponent.this.device().ping();
                log.warning("TransactionException writing " + BBacnetPropertyIdentifier.tag(this.propertyId) + " in " + this);
            }
            catch (BacnetException e) {
                log.log(Level.SEVERE, "BacnetException writing " + BBacnetPropertyIdentifier.tag(this.propertyId) + " in " + this, (Throwable)((Object)e));
            }
        }
    }
}

