/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util;

import javax.baja.bacnet.util.worker.IWorkerPool;
import javax.baja.bacnet.util.worker.IWorkerPoolAware;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxQueueSize", type="int", defaultValue="1000"), @NiagaraProperty(name="workerThreadName", type="String", defaultValue="", flags=3)})
public class BBacnetWorker
extends BWorker
implements IWorkerPoolAware {
    @Generated
    public static final Property maxQueueSize = BBacnetWorker.newProperty((int)0, (int)1000, null);
    @Generated
    public static final Property workerThreadName = BBacnetWorker.newProperty((int)3, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetWorker.class);
    private Object lock = new Object();
    private IWorkerPool workerPool = null;
    protected CoalesceQueue queue;
    protected Worker worker;

    @Generated
    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    @Generated
    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    @Override
    @Generated
    public String getWorkerThreadName() {
        return this.getString(workerThreadName);
    }

    @Generated
    public void setWorkerThreadName(String v) {
        this.setString(workerThreadName, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetWorker() {
    }

    public BBacnetWorker(int queueSize) {
        this.setMaxQueueSize(queueSize);
    }

    public BBacnetWorker(String workerName) {
        this.setWorkerThreadName(workerName);
    }

    public void started() throws Exception {
        if (this.getWorkerThreadName().length() == 0) {
            this.setWorkerThreadName(this.getParent().getName() + ":" + this.getName());
        }
        super.started();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p == maxQueueSize) {
            if (!this.isRunning()) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.workerPool == null) {
                    this.stopWorker();
                    this.queue = null;
                    this.worker = null;
                    this.getWorker();
                    this.startWorker();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(Property property, Context context) {
        super.added(property, context);
        BValue o = null;
        o = this.get(property);
        if (o instanceof IWorkerPool) {
            IWorkerPool pool = (IWorkerPool)o;
            Object object = this.lock;
            synchronized (object) {
                this.workerPool = pool;
                if (this.worker != null && this.worker.isRunning()) {
                    this.worker.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (oldValue instanceof IWorkerPool) {
            Object object = this.lock;
            synchronized (object) {
                this.workerPool = null;
                this.startWorker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWorker() {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker != null && this.worker.isRunning()) {
                this.worker.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture post(Runnable r) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        if (this.queue == null) {
            throw new NotRunningException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.workerPool == null || !this.workerPool.isRunning()) {
                this.queue.enqueue((Object)r);
            } else {
                this.workerPool.post(r);
            }
        }
        return null;
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new CoalesceQueue(this.getMaxQueueSize());
            this.worker = new Worker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        CoalesceQueue coalesceQueue = this.queue;
        synchronized (coalesceQueue) {
            Object[] a = this.queue.toArray();
            System.out.println("BBacnetWorker dump (" + a.length + " entries):");
            for (int i = 0; i < a.length; ++i) {
                System.out.println("" + i + ": " + a[i]);
            }
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasWorkerPool() {
        Object object = this.lock;
        synchronized (object) {
            return this.workerPool != null;
        }
    }
}

