/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.schedule.ScheduleSupport0;
import com.tridium.util.CompUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.export.BBacnetScheduleDescriptor;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Subscriber;

class BacnetSpecialEventsSubscriber
extends Subscriber {
    private static final BComponentEventMask SPECIAL_EVENTS_MASK = BComponentEventMask.make((int[])new int[]{2, 4});
    private static final Logger logger = Logger.getLogger("bacnet.server");
    private final Map<BCompositeSchedule, BBacnetScheduleDescriptor> descriptorMap = new HashMap<BCompositeSchedule, BBacnetScheduleDescriptor>();

    public BacnetSpecialEventsSubscriber() {
        this.setMask(SPECIAL_EVENTS_MASK);
    }

    public void subscribe(BBacnetScheduleDescriptor descriptor, BCompositeSchedule specialEvents) {
        this.descriptorMap.put(specialEvents, descriptor);
        super.subscribe((BComponent)specialEvents);
    }

    public void unsubscribe(BCompositeSchedule specialEvents) {
        if (specialEvents == null) {
            return;
        }
        this.descriptorMap.remove(specialEvents);
        super.unsubscribe((BComponent)specialEvents);
    }

    public void event(BComponentEvent event) {
        BCompositeSchedule specialEvents = (BCompositeSchedule)event.getSourceComponent();
        BWeeklySchedule schedule = this.getParentWeeklySchedule(specialEvents);
        BBacnetScheduleDescriptor descriptor = this.descriptorMap.get(specialEvents);
        if (descriptor == null) {
            logger.info("Error handling event from schedule's special events: no schedule descriptor found; schedule: " + schedule.getSlotPath());
            this.unsubscribe(specialEvents);
            return;
        }
        try {
            switch (event.getId()) {
                case 2: 
                case 4: {
                    if (descriptor.isRemoteChange.get().booleanValue()) break;
                    BDailySchedule[] events = (BDailySchedule[])specialEvents.getChildren(BDailySchedule.class);
                    for (int i = 0; i < events.length; ++i) {
                        CompUtil.setOrAdd((BComponent)events[i], (String)"priority", (BValue)ScheduleSupport0.PRIORITY_16, (int)0x10000000, null, null);
                        CompUtil.setOrAdd((BComponent)events[i], (String)"bacnetIdx", (BValue)BInteger.make((int)(i + 1)), (int)0x10000000, null, null);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error handling event from schedule's special events; descriptor: " + descriptor + ", schedule: " + schedule.getSlotPath() + ", exception: " + e, logger.isLoggable(Level.FINE) ? e : null);
        }
    }

    private BWeeklySchedule getParentWeeklySchedule(BCompositeSchedule specialEvents) {
        BCompositeSchedule parent = (BCompositeSchedule)specialEvents.getParent();
        return (BWeeklySchedule)parent.getParent();
    }
}

