/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.stack.client.AsyncEventNotificationRequest;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BIAgent;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BBacnetScheduleDescriptor;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BInterface;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
public interface BIBacnetExportObject
extends BInterface,
BIAgent,
BacnetConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BIBacnetExportObject.class);

    public BComplex getParent();

    public BObject getObject();

    public BOrd getObjectOrd();

    public void setObjectOrd(BOrd var1, Context var2);

    public BStatus getStatus();

    public boolean isFatalFault();

    public void checkConfiguration();

    public BBacnetObjectIdentifier getObjectId();

    public void setObjectId(BBacnetObjectIdentifier var1);

    public String getObjectName();

    public void setObjectName(String var1);

    public int[] getPropertyList();

    public PropertyValue readProperty(PropertyReference var1) throws RejectException;

    public PropertyValue[] readPropertyMultiple(PropertyReference[] var1) throws RejectException;

    public RangeData readRange(RangeReference var1) throws RejectException;

    public ErrorType writeProperty(PropertyValue var1) throws BacnetException;

    public ChangeListError addListElements(PropertyValue var1) throws BacnetException;

    public ChangeListError removeListElements(PropertyValue var1) throws BacnetException;

    default public void setTransportLayer(BBacnetTransportLayer transportLayer) {
    }

    default public boolean isDynamicallyCreated() {
        return false;
    }

    public static class ObjectSubscriber
    extends Subscriber {
        private static final BComponentEventMask EVENT_MASK = BComponentEventMask.make((int[])new int[]{0, 5, 9, 8, 13, 20});
        private HashMap<BComponent, BIBacnetExportObject> sublist = new HashMap();
        private static final Logger logger = Logger.getLogger("bacnet.server");

        public ObjectSubscriber() {
            this.setMask(EVENT_MASK);
        }

        public void subscribe(BIBacnetExportObject export, BComponent src) {
            this.sublist.put(src, export);
            super.subscribe(src);
        }

        public void unsubscribe(BIBacnetExportObject export, BComponent src) {
            if (src == null) {
                return;
            }
            this.sublist.remove(src);
            super.unsubscribe(src);
        }

        public void event(BComponentEvent event) {
            block17: {
                BComponent src = event.getSourceComponent();
                BIBacnetExportObject export = this.sublist.get(src);
                if (export == null) {
                    logger.info("ObjectSubscriber: event from unknown source:" + src);
                    this.sublist.remove(src);
                    return;
                }
                try {
                    switch (event.getId()) {
                        case 13: {
                            String oldOrd = src.getSlotPath().getParent().getBody().substring(1);
                            oldOrd = oldOrd + "/" + event.getValue().toString();
                            if (export.getObjectName().equals(oldOrd)) {
                                export.setObjectName(((BComponent)export.getObject()).getSlotPath().getBody().substring(1));
                            }
                            if (!export.getObjectOrd().toString().endsWith(oldOrd)) break;
                            export.setObjectOrd(BOrd.make((String)("station:|" + event.getSourceComponent().getSlotPath().toString())), null);
                            break;
                        }
                        case 20: {
                            BObject object = export.getObject();
                            if (object == export) break;
                            ((BComponent)export.getParent()).remove((BComplex)((BComponent)export));
                            break;
                        }
                        case 8: 
                        case 9: {
                            if (!(export instanceof BBacnetNotificationClassDescriptor)) break;
                            ((BBacnetNotificationClassDescriptor)export).recipientListChanged();
                            break;
                        }
                        case 5: {
                            if (!(export instanceof BBacnetNotificationClassDescriptor)) break;
                            Topic topic = (Topic)event.getSlot();
                            if (topic.equals(BAlarmClass.alarm)) {
                                AsyncEventNotificationRequest.removeAckTimestamp((BAlarmRecord)event.getValue());
                            }
                            break;
                        }
                        case 0: {
                            if (export instanceof BBacnetScheduleDescriptor && src == ((BBacnetScheduleDescriptor)export).getSchedule()) {
                                if (event.getSlotName().equals("out")) {
                                    ((BBacnetScheduleDescriptor)export).writePresentValue();
                                } else if (event.getSlotName().equals("lastModified")) {
                                    export.checkConfiguration();
                                }
                            }
                            if (!(export instanceof BBacnetEventSource)) break;
                            Slot s = event.getSlot();
                            String sn = event.getSlotName();
                            if (s.equals((Object)BControlPoint.facets)) {
                                export.checkConfiguration();
                                break;
                            }
                            if (!sn.equals("out")) break;
                            BBacnetEventSource eventSource = (BBacnetEventSource)export;
                            eventSource.checkValid();
                            eventSource.statusChanged();
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block17;
                    logger.log(Level.FINE, "Error in BACnet ObjectSubscriber:export=" + export + "; src=" + src, e);
                }
            }
        }
    }
}

