/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.stack.server.BBacnetExportFolder;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.BOverrideMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BBacnetTrendLogDescriptor;
import javax.baja.bacnet.export.BIBacnetCovSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.export.BReliabilityAlarmSourceExt;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.export.BacnetPropertyListProvider;
import javax.baja.bacnet.export.Cov;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BLink;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pointOrd", type="BOrd", defaultValue="BOrd.DEFAULT", flags=64, facets={@Facet(name="BFacets.TARGET_TYPE", value="\"baja:Component\"")}), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.DEFAULT", flags=64), @NiagaraProperty(name="objectName", type="String", defaultValue="", flags=64), @NiagaraProperty(name="reliability", type="BEnum", defaultValue="BBacnetReliability.noFaultDetected", flags=3), @NiagaraProperty(name="outOfService", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="description", type="String", defaultValue=""), @NiagaraProperty(name="notifyType", type="BBacnetNotifyType", defaultValue="BBacnetNotifyType.alarm", facets={@Facet(value="BacUtil.makeBacnetNotifyTypeFacets()")})})
@NiagaraActions(value={@NiagaraAction(name="addCovSubscription", parameterType="BBacnetCovSubscription", defaultValue="new BBacnetCovSubscription()", flags=4), @NiagaraAction(name="removeCovSubscription", parameterType="BBacnetCovSubscription", defaultValue="new BBacnetCovSubscription()", flags=4), @NiagaraAction(name="makeWritable", parameterType="BValue", defaultValue="BString.DEFAULT", flags=4), @NiagaraAction(name="sendCovNotification", parameterType="BBacnetCovSubscription", defaultValue="new BBacnetCovSubscription()", flags=4), @NiagaraAction(name="checkCov", flags=20)})
public abstract class BBacnetPointDescriptor
extends BBacnetEventSource
implements BIBacnetCovSource,
BacnetPropertyListProvider {
    @Generated
    public static final Property pointOrd = BBacnetPointDescriptor.newProperty((int)64, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"baja:Component"));
    @Generated
    public static final Property objectId = BBacnetPointDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    @Generated
    public static final Property objectName = BBacnetPointDescriptor.newProperty((int)64, (String)"", null);
    @Generated
    public static final Property reliability = BBacnetPointDescriptor.newProperty((int)3, (BValue)BBacnetReliability.noFaultDetected, null);
    @Generated
    public static final Property outOfService = BBacnetPointDescriptor.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property description = BBacnetPointDescriptor.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property notifyType = BBacnetPointDescriptor.newProperty((int)0, (BValue)BBacnetNotifyType.alarm, (BFacets)BacUtil.makeBacnetNotifyTypeFacets());
    @Generated
    public static final Action addCovSubscription = BBacnetPointDescriptor.newAction((int)4, (BValue)new BBacnetCovSubscription(), null);
    @Generated
    public static final Action removeCovSubscription = BBacnetPointDescriptor.newAction((int)4, (BValue)new BBacnetCovSubscription(), null);
    @Generated
    public static final Action makeWritable = BBacnetPointDescriptor.newAction((int)4, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action sendCovNotification = BBacnetPointDescriptor.newAction((int)4, (BValue)new BBacnetCovSubscription(), null);
    @Generated
    public static final Action checkCov = BBacnetPointDescriptor.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetPointDescriptor.class);
    private static final int[] ARRAY_PROPS = new int[]{130, 351, 352, 371, 87, 110};
    private BControlPoint point;
    private int[] requiredProps;
    private int[] optionalProps;
    private int lastStatusBits = -1;
    private int oldNotifyType;
    private BBacnetObjectIdentifier oldId = null;
    private String oldName = null;
    private boolean duplicate = false;
    protected final AtomicBoolean configOk = new AtomicBoolean();
    private OrdStatus ordStatus = OrdStatus.OK;
    static final AsnInputStream asnIn = new AsnInputStream();
    static final AsnOutputStream asnOut = new AsnOutputStream();
    static Logger log = Logger.getLogger("bacnet.server");
    static Lexicon lex = Lexicon.make((String)"bacnet");
    static String lexNotWritable = lex.getText("server.notWritable");

    @Generated
    public BOrd getPointOrd() {
        return (BOrd)this.get(pointOrd);
    }

    @Generated
    public void setPointOrd(BOrd v) {
        this.set(pointOrd, (BValue)v, null);
    }

    @Override
    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Override
    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Override
    @Generated
    public String getObjectName() {
        return this.getString(objectName);
    }

    @Override
    @Generated
    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    @Generated
    public BEnum getReliability() {
        return (BEnum)this.get(reliability);
    }

    @Generated
    public void setReliability(BEnum v) {
        this.set(reliability, (BValue)v, null);
    }

    @Generated
    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    @Generated
    public void setOutOfService(boolean v) {
        this.setBoolean(outOfService, v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Override
    @Generated
    public BBacnetNotifyType getNotifyType() {
        return (BBacnetNotifyType)this.get(notifyType);
    }

    @Generated
    public void setNotifyType(BBacnetNotifyType v) {
        this.set(notifyType, (BValue)v, null);
    }

    @Override
    @Generated
    public void addCovSubscription(BBacnetCovSubscription parameter) {
        this.invoke(addCovSubscription, (BValue)parameter, null);
    }

    @Override
    @Generated
    public void removeCovSubscription(BBacnetCovSubscription parameter) {
        this.invoke(removeCovSubscription, (BValue)parameter, null);
    }

    @Generated
    public void makeWritable(BValue parameter) {
        this.invoke(makeWritable, parameter, null);
    }

    @Generated
    public void sendCovNotification(BBacnetCovSubscription parameter) {
        this.invoke(sendCovNotification, (BValue)parameter, null);
    }

    @Override
    @Generated
    public void checkCov() {
        this.invoke(checkCov, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        this.reliabilityChanged();
        if (Sys.isStationStarted()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        local.unexport(this.oldId, this.oldName, this);
        this.clearTrendReferences(local);
        if (this.getOosExt() != null) {
            this.removeOutOfServiceExt();
        }
        local.unsubscribe(this, this.point);
        this.requiredProps = null;
        this.optionalProps = null;
        this.point = null;
        this.oldId = null;
        this.oldName = null;
        if (local.isRunning()) {
            local.incrementDatabaseRevision();
        }
    }

    public final void added(Property p, Context cx) {
        super.added(p, cx);
        if (!this.isRunning()) {
            return;
        }
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(objectId)) {
            BLocalBacnetDevice local = BBacnetNetwork.localDevice();
            local.unexport(this.oldId, this.oldName, this);
            this.clearTrendReferences(local);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {
                // empty catch block
            }
            if (this.configOk.get()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(objectName)) {
            BLocalBacnetDevice local = BBacnetNetwork.localDevice();
            local.unexport(this.oldId, this.oldName, this);
            this.clearTrendReferences(local);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.configOk.get()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(pointOrd)) {
            this.ordStatus = OrdStatus.CHANGED;
            this.checkConfiguration();
            if (this.configOk.get()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(notifyType)) {
            if (this.getNotifyType() == BBacnetNotifyType.ackNotification) {
                log.warning("Invalid Notify Type for " + this);
                this.setNotifyType(BBacnetNotifyType.make(this.oldNotifyType));
            } else {
                this.oldNotifyType = this.getNotifyType().getOrdinal();
            }
        } else if (p.equals(description)) {
            BBacnetExportFolder f = this.getSvo();
            if (f != null) {
                f.fireSubordinateAnnotationChanged(null);
            }
        } else if (p.equals(reliability)) {
            this.reliabilityChanged();
        }
    }

    @Override
    protected void updateAlarmInhibit(boolean eventDetectionEnable) {
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt != null) {
            if (!eventDetectionEnable) {
                BBacnetPointDescriptor.setAlarmInhibit(alarmExt, true);
            } else {
                boolean hasActiveLink = false;
                for (BLink link : BBacnetPointDescriptor.getAlarmInhibitLinks(alarmExt)) {
                    if (!link.isActive() || !link.isEnabled()) continue;
                    hasActiveLink = true;
                    link.propagatePropertyToProperty();
                }
                if (!hasActiveLink) {
                    BBacnetPointDescriptor.setAlarmInhibit(alarmExt, false);
                }
            }
        }
    }

    @Override
    public void statusChanged() {
        BStatus status = this.getStatusFlags();
        if (this.lastStatusBits == status.getBits()) {
            return;
        }
        this.lastStatusBits = status.getBits();
        this.setBacnetStatusFlags(BBacnetBitString.make(status.isAlarm(), status.isFault(), status.isOverridden(), status.isDisabled()));
        this.validate();
    }

    protected void reliabilityChanged() {
        BControlPoint point = this.getPoint(false);
        if (null != point) {
            for (BReliabilityAlarmSourceExt fault : (BReliabilityAlarmSourceExt[])point.getChildren(BReliabilityAlarmSourceExt.class)) {
                fault.reliabilityChanged((BBacnetReliability)this.getReliability());
            }
        }
    }

    public void clockChanged(BRelTime shift) throws Exception {
        SlotCursor sc = this.getProperties();
        while (sc.next(BBacnetCovSubscription.class)) {
            BBacnetCovSubscription covSub = (BBacnetCovSubscription)sc.get();
            covSub.setSubscriptionEndTime(covSub.getSubscriptionEndTime().add(shift));
        }
    }

    public final void doAddCovSubscription(BBacnetCovSubscription sub) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding Cov subscription: " + sub + " on " + this);
        }
        Property p = this.add("covSubscription?", (BValue)sub, 3);
        BBacnetNetwork.localDevice().subscribeCov(this, (BComponent)this.getPoint(), p);
    }

    public final void doRemoveCovSubscription(BBacnetCovSubscription sub) {
        Clock.Ticket ticket;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Removing Cov subscription: " + sub + " on " + this);
        }
        if ((ticket = sub.getTicket()) != null) {
            ticket.cancel();
        }
        sub.setTicket(null);
        Property p = this.getProperty(sub.getName());
        if (p != null) {
            this.remove(p);
        }
        BBacnetNetwork.localDevice().unsubscribeCov(this, (BComponent)this.getPoint(), p);
    }

    public void doMakeWritable(BValue v) {
    }

    public void doSendCovNotification(BBacnetCovSubscription covSub) {
        BControlPoint pt = this.getPoint();
        if (covSub.getTimeRemaining() < 0) {
            this.removeCovSubscription(covSub);
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Sending Cov Notification on " + this + ": pt=" + pt + "\n  covSub=" + covSub);
        }
        Cov cov = new Cov(covSub, this, pt);
        BBacnetNetwork.bacnet().getCovWorker().sendCov(cov);
    }

    public final void doCheckCov() {
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetCovSubscription.class)) {
            BBacnetCovSubscription covSub = (BBacnetCovSubscription)c.get();
            boolean send = false;
            if (covSub.isCovProperty()) {
                send = this.checkCovProperty(covSub);
            } else {
                BStatusValue currentValue = this.getCurrentStatusValue();
                if (this.checkCov(currentValue, covSub.getLastValue())) {
                    covSub.setLastValue(currentValue);
                    send = true;
                }
            }
            if (!send) continue;
            this.sendCovNotification(covSub);
        }
    }

    public final boolean checkCovProperty(BBacnetCovSubscription covSub) {
        boolean send = false;
        try {
            BStatus sf;
            PropertyValue pv;
            block15: {
                byte[] newAsnPropValue;
                block13: {
                    double diff;
                    BINumeric newValue;
                    BValue cv;
                    block14: {
                        double d;
                        pv = this.readProperty(covSub.getMonitoredPropertyReference().getPropertyId(), covSub.getMonitoredPropertyReference().getPropertyArrayIndex());
                        PropertyInfo pi = BBacnetNetwork.localDevice().getPropertyInfo(this.getObjectId().getObjectType(), covSub.getMonitoredPropertyReference().getPropertyId());
                        newAsnPropValue = pv.getPropertyValue();
                        sf = this.getStatusFlags();
                        int cs = sf.getBits() & 0x2B;
                        int lsb = covSub.getLastStatusBits();
                        if (cs != lsb) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Status flags changed from: " + lsb + " to: " + cs);
                            }
                            send = true;
                        }
                        if (pi.getAsnType() != 4 && pi.getAsnType() != 5) break block13;
                        cv = AsnUtil.asnToValue(pi, newAsnPropValue);
                        newValue = (BINumeric)cv;
                        BINumeric lastNumeric = (BINumeric)covSub.getLastPropValue();
                        double covIncrement = this.getCovIncrement(covSub);
                        diff = 0.0;
                        if (lastNumeric == null) break block14;
                        diff = Math.abs(newValue.getNumeric() - lastNumeric.getNumeric());
                        if (!(d >= covIncrement)) break block15;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("NumericCOV changed by more than diff: " + diff + " to: " + newValue.getNumeric());
                    }
                    covSub.setLastPropValue(cv);
                    send = true;
                    break block15;
                }
                PropertyValue lv = covSub.getLastPropertyValue();
                if (lv == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("No previous notifications");
                    }
                    send = true;
                } else if (!Arrays.equals(lv.getPropertyValue(), newAsnPropValue)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("asn.1 encoded byte[] changed, send it!");
                    }
                    send = true;
                }
            }
            if (send) {
                covSub.setLastPropertyValue(pv);
                covSub.setLastStatusFlags(sf);
            }
        }
        catch (AsnException e) {
            log.log(Level.SEVERE, "AsnException occurred in checkCovProperty", (Throwable)((Object)e));
        }
        return send;
    }

    private double getCovIncrement(BBacnetCovSubscription covSub) {
        double covIncrement = covSub.getCovIncrement();
        if (Double.isNaN(covIncrement)) {
            BNumber d;
            covIncrement = covSub.getMonitoredPropertyReference().getPropertyId() == 85 ? ((d = (BNumber)this.get("covIncrement")) != null ? d.getDouble() : 0.0) : 0.0;
        }
        return covIncrement;
    }

    @Override
    public final BObject getObject() {
        return this.getPoint();
    }

    @Override
    public final BOrd getObjectOrd() {
        return this.getPointOrd();
    }

    @Override
    public final void setObjectOrd(BOrd objectOrd, Context cx) {
        this.set(pointOrd, (BValue)objectOrd, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void checkConfiguration() {
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.configOk.set(false);
            return;
        }
        local.unsubscribe(this, this.point);
        this.findPoint();
        boolean cfgOk = true;
        if (this.point == null) {
            this.setFaultCause("Cannot find exported point");
            cfgOk = false;
        } else {
            BControlPoint bControlPoint = this.point;
            synchronized (bControlPoint) {
                if (!this.getObjectId().isValid()) {
                    this.setFaultCause("Invalid Object ID");
                    cfgOk = false;
                }
                if (cfgOk &= this.checkPointConfiguration()) {
                    String err = local.export(this);
                    if (err != null) {
                        this.duplicate = true;
                        this.setFaultCause(err);
                        cfgOk = false;
                    } else {
                        this.duplicate = false;
                        this.updateTrendReferences(local, this.point);
                    }
                }
            }
            local.subscribe(this, this.point);
        }
        this.configOk.set(cfgOk);
        if (cfgOk) {
            this.validate();
        } else {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
    }

    @Override
    public final boolean isEventInitiationEnabled() {
        return this.getNotificationClass() != null;
    }

    @Override
    public final BEnum getEventState() {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        return BBacnetEventState.make(almExt.getAlarmState());
    }

    @Override
    public final BBacnetBitString getAckedTransitions() {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        BAlarmTransitionBits ackedTrans = this.readEventTransition(almExt.getAckedTransitions());
        return BacnetBitStringUtil.getBacnetEventTransitionBits(ackedTrans);
    }

    @Override
    public final BBacnetTimeStamp[] getEventTimeStamps() {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        BBacnetTimeStamp[] ets = new BBacnetTimeStamp[3];
        BAbsTime t = almExt.getLastOffnormalTime();
        ets[0] = BAbsTime.DEFAULT.equals((Object)t) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(t);
        t = almExt.getLastFaultTime();
        ets[1] = BAbsTime.DEFAULT.equals((Object)t) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(t);
        t = almExt.getLastToNormalTime();
        ets[2] = BAbsTime.DEFAULT.equals((Object)t) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(t);
        return ets;
    }

    @Override
    public final BBacnetBitString getEventEnable() {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(almExt.getAlarmEnable());
    }

    @Override
    public final int[] getEventPriorities() {
        BBacnetNotificationClassDescriptor nc = this.getNotificationClass();
        if (nc == null) {
            return null;
        }
        return nc.getEventPriorities();
    }

    @Override
    public final BBacnetNotificationClassDescriptor getNotificationClass() {
        BBacnetNotificationClassDescriptor nc = null;
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        try {
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmClass ac = as.lookupAlarmClass(almExt.getAlarmClass());
            BBacnetObjectIdentifier ncId = BBacnetNetwork.localDevice().lookupBacnetObjectId(ac.getHandleOrd());
            if (ncId != null) {
                nc = (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(ncId);
                if (nc == null) {
                    log.warning("Can't find Notification Class Descriptor for ID " + (Object)((Object)ncId));
                }
            } else {
                log.warning("Alarm Class '" + ac + "' is used for BACnet-exposed object " + this + ", but is not exposed as a BACnet Notification Class");
            }
        }
        catch (ServiceNotFoundException e) {
            log.log(Level.SEVERE, "getNotificationClass on " + this + ": Unable to find alarm service", e);
        }
        return nc;
    }

    @Override
    public abstract BEnum getEventType();

    @Override
    public BIBacnetExportObject getExport() {
        return this;
    }

    @Override
    public final BBacnetCovSubscription findCovSubscription(BBacnetAddress subscriberAddress, long processId, BBacnetObjectIdentifier objectId) {
        return this.findSubscription(false, subscriberAddress, processId, objectId, 85, -1);
    }

    @Override
    public final BBacnetCovSubscription findCovPropertySubscription(BBacnetAddress subscriberAddress, long processId, BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) {
        return this.findSubscription(true, subscriberAddress, processId, objectId, propertyId, -1);
    }

    @Override
    public final void startCovTimer(BBacnetCovSubscription covSub, long lifetime) {
        Clock.Ticket ticket = covSub.getTicket();
        if (ticket != null) {
            ticket.cancel();
        }
        if (lifetime > 0L) {
            BRelTime subLife = BRelTime.make((long)((long)((int)lifetime) * 1000L));
            covSub.setSubscriptionEndTime(BAbsTime.make().add(subLife));
            covSub.setTicket(Clock.schedule((BComponent)this, (BRelTime)subLife, (Action)removeCovSubscription, (BValue)covSub));
        }
        this.sendCovNotification(covSub);
    }

    @Override
    public Property getOutProperty() {
        BControlPoint point = this.getPoint();
        return point != null ? point.getOutProperty() : null;
    }

    @Override
    public boolean supportsSubscribeCov() {
        return true;
    }

    @Override
    public BValue getCurrentCovValue(BBacnetCovSubscription sub) {
        PropertyValue pv = this.readProperty(sub.getMonitoredPropertyReference().getPropertyId(), sub.getMonitoredPropertyReference().getPropertyArrayIndex());
        try {
            return AsnUtil.asnToValue(BBacnetNetwork.localDevice().getPropertyInfo(this.getObjectId().getObjectType(), sub.getMonitoredPropertyReference().getPropertyId()), pv.getPropertyValue());
        }
        catch (AsnException e) {
            log.log(Level.SEVERE, "AsnException occurred in getCurrentCovValue", (Throwable)((Object)e));
            return null;
        }
    }

    abstract BStatusValue getCurrentStatusValue();

    boolean checkCov(BStatusValue currentValue, BStatusValue covValue) {
        return !currentValue.equals((Object)covValue);
    }

    @Override
    public final PropertyValue readProperty(PropertyReference ref) throws RejectException {
        this.getPoint();
        return this.readProperty(ref.getPropertyId(), ref.getPropertyArrayIndex());
    }

    @Override
    public final PropertyValue[] readPropertyMultiple(PropertyReference[] refs) throws RejectException {
        this.getPoint();
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>(refs.length);
        block5: for (int i = 0; i < refs.length; ++i) {
            switch (refs[i].getPropertyId()) {
                case 8: {
                    int j;
                    int[] props = this.getRequiredProps();
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    props = this.getOptionalProps();
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 80: {
                    int j;
                    int[] props = this.getOptionalProps();
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 105: {
                    int j;
                    int[] props = this.getRequiredProps();
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                default: {
                    results.add(this.readProperty(refs[i].getPropertyId(), refs[i].getPropertyArrayIndex()));
                }
            }
        }
        return results.toArray(new PropertyValue[0]);
    }

    @Override
    public RangeData readRange(RangeReference rangeReference) throws RejectException {
        this.getPoint();
        int propertyId = rangeReference.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
    }

    @Override
    public final ErrorType writeProperty(PropertyValue val) throws BacnetException {
        this.getPoint();
        return this.writeProperty(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue(), val.getPriority());
    }

    @Override
    public ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        this.getPoint();
        int propertyId = propertyValue.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
    }

    @Override
    public ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        this.getPoint();
        int propertyId = propertyValue.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
    }

    boolean isArray(int propertyId) {
        for (int i = 0; i < ARRAY_PROPS.length; ++i) {
            if (propertyId != ARRAY_PROPS[i]) continue;
            return true;
        }
        return false;
    }

    protected PropertyValue readProperty(int pId, int ndx) {
        if (this.point == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0) {
            if (!this.isArray(pId)) {
                return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
            }
        } else if (ndx < -1) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 42));
        }
        switch (pId) {
            case 75: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 371: {
                return this.readPropertyList(ndx);
            }
            case 28: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
            case 111: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.statusToAsnStatusFlags(this.getStatusFlags()));
            }
            case 36: {
                return this.readEventState();
            }
            case 103: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(this.getReliability()));
            }
            case 81: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.getOosExt().getOutOfService()));
            }
        }
        return this.readOptionalProperty(pId, ndx);
    }

    private PropertyValue readEventState() {
        if (!this.getEventDetectionEnable()) {
            return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(0));
        }
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt == null) {
            return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(0));
        }
        return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(BBacnetEventState.fromBAlarmState(alarmExt.getAlarmState())));
    }

    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            switch (pId) {
                case 17: {
                    BBacnetNotificationClassDescriptor nc = this.getNotificationClass();
                    if (nc == null) {
                        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
                    }
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(nc.getNotificationClass()));
                }
                case 35: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(almExt.getAlarmEnable())));
                }
                case 353: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.getEventDetectionEnable()));
                }
                case 0: {
                    return this.readAckedTransitions(almExt.getAckedTransitions());
                }
                case 72: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated((BEnum)this.getNotifyType()));
                }
                case 130: {
                    return this.readEventTimeStamps(almExt.getLastOffnormalTime(), almExt.getLastFaultTime(), almExt.getLastToNormalTime(), ndx);
                }
                case 351: {
                    return this.readEventMessageTexts(ndx);
                }
                case 352: {
                    return this.readEventMessageTextsConfig(almExt.getToOffnormalText().getFormat(), almExt.getToFaultText().getFormat(), almExt.getToNormalText().getFormat(), ndx);
                }
                case 113: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(almExt.getTimeDelay().getSeconds()));
                }
                case 355: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsn(-4, (BValue)this.getEventAlgorithmInhibitRef(almExt)));
                }
                case 354: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(almExt.getAlarmInhibit().getBoolean()));
                }
                case 356: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(almExt.getTimeDelayToNormal().getSeconds()));
                }
            }
        }
        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
    }

    private NReadPropertyResult readAckedTransitions(BAlarmTransitionBits ackedTrans) {
        if (this.getEventDetectionEnable()) {
            BAlarmTransitionBits eventTrans = this.readEventTransition(ackedTrans);
            return new NReadPropertyResult(0, -1, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(eventTrans)));
        }
        return new NReadPropertyResult(0, -1, AsnUtil.toAsnBitString(ACKED_TRANS_DEFAULT));
    }

    protected final PropertyValue readInterfaceValue() {
        BAbstractProxyExt abstractProxyExt = this.point.getProxyExt();
        if (abstractProxyExt instanceof BNullProxyExt) {
            return BBacnetPointDescriptor.makeInterfaceValueResult(AsnUtil.toAsnNull());
        }
        BProxyExt proxyExt = (BProxyExt)abstractProxyExt;
        BStatusValue deviceValue = proxyExt.getReadValue();
        BStatus status = BStatus.make((int)(proxyExt.getStatus().getBits() | deviceValue.getStatus().getBits()));
        if (!status.isValid()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": Returning null for interface-value property because proxy/device value status is " + status);
            }
            return BBacnetPointDescriptor.makeInterfaceValueResult(AsnUtil.toAsnNull());
        }
        try {
            BStatusValue proxyValue = (BStatusValue)deviceValue.newCopy(true);
            proxyExt.getConversion().convertDeviceToProxy(proxyExt, deviceValue, proxyValue);
            byte[] interfaceValue = this.makeInterfaceValue(proxyValue);
            return BBacnetPointDescriptor.makeInterfaceValueResult(interfaceValue);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, (Object)((Object)this.getObjectId()) + ": Failed to convert device value to proxy value when reading interface-value property", e);
            }
            return BBacnetPointDescriptor.makeInterfaceValueResult(AsnUtil.toAsnNull());
        }
    }

    private static PropertyValue makeInterfaceValueResult(byte[] value) {
        return new NReadPropertyResult(387, -1, value);
    }

    protected abstract byte[] makeInterfaceValue(BStatusValue var1);

    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        if (this.point == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0) {
            if (!this.isArray(pId)) {
                return new NErrorType(2, 50);
            }
        } else if (ndx < -1) {
            return new NErrorType(2, 42);
        }
        try {
            switch (pId) {
                case 36: 
                case 75: 
                case 77: 
                case 79: 
                case 103: 
                case 111: 
                case 371: {
                    return new NErrorType(2, 40);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 81: {
                    this.getOosExt().setBoolean(BOutOfServiceExt.outOfService, AsnUtil.fromOnlyAsnBoolean(val), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return this.writeOptionalProperty(pId, ndx, val, pri);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        try {
            BAlarmSourceExt almExt = this.getAlarmExt();
            if (almExt != null) {
                switch (pId) {
                    case 17: {
                        int ncinst = AsnUtil.fromAsnUnsignedInt(val);
                        if (ncinst > 0x3FFFFE) {
                            return new NErrorType(2, 37);
                        }
                        BBacnetObjectIdentifier ncid = BBacnetObjectIdentifier.make(15, ncinst);
                        BBacnetNotificationClassDescriptor nc = (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(ncid);
                        if (nc == null) {
                            return new NErrorType(2, 37);
                        }
                        BAlarmClass ac = nc.getAlarmClass();
                        almExt.setString(BAlarmSourceExt.alarmClass, ac.getName(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 35: {
                        return new NErrorType(2, 40);
                    }
                    case 0: {
                        return new NErrorType(2, 40);
                    }
                    case 72: {
                        this.set(notifyType, (BValue)BBacnetNotifyType.make(AsnUtil.fromAsnEnumerated(val)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 130: 
                    case 351: {
                        return new NErrorType(2, 40);
                    }
                    case 352: {
                        return BBacnetPointDescriptor.writeEventMessageTextsConfig(ndx, val, almExt);
                    }
                    case 353: {
                        this.setBoolean(eventDetectionEnable, AsnUtil.fromAsnBoolean(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 113: {
                        almExt.set(BAlarmSourceExt.timeDelay, (BValue)BRelTime.makeSeconds((int)((int)AsnUtil.fromAsnUnsignedInteger(val))), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 355: {
                        return this.writeEventAlgorithmInhibitRef(val, almExt);
                    }
                    case 354: {
                        return this.writeEventAlgorithmInhibit(val, almExt);
                    }
                    case 356: {
                        almExt.set(BAlarmSourceExt.timeDelayToNormal, (BValue)BRelTime.makeSeconds((int)AsnUtil.fromAsnUnsignedInt(val)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
            }
        }
        catch (IllegalArgumentException | OutOfRangeException e) {
            log.warning("OutOfRangeException | IllegalArgumentException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + e);
            return new NErrorType(2, 37);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        return new NErrorType(2, 32);
    }

    public int[] getRequiredProps() {
        if (this.requiredProps == null) {
            Vector<BBacnetPropertyIdentifier> v = new Vector<BBacnetPropertyIdentifier>();
            v.add(BBacnetPropertyIdentifier.objectIdentifier);
            v.add(BBacnetPropertyIdentifier.objectName);
            v.add(BBacnetPropertyIdentifier.objectType);
            this.addRequiredProps(v);
            this.requiredProps = new int[v.size()];
            for (int i = 0; i < this.requiredProps.length; ++i) {
                this.requiredProps[i] = ((BEnum)v.elementAt(i)).getOrdinal();
            }
        }
        return this.requiredProps;
    }

    public int[] getOptionalProps() {
        Vector v = new Vector();
        this.addOptionalProps(v);
        this.optionalProps = new int[v.size()];
        for (int i = 0; i < this.optionalProps.length; ++i) {
            this.optionalProps[i] = ((BEnum)v.elementAt(i)).getOrdinal();
        }
        return this.optionalProps;
    }

    @Override
    public int[] getPropertyList() {
        return BacnetPropertyList.makePropertyList(this.getRequiredProps(), this.getOptionalProps());
    }

    protected boolean hasProperty(int propertyId) {
        for (int id : this.getRequiredProps()) {
            if (id != propertyId) continue;
            return true;
        }
        for (int id : this.getOptionalProps()) {
            if (id != propertyId) continue;
            return true;
        }
        return propertyId == 371;
    }

    protected void addRequiredProps(Vector v) {
    }

    protected void addOptionalProps(Vector v) {
    }

    protected boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BControlPoint;
    }

    BStatus getStatusFlags() {
        BAlarmSourceExt alarmExt;
        BControlPoint point = this.getPoint();
        if (point == null) {
            return BStatus.ok;
        }
        int status = 0;
        BStatus pointStatus = point.getStatus();
        if (this.getEventDetectionEnable() && (alarmExt = this.getAlarmExt()) != null && alarmExt.getAlarmState().isInAlarm()) {
            status |= 8;
        }
        if (this.getReliability() != BBacnetReliability.noFaultDetected) {
            status |= 2;
        }
        if (pointStatus.isOverridden()) {
            BBacnetServerLayer serverLayer = BBacnetServerLayer.getServerLayer();
            BOverrideMode overrideMode = serverLayer != null ? serverLayer.getOverrideMode() : BOverrideMode.legacy;
            int activeLevel = point.getStatus().geti("activeLevel", 17);
            if (overrideMode.getOrdinal() == 1) {
                if (activeLevel == 1) {
                    status |= 0x20;
                }
            } else if (activeLevel == 1 || activeLevel == 8) {
                status |= 0x20;
            }
        }
        if (this.getOosExt().getOutOfService()) {
            status |= 1;
        }
        return BStatus.make((int)status);
    }

    protected boolean checkPointConfiguration() {
        return true;
    }

    @Override
    void checkValid() {
        if (this.configOk.get()) {
            this.validate();
        }
    }

    protected void validate() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
    }

    public String toString(Context c) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + "]";
    }

    @Override
    public final BControlPoint getPoint() {
        if (this.point == null) {
            return this.findPoint();
        }
        return this.point;
    }

    public final BControlPoint getPoint(boolean force) {
        if (this.point == null) {
            return this.findPoint(force);
        }
        return this.point;
    }

    protected BAlarmSourceExt getAlarmExt() {
        BControlPoint point = this.getPoint();
        if (point == null) {
            return null;
        }
        SlotCursor c = point.getProperties();
        while (c.next(BAlarmSourceExt.class)) {
            BBacnetObjectIdentifier eventEnrollmentId;
            BAlarmSourceExt ext = (BAlarmSourceExt)c.get();
            if (!this.isValidAlarmExt((BIAlarmSource)ext) || (eventEnrollmentId = BBacnetNetwork.localDevice().lookupBacnetObjectId(ext.getHandleOrd())) != null) continue;
            return ext;
        }
        return null;
    }

    protected BFaultAlgorithm getFaultAlgorithm() {
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        return alarmExt != null ? alarmExt.getFaultAlgorithm() : null;
    }

    public BOutOfServiceExt getOosExt() {
        BControlPoint point = this.getPoint(false);
        if (point == null) {
            return null;
        }
        BOutOfServiceExt outOfServiceExt = null;
        SlotCursor c = point.getProperties();
        if (c.next(BOutOfServiceExt.class)) {
            outOfServiceExt = (BOutOfServiceExt)c.get();
        }
        if (outOfServiceExt == null) {
            outOfServiceExt = new BOutOfServiceExt();
            point.add("outOfServiceExt?", (BValue)outOfServiceExt);
        }
        outOfServiceExt.setExport(this);
        outOfServiceExt.setCommandable(this.isCommandable());
        return outOfServiceExt;
    }

    protected boolean isCommandable() {
        return false;
    }

    public String getBacnetWritable() {
        return lexNotWritable;
    }

    private BControlPoint findPoint() {
        return this.findPoint(true);
    }

    private BControlPoint findPoint(boolean force) {
        try {
            if (force || this.ordStatus == OrdStatus.CHANGED) {
                if (!this.getPointOrd().equals((Object)BOrd.DEFAULT)) {
                    BObject o = this.getPointOrd().get((BObject)this);
                    if (o instanceof BControlPoint) {
                        this.point = (BControlPoint)o;
                        this.ordStatus = OrdStatus.OK;
                    } else {
                        this.point = null;
                    }
                }
                if (!this.isPointTypeLegal(this.point)) {
                    this.point = null;
                }
            }
        }
        catch (Exception e) {
            log.warning("Unable to resolve point ord for " + this + ": " + this.getPointOrd() + ": " + e);
            this.point = null;
            this.ordStatus = OrdStatus.INVALID;
        }
        return this.point;
    }

    @Override
    @Deprecated
    protected void updateAlarmInhibit() {
    }

    private BBacnetCovSubscription findSubscription(boolean covProperty, BBacnetAddress subscriberAddress, long processId, BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) {
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetCovSubscription.class)) {
            BBacnetCovSubscription sub = (BBacnetCovSubscription)c.get();
            if (sub.isCovProperty() != covProperty || !sub.getRecipient().getRecipient().getAddress().equals(subscriberAddress.getNetworkNumber(), subscriberAddress.getMacAddress().getBytes()) || sub.getRecipient().getProcessIdentifier().getUnsigned() != processId || !this.getObjectId().equals((Object)objectId) || sub.getMonitoredPropertyReference().getPropertyId() != propertyId || sub.getMonitoredPropertyReference().getPropertyArrayIndex() != propertyArrayIndex) continue;
            return sub;
        }
        return null;
    }

    private void removeOutOfServiceExt() {
        Object[] outOfServiceExts;
        BControlPoint point = this.getPoint();
        if (point != null && (outOfServiceExts = point.getChildren(BOutOfServiceExt.class)) != null && outOfServiceExts.length > 0 && outOfServiceExts[0] instanceof BOutOfServiceExt) {
            point.remove((BComplex)((BOutOfServiceExt)((Object)outOfServiceExts[0])));
        }
    }

    private void updateTrendReferences(BLocalBacnetDevice local, BControlPoint point) {
        for (BPointExtension pointExt : point.getExtensions()) {
            BIBacnetExportObject trendDescriptor;
            if (!(pointExt instanceof BHistoryExt) || !((trendDescriptor = BBacnetPointDescriptor.findDescriptor(local, pointExt)) instanceof BBacnetTrendLogDescriptor)) continue;
            BBacnetDeviceObjectPropertyReference reference = new BBacnetDeviceObjectPropertyReference(this.getObjectId(), 85);
            ((BBacnetTrendLogDescriptor)trendDescriptor).setLogDeviceObjectPropertyReference(reference);
        }
    }

    private void clearTrendReferences(BLocalBacnetDevice local) {
        BControlPoint point = this.getPoint(false);
        if (point == null) {
            return;
        }
        for (BPointExtension pointExt : point.getExtensions()) {
            BIBacnetExportObject trendDescriptor;
            if (!(pointExt instanceof BHistoryExt) || !((trendDescriptor = BBacnetPointDescriptor.findDescriptor(local, pointExt)) instanceof BBacnetTrendLogDescriptor)) continue;
            ((BBacnetTrendLogDescriptor)trendDescriptor).setLogDeviceObjectPropertyReference(new BBacnetDeviceObjectPropertyReference());
        }
    }

    private static BIBacnetExportObject findDescriptor(BLocalBacnetDevice local, BPointExtension pointExt) {
        BBacnetObjectIdentifier trendId = local.lookupBacnetObjectId(pointExt.getHandleOrd());
        if (trendId == null) {
            return null;
        }
        return local.lookupBacnetObject(trendId);
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetPointDescriptor", 2);
        out.prop((Object)"point", (Object)this.point);
        out.prop((Object)"oldId", (Object)this.oldId);
        out.prop((Object)"oldName", (Object)this.oldName);
        out.prop((Object)"duplicate", this.duplicate);
        out.prop((Object)"oldNotifyType", this.oldNotifyType);
        out.prop((Object)"almExt", (Object)this.getAlarmExt());
        out.prop((Object)"notificationClass", (Object)this.getNotificationClass());
        out.prop((Object)"configOk", this.configOk.get());
        out.prop((Object)"oosExt", (Object)this.getOosExt());
        out.endProps();
    }

    private static enum OrdStatus {
        OK,
        INVALID,
        CHANGED;

    }
}

