/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.stack.DeviceRegistry;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.export.BBacnetScheduleDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"schedule:NumericSchedule"})})
@NiagaraProperty(name="scheduleDataType", type="BEnum", defaultValue="BDynamicEnum.make(DATA_TYPE_REAL, NUMERIC_DATA_TYPE_RANGE)", flags=4)
public class BBacnetNumericScheduleDescriptor
extends BBacnetScheduleDescriptor {
    public static final int DATA_TYPE_UNSIGNED = 0;
    public static final int DATA_TYPE_INTEGER = 1;
    public static final int DATA_TYPE_REAL = 2;
    public static final int DATA_TYPE_DOUBLE = 3;
    public static final int DATA_TYPE_ENUMERATED = 4;
    public static final BEnumRange NUMERIC_DATA_TYPE_RANGE = BEnumRange.make((String[])new String[]{AsnUtil.getAsnTypeName(2), AsnUtil.getAsnTypeName(3), AsnUtil.getAsnTypeName(4), AsnUtil.getAsnTypeName(5), AsnUtil.getAsnTypeName(9)});
    @Generated
    public static final Property scheduleDataType = BBacnetNumericScheduleDescriptor.newProperty((int)4, (BValue)BDynamicEnum.make((int)2, (BEnumRange)NUMERIC_DATA_TYPE_RANGE), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetNumericScheduleDescriptor.class);

    @Generated
    public BEnum getScheduleDataType() {
        return (BEnum)this.get(scheduleDataType);
    }

    @Generated
    public void setScheduleDataType(BEnum v) {
        this.set(scheduleDataType, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.setScheduleDataType((BEnum)BDynamicEnum.make((int)this.getScheduleDataType().getOrdinal(), (BEnumRange)NUMERIC_DATA_TYPE_RANGE));
        if (!Flags.isUserDefined1((BComplex)this, (Slot)scheduleDataType)) {
            this.setFlags((Slot)scheduleDataType, this.getFlags((Slot)scheduleDataType) & 0xFFFFFFFB | 0x10000000);
        }
    }

    @Override
    public void doWritePresentValue() {
        BNumericSchedule schedule = (BNumericSchedule)this.getSchedule();
        if (schedule == null || !schedule.getEffective().isEffective(BAbsTime.now())) {
            return;
        }
        BStatusNumeric out = schedule.getOut();
        byte[] propertyValue = this.encodeAsn(out);
        for (BBacnetDeviceObjectPropertyReference ref : (BBacnetDeviceObjectPropertyReference[])this.getListOfObjectPropertyReferences().getChildren(BBacnetDeviceObjectPropertyReference.class)) {
            if (BBacnetNumericScheduleDescriptor.isRemoteDevice(ref)) {
                this.writeToRemote(ref, propertyValue);
                continue;
            }
            this.writeToLocal(ref, propertyValue);
        }
        this.setLastEffectiveValue((BStatusValue)out.newCopy());
    }

    private byte[] encodeAsn(BStatusNumeric out) {
        if (out.getStatus().isNull()) {
            return ASN_NULL_VALUE;
        }
        switch (this.getScheduleDataType().getOrdinal()) {
            case 0: {
                return AsnUtil.toAsnUnsigned((long)out.getValue());
            }
            case 1: {
                return AsnUtil.toAsnInteger((int)out.getValue());
            }
            case 2: {
                return AsnUtil.toAsnReal(out.getValue());
            }
            case 3: {
                return AsnUtil.toAsnDouble(out.getValue());
            }
            case 4: {
                return AsnUtil.toAsnEnumerated((int)out.getValue());
            }
        }
        throw new IllegalStateException("Invalid Schedule Data Type for " + this + ":" + this.getScheduleDataType().getOrdinal());
    }

    private static boolean isRemoteDevice(BBacnetDeviceObjectPropertyReference ref) {
        return ref.isDeviceIdUsed() && !ref.getDeviceId().equals((Object)BBacnetNetwork.localDevice().getObjectId());
    }

    private void writeToRemote(BBacnetDeviceObjectPropertyReference ref, byte[] propertyValue) {
        BBacnetAddress addr = DeviceRegistry.getDeviceAddress(ref.getDeviceId());
        if (addr == null) {
            this.findOrAddRemoteDeviceAndPoint(ref);
            addr = DeviceRegistry.getDeviceAddress(ref.getDeviceId());
        }
        if (addr == null) {
            log.warning(this + ": Unable to write Schedule output to " + ref + ": unable to resolve device address");
            return;
        }
        try {
            BBacnetNumericScheduleDescriptor.client().writeProperty(addr, ref.getObjectId(), ref.getPropertyId(), ref.getPropertyArrayIndex(), propertyValue, this.getPriorityForWriting());
        }
        catch (Exception e) {
            log.warning(this + ": BacnetException writing schedule output from " + this + " to remote object " + ref + ": " + e);
        }
    }

    private void writeToLocal(BBacnetDeviceObjectPropertyReference ref, byte[] propertyValue) {
        BIBacnetExportObject export = BBacnetNetwork.localDevice().lookupBacnetObject(ref.getObjectId());
        try {
            ErrorType err = export.writeProperty(new NBacnetPropertyValue(ref.getPropertyId(), ref.getPropertyArrayIndex(), propertyValue, this.getPriorityForWriting()));
            if (err != null) {
                log.warning(this + ": Unable to write schedule output from " + this + " to local object " + ref + "; error: " + err);
            }
        }
        catch (Exception e) {
            log.warning(this + ": Unable to write schedule output from " + this + " to local object " + ref + ": " + e);
        }
    }

    @Override
    final boolean isScheduleTypeLegal(BWeeklySchedule sched) {
        return sched instanceof BNumericSchedule;
    }

    @Override
    protected boolean isEqual(int ansTypeOfRefObj, int asnTypeOfSchedule) {
        if (ansTypeOfRefObj == asnTypeOfSchedule) {
            return true;
        }
        switch (ansTypeOfRefObj) {
            case 2: {
                this.setScheduleDataType((BEnum)BDynamicEnum.make((int)0, (BEnumRange)NUMERIC_DATA_TYPE_RANGE));
                return true;
            }
            case 3: {
                this.setScheduleDataType((BEnum)BDynamicEnum.make((int)1, (BEnumRange)NUMERIC_DATA_TYPE_RANGE));
                return true;
            }
            case 4: {
                this.setScheduleDataType((BEnum)BDynamicEnum.make((int)2, (BEnumRange)NUMERIC_DATA_TYPE_RANGE));
                return true;
            }
            case 5: {
                this.setScheduleDataType((BEnum)BDynamicEnum.make((int)3, (BEnumRange)NUMERIC_DATA_TYPE_RANGE));
                return true;
            }
            case 9: {
                this.setScheduleDataType((BEnum)BDynamicEnum.make((int)4, (BEnumRange)NUMERIC_DATA_TYPE_RANGE));
                return true;
            }
        }
        return false;
    }

    @Override
    int getAsnType() {
        switch (this.getScheduleDataType().getOrdinal()) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 9;
            }
        }
        throw new IllegalStateException("Invalid Schedule Data Type for " + this + ":" + this.getScheduleDataType().getOrdinal());
    }

    @Override
    final Property getScheduleOutputProperty() {
        return BNumericSchedule.out;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BNumericSchedule sched = (BNumericSchedule)this.getSchedule();
        if (sched == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 85: {
                BAbsTime currentTime = BAbsTime.now();
                BStatusNumeric out = !sched.isEffective(currentTime) && this.getLastEffectiveValue() != null ? (BStatusNumeric)this.getLastEffectiveValue() : sched.getOut();
                return new NReadPropertyResult(pId, ndx, this.encodeAsn(out));
            }
            case 174: {
                BStatusNumeric sf = (BStatusNumeric)sched.getDefaultOutput();
                return new NReadPropertyResult(pId, ndx, this.encodeAsn(sf));
            }
        }
        return super.readProperty(pId, ndx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BNumericSchedule sched = (BNumericSchedule)this.getSchedule();
        if (sched == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(val);
                switch (pId) {
                    case 85: {
                        if (((BStatusValue)sched.get("out")).getStatus().isDisabled()) {
                            int tag = asnIn.peekApplicationTag();
                            if (tag == 0) {
                                sched.getIn().set(BStatusValue.status, (BValue)BStatus.make((BStatus)sched.getIn().getStatus(), (int)64, (boolean)false), BLocalBacnetDevice.getBacnetContext());
                                sched.getOut().set(BStatusValue.status, (BValue)BStatus.make((BStatus)sched.getOut().getStatus(), (int)64, (boolean)true), BLocalBacnetDevice.getBacnetContext());
                                return null;
                            }
                            return this.updateProperty(sched, BNumericSchedule.in, asnIn, tag);
                        }
                        return new NErrorType(2, 40);
                    }
                }
                return super.writeProperty(pId, ndx, val, pri);
            }
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        catch (Exception e) {
            log.warning("Exception writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + e);
            return new NErrorType(2, 0);
        }
    }

    private ErrorType updateProperty(BNumericSchedule sched, Property property, AsnInputStream asnIn, int tag) throws AsnException {
        int scheduleDataType = this.getScheduleDataType().getOrdinal();
        switch (tag) {
            case 2: {
                if (scheduleDataType != 0) break;
                BBacnetNumericScheduleDescriptor.updateProperty(sched, property, asnIn.readUnsignedInteger());
                return null;
            }
            case 3: {
                if (scheduleDataType != 1) break;
                BBacnetNumericScheduleDescriptor.updateProperty(sched, property, asnIn.readSignedInteger());
                return null;
            }
            case 4: {
                if (scheduleDataType != 2) break;
                BBacnetNumericScheduleDescriptor.updateProperty(sched, property, asnIn.readReal());
                return null;
            }
            case 5: {
                if (scheduleDataType != 3) break;
                BBacnetNumericScheduleDescriptor.updateProperty(sched, property, asnIn.readDouble());
                return null;
            }
            case 9: {
                if (scheduleDataType != 4) break;
                BBacnetNumericScheduleDescriptor.updateProperty(sched, property, asnIn.readEnumerated());
                return null;
            }
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.datatypeNotSupported);
    }

    private static void updateProperty(BNumericSchedule sched, Property property, double value) {
        BStatusNumeric statusNumeric = (BStatusNumeric)sched.get(property).newCopy();
        statusNumeric.setValue(value);
        statusNumeric.setStatusNull(false);
        sched.set(property, (BValue)statusNumeric, BLocalBacnetDevice.getBacnetContext());
    }

    @Override
    BStatusValue getEffectiveValueFrom(BStatusValue statusValue) {
        BStatusNumeric ret = new BStatusNumeric(0.0, BStatus.nullStatus);
        if (statusValue instanceof BStatusEnum) {
            ret.setValue((double)((BStatusEnum)statusValue).getValue().getOrdinal());
        } else if (statusValue instanceof BStatusBoolean) {
            ret.setValue(((BStatusBoolean)statusValue).getValue() ? 1.0 : 0.0);
        }
        return ret;
    }

    @Override
    protected ErrorType doWriteScheduleDefaultValue(AsnInputStream asnInputStream, int applicationTag) throws Exception {
        BNumericSchedule sched = (BNumericSchedule)this.getSchedule();
        return this.updateProperty(sched, BControlSchedule.defaultOutput, asnInputStream, applicationTag);
    }
}

