/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.export.BacnetPropertyListProvider;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.space.BISpaceNode;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:AbstractFile"})})
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="fileOrd", type="BOrd", defaultValue="BOrd.NULL", flags=64, facets={@Facet(name="BFacets.TARGET_TYPE", value="\"baja:IFile\"")}), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.FILE)", flags=64), @NiagaraProperty(name="objectName", type="String", defaultValue="", flags=64), @NiagaraProperty(name="description", type="String", defaultValue=""), @NiagaraProperty(name="fileType", type="String", defaultValue=""), @NiagaraProperty(name="archiveTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT"), @NiagaraProperty(name="fileAccessMethod", type="BBacnetFileAccessMethod", defaultValue="BBacnetFileAccessMethod.streamAccess", flags=1)})
public class BBacnetFileDescriptor
extends BComponent
implements BIBacnetExportObject,
BacnetPropertyListProvider {
    @Generated
    public static final Property status = BBacnetFileDescriptor.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BBacnetFileDescriptor.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property fileOrd = BBacnetFileDescriptor.newProperty((int)64, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IFile"));
    @Generated
    public static final Property objectId = BBacnetFileDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(10), null);
    @Generated
    public static final Property objectName = BBacnetFileDescriptor.newProperty((int)64, (String)"", null);
    @Generated
    public static final Property description = BBacnetFileDescriptor.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property fileType = BBacnetFileDescriptor.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property archiveTime = BBacnetFileDescriptor.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property fileAccessMethod = BBacnetFileDescriptor.newProperty((int)1, (BValue)BBacnetFileAccessMethod.streamAccess, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetFileDescriptor.class);
    private boolean fatalFault = false;
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"file.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    private BIFile file;
    private boolean eof = true;
    private Subscriber subscriber;
    private BBacnetObjectIdentifier oldId = null;
    private String oldName = null;
    private boolean duplicate = false;
    private boolean backupConigFile = false;
    public static final int FILE_WRITE_OK = -1;
    public static final int APPEND_START_POSITION = -1;
    static Logger log = Logger.getLogger("bacnet.server");
    private static final int[] REQUIRED_PROPS = new int[]{75, 77, 79, 43, 42, 71, 13, 99, 41};
    private static final int[] OPTIONAL_PROPS = new int[]{28};
    private static final Logger logger = Logger.getLogger("bacnet.export");

    @Override
    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BOrd getFileOrd() {
        return (BOrd)this.get(fileOrd);
    }

    @Generated
    public void setFileOrd(BOrd v) {
        this.set(fileOrd, (BValue)v, null);
    }

    @Override
    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Override
    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Override
    @Generated
    public String getObjectName() {
        return this.getString(objectName);
    }

    @Override
    @Generated
    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public String getFileType() {
        return this.getString(fileType);
    }

    @Generated
    public void setFileType(String v) {
        this.setString(fileType, v, null);
    }

    @Generated
    public BAbsTime getArchiveTime() {
        return (BAbsTime)this.get(archiveTime);
    }

    @Generated
    public void setArchiveTime(BAbsTime v) {
        this.set(archiveTime, (BValue)v, null);
    }

    @Generated
    public BBacnetFileAccessMethod getFileAccessMethod() {
        return (BBacnetFileAccessMethod)this.get(fileAccessMethod);
    }

    @Generated
    public void setFileAccessMethod(BBacnetFileAccessMethod v) {
        this.set(fileAccessMethod, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.subscriber = new FileSubscriber(this);
        this.checkConfiguration();
        if (!this.isBackupConigFile() && Sys.isStationStarted()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        local.unexport(this.oldId, this.oldName, this);
        this.subscriber.unsubscribeAll();
        this.file = null;
        this.subscriber = null;
        this.oldId = null;
        this.oldName = null;
        if (!this.isBackupConigFile() && local.isRunning()) {
            local.incrementDatabaseRevision();
        }
    }

    public final void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {
                // empty catch block
            }
            if (!this.isBackupConigFile() && this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (!this.isBackupConigFile() && this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(fileOrd)) {
            this.checkConfiguration();
            if (!this.isBackupConigFile() && this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        }
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(10);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public final BObject getObject() {
        return (BObject)this.getFile();
    }

    @Override
    public final BOrd getObjectOrd() {
        return this.getFileOrd();
    }

    @Override
    public final void setObjectOrd(BOrd objectOrd, Context cx) {
        this.set(fileOrd, (BValue)objectOrd, cx);
    }

    @Override
    public void checkConfiguration() {
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            log.warning(this + ": is in fatal fault");
            return;
        }
        this.subscriber.unsubscribeAll();
        this.getFile();
        boolean configOk = true;
        if (this.file == null) {
            this.setFaultCause("Cannot find exported file");
            configOk = false;
            log.warning(this + ": cannot find exported file");
        } else {
            this.subscriber.subscribe((BComponent)this.getParent());
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            configOk = false;
            log.warning(this + ": invalid Object Id");
        }
        if (configOk) {
            String err = BBacnetNetwork.localDevice().export(this);
            if (err != null) {
                this.duplicate = true;
                this.setFaultCause(err);
                configOk = false;
                log.warning(this + ": found duplicate id or name");
            } else {
                this.duplicate = false;
            }
        }
        if (configOk) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (!configOk ? 1 : 0) != 0));
        log.info(this + ": configurationOk state is " + configOk);
    }

    @Override
    public int[] getPropertyList() {
        return BacnetPropertyList.makePropertyList(REQUIRED_PROPS, OPTIONAL_PROPS);
    }

    @Override
    public final PropertyValue readProperty(PropertyReference ref) throws RejectException {
        this.getFile();
        return this.readProperty(ref.getPropertyId(), ref.getPropertyArrayIndex());
    }

    @Override
    public final PropertyValue[] readPropertyMultiple(PropertyReference[] refs) throws RejectException {
        this.getFile();
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>(refs.length);
        block5: for (int i = 0; i < refs.length; ++i) {
            switch (refs[i].getPropertyId()) {
                case 8: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    props = OPTIONAL_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 80: {
                    int j;
                    int[] props = OPTIONAL_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 105: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                default: {
                    results.add(this.readProperty(refs[i].getPropertyId(), refs[i].getPropertyArrayIndex()));
                }
            }
        }
        return results.toArray(new PropertyValue[0]);
    }

    @Override
    public RangeData readRange(RangeReference rangeReference) throws RejectException {
        int propertyId = rangeReference.getPropertyId();
        if (!BBacnetFileDescriptor.hasProperty(propertyId)) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
    }

    private static boolean hasProperty(int propertyId) {
        for (int id : REQUIRED_PROPS) {
            if (id != propertyId) continue;
            return true;
        }
        for (int id : OPTIONAL_PROPS) {
            if (id != propertyId) continue;
            return true;
        }
        return propertyId == 371;
    }

    @Override
    public final ErrorType writeProperty(PropertyValue val) throws BacnetException {
        this.getFile();
        return this.writeProperty(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue(), val.getPriority());
    }

    @Override
    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        int propertyId = propertyValue.getPropertyId();
        if (!BBacnetFileDescriptor.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
    }

    @Override
    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        int propertyId = propertyValue.getPropertyId();
        if (!BBacnetFileDescriptor.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
    }

    protected PropertyValue readProperty(int pId, int ndx) {
        if (this.file == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (pId == 371) {
            return this.readPropertyList(ndx);
        }
        if (ndx >= 0) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 75: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 79: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 77: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 43: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.file.getMimeType()));
            }
            case 42: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(this.file.getSize()));
            }
            case 71: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toBacnetDateTime(this.file.getLastModified()));
            }
            case 13: {
                boolean archive = this.getArchiveTime().isAfter(this.file.getLastModified());
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(archive));
            }
            case 99: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.file.isReadonly()));
            }
            case 41: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated((BEnum)this.getFileAccessMethod()));
            }
            case 28: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
        }
        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
    }

    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        if (this.file == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && pId != 371) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 75: 
                case 79: 
                case 371: {
                    return new NErrorType(2, 40);
                }
                case 77: {
                    return BacUtil.setObjectName(this, objectName, val);
                }
                case 43: {
                    return new NErrorType(2, 40);
                }
                case 42: {
                    if (this.file.isReadonly()) {
                        return new NErrorType(2, 40);
                    }
                    try {
                        if (AsnUtil.fromAsnUnsignedInt(val) != 0) {
                            return new NErrorType(2, 37);
                        }
                        this.file.write(new byte[0]);
                        return null;
                    }
                    catch (IOException e) {
                        return new NErrorType(0, 25);
                    }
                    catch (IllegalArgumentException e) {
                        return new NErrorType(2, 37);
                    }
                }
                case 71: {
                    return new NErrorType(2, 40);
                }
                case 13: {
                    boolean archive = AsnUtil.fromAsnBoolean(val);
                    if (archive) {
                        this.set(archiveTime, (BValue)BAbsTime.make(), BLocalBacnetDevice.getBacnetContext());
                    } else {
                        this.set(archiveTime, (BValue)BAbsTime.DEFAULT, BLocalBacnetDevice.getBacnetContext());
                    }
                    return null;
                }
                case 99: {
                    return new NErrorType(2, 40);
                }
                case 41: {
                    return new NErrorType(2, 40);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return new NErrorType(2, 32);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    public String toString(Context c) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + "]";
    }

    protected final BIFile getFile() {
        if (this.file == null) {
            return this.findFile();
        }
        return this.file;
    }

    private BIFile findFile() {
        try {
            if (!fileOrd.isEquivalentToDefaultValue((BValue)this.getFileOrd())) {
                BObject o = this.getFileOrd().get((BObject)this);
                this.file = o instanceof BIFile ? (BIFile)o : null;
            }
        }
        catch (Exception e) {
            log.warning("Unable to resolve file ord for " + this + ":" + this.getFileOrd() + ": " + e);
            this.file = null;
        }
        if (this.file == null) {
            this.setFaultCause("Cannot find exported file");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
        return this.file;
    }

    public final byte[] read(int fileStartPosition, int requestedOctetCount) throws IOException {
        return this.readFile(fileStartPosition, requestedOctetCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readFile(int fileStartPosition, int requestedOctetCount) throws IOException {
        if (this.file == null) {
            return null;
        }
        this.eof = false;
        try (InputStream in = this.file.getInputStream();){
            byte[] b;
            in.skip(fileStartPosition);
            int avail = in.available();
            if (avail <= requestedOctetCount) {
                this.eof = true;
                b = new byte[avail];
            } else {
                this.eof = false;
                b = new byte[requestedOctetCount];
            }
            int numRead = in.read(b);
            if (log.isLoggable(Level.FINE)) {
                log.fine("BacnetFile " + this.file.getFileName() + " {" + (Object)((Object)this.getObjectId()) + "}.read(): " + requestedOctetCount + " bytes requested, " + numRead + " bytes read from file.");
            }
            if (numRead < 0) {
                this.eof = true;
            }
            byte[] byArray = b;
            return byArray;
        }
    }

    public final int write(int fileStartPosition, byte[] fileData) throws IOException {
        return this.writeFile(fileStartPosition, fileData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeFile(int fileStartPosition, byte[] fileData) throws IOException {
        if (this.file == null) {
            return 5;
        }
        if (this.file.isReadonly()) {
            return 5;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetFile " + this.file.getFileName() + " {" + (Object)((Object)this.getObjectId()) + "}.write() :" + fileData.length + " bytes starting at " + fileStartPosition);
        }
        long len = this.file.getSize();
        File f = ((BLocalFileStore)this.file.getStore()).getLocalFile();
        try (RandomAccessFile out = new RandomAccessFile(f, "rw");){
            if ((long)fileStartPosition >= len) {
                int diff = (int)((long)fileStartPosition - len);
                out.seek(len);
                byte[] b = new byte[diff];
                for (int i = 0; i < diff; ++i) {
                    b[i] = 0;
                }
                out.write(b);
            } else if (fileStartPosition == -1) {
                out.seek(len);
            } else if (fileStartPosition >= 0) {
                out.seek(fileStartPosition);
            } else {
                int n = 11;
                return n;
            }
            out.write(fileData);
            log.fine("File write OK");
            int n = -1;
            return n;
        }
    }

    public long getFileSize() {
        return this.getFile().getSize();
    }

    public final boolean isEOF() {
        return this.eof;
    }

    @Override
    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private void checkFatalFault() {
        BBacnetExportTable exports = null;
        BLocalBacnetDevice local = null;
        BBacnetNetwork network = null;
        if (this.fatalFault) {
            return;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof BBacnetExportTable) {
                exports = (BBacnetExportTable)parent;
                continue;
            }
            if (!(parent instanceof BLocalBacnetDevice)) continue;
            local = (BLocalBacnetDevice)parent;
            break;
        }
        if (exports == null || local == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (local.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + local.getFaultCause());
            return;
        }
        network = (BBacnetNetwork)local.getParent();
        if (network == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (network.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + network.getFaultCause());
            return;
        }
        if (!network.hasServerLicense()) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    public boolean isBackupConigFile() {
        return this.backupConigFile;
    }

    public void setBackupConigFile(boolean backupConigFile) {
        this.backupConigFile = backupConigFile;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetFileDescriptor", 2);
        out.prop((Object)"fatalFault", this.fatalFault);
        out.prop((Object)"file", (Object)this.file);
        out.prop((Object)"eof", this.eof);
        out.prop((Object)"subscriber", (Object)this.subscriber);
        out.prop((Object)"oldId", (Object)this.oldId);
        out.prop((Object)"oldName", (Object)this.oldName);
        out.prop((Object)"duplicate", this.duplicate);
        out.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    static class FileSubscriber
    extends Subscriber {
        private final BBacnetFileDescriptor obj;

        public FileSubscriber(BBacnetFileDescriptor obj) {
            this.obj = obj;
        }

        public void event(BComponentEvent event) {
            try {
                if (event.getId() == 3 && event.getSlotName().equals(this.obj.getObjectName())) {
                    this.obj.setObjectOrd(((BISpaceNode)this.obj.getObject()).getOrdInSpace(), null);
                    this.obj.checkConfiguration();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "obj=" + (Object)((Object)this.obj.getObjectId()), e);
            }
        }
    }
}

