/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.stack.DeviceRegistry;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.export.BBacnetScheduleDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"schedule:EnumSchedule"})})
@NiagaraProperty(name="scheduleDataType", type="BEnum", defaultValue="BDynamicEnum.make(LOCAL_UNSIGNED, ENUM_DATA_TYPE_RANGE)")
public class BBacnetEnumScheduleDescriptor
extends BBacnetScheduleDescriptor {
    private static final int LOCAL_UNSIGNED = 0;
    private static final int LOCAL_ENUMERATED = 1;
    private static final int LOCAL_INTEGER = 2;
    private static final BEnumRange ENUM_DATA_TYPE_RANGE = BEnumRange.make((String[])new String[]{AsnUtil.getAsnTypeName(2), AsnUtil.getAsnTypeName(9), AsnUtil.getAsnTypeName(3)});
    @Generated
    public static final Property scheduleDataType = BBacnetEnumScheduleDescriptor.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)ENUM_DATA_TYPE_RANGE), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEnumScheduleDescriptor.class);

    @Generated
    public BEnum getScheduleDataType() {
        return (BEnum)this.get(scheduleDataType);
    }

    @Generated
    public void setScheduleDataType(BEnum v) {
        this.set(scheduleDataType, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.setScheduleDataType((BEnum)BDynamicEnum.make((int)this.getScheduleDataType().getOrdinal(), (BEnumRange)ENUM_DATA_TYPE_RANGE));
    }

    private boolean isUnsigned() {
        return this.getScheduleDataType().getOrdinal() == 0;
    }

    private boolean isEnumerated() {
        return this.getScheduleDataType().getOrdinal() == 1;
    }

    private boolean isInteger() {
        return this.getScheduleDataType().getOrdinal() == 2;
    }

    @Override
    public void doWritePresentValue() {
        BEnumSchedule sched = (BEnumSchedule)this.getSchedule();
        if (sched != null && sched.getEffective().isEffective(BAbsTime.now())) {
            BStatusEnum out = sched.getOut();
            byte[] writeVal = AsnUtil.toAsnNull();
            if (!out.getStatus().isNull()) {
                switch (this.getScheduleDataType().getOrdinal()) {
                    case 0: {
                        writeVal = AsnUtil.toAsnUnsigned(out.getValue().getOrdinal());
                        break;
                    }
                    case 1: {
                        writeVal = AsnUtil.toAsnEnumerated(out.getValue().getOrdinal());
                        break;
                    }
                    case 2: {
                        writeVal = AsnUtil.toAsnInteger(out.getValue().getOrdinal());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid Schedule Data Type for " + this + ":" + this.getScheduleDataType().getOrdinal());
                    }
                }
            }
            SlotCursor c = this.getListOfObjectPropertyReferences().getProperties();
            while (c.next(BBacnetDeviceObjectPropertyReference.class)) {
                BBacnetDeviceObjectPropertyReference ref = (BBacnetDeviceObjectPropertyReference)c.get();
                if (ref.isDeviceIdUsed() && !ref.getDeviceId().equals((Object)BBacnetNetwork.localDevice().getObjectId())) {
                    BBacnetAddress addr = DeviceRegistry.getDeviceAddress(ref.getDeviceId());
                    if (addr == null) {
                        this.findOrAddRemoteDeviceAndPoint(ref);
                        addr = DeviceRegistry.getDeviceAddress(ref.getDeviceId());
                    }
                    if (addr != null) {
                        try {
                            BBacnetEnumScheduleDescriptor.client().writeProperty(addr, ref.getObjectId(), ref.getPropertyId(), ref.getPropertyArrayIndex(), writeVal, this.getPriorityForWriting());
                        }
                        catch (BacnetException e) {
                            log.warning("BacnetException writing schedule output to " + ref + ": " + (Object)((Object)e));
                        }
                        continue;
                    }
                    log.warning("Unable to write Schedule output " + out + " to " + ref + ": unable to resolve device address");
                    continue;
                }
                BIBacnetExportObject o = BBacnetNetwork.localDevice().lookupBacnetObject(ref.getObjectId());
                try {
                    ErrorType err = o.writeProperty(new NBacnetPropertyValue(ref.getPropertyId(), ref.getPropertyArrayIndex(), writeVal, this.getPriorityForWriting()));
                    if (err == null) continue;
                    throw new ErrorException(err);
                }
                catch (Exception e) {
                    log.warning("Unable to write schedule output " + out + " from " + this + " to local object " + ref + ": " + e);
                }
            }
            this.setLastEffectiveValue((BStatusValue)out.newCopy());
        }
    }

    @Override
    final boolean isScheduleTypeLegal(BWeeklySchedule sched) {
        return sched instanceof BEnumSchedule;
    }

    @Override
    protected boolean isEqual(int ansTypeOfRefObj, int asnTypeOfSchedule) {
        if (ansTypeOfRefObj == asnTypeOfSchedule) {
            return true;
        }
        if (ansTypeOfRefObj == 2) {
            this.setScheduleDataType((BEnum)BDynamicEnum.make((int)ENUM_DATA_TYPE_RANGE.getOrdinals()[0], (BEnumRange)ENUM_DATA_TYPE_RANGE));
            return true;
        }
        if (ansTypeOfRefObj == 9) {
            this.setScheduleDataType((BEnum)BDynamicEnum.make((int)ENUM_DATA_TYPE_RANGE.getOrdinals()[1], (BEnumRange)ENUM_DATA_TYPE_RANGE));
            return true;
        }
        if (ansTypeOfRefObj == 3) {
            this.setScheduleDataType((BEnum)BDynamicEnum.make((int)ENUM_DATA_TYPE_RANGE.getOrdinals()[2], (BEnumRange)ENUM_DATA_TYPE_RANGE));
            return true;
        }
        return false;
    }

    @Override
    int getAsnType() {
        switch (this.getScheduleDataType().getOrdinal()) {
            case 0: {
                return 2;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 3;
            }
        }
        throw new IllegalStateException("Invalid Schedule Data Type for " + this + ":" + this.getScheduleDataType().getOrdinal());
    }

    @Override
    final Property getScheduleOutputProperty() {
        return BEnumSchedule.out;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BEnumSchedule sched = (BEnumSchedule)this.getSchedule();
        if (sched == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 85: {
                BAbsTime currentTime = BAbsTime.now();
                BStatusEnum out = !sched.isEffective(currentTime) && this.getLastEffectiveValue() != null ? (BStatusEnum)this.getLastEffectiveValue() : sched.getOut();
                return new NReadPropertyResult(pId, ndx, this.encodeAsn(out));
            }
            case 174: {
                BStatusEnum sms = (BStatusEnum)sched.getDefaultOutput();
                return new NReadPropertyResult(pId, ndx, this.encodeAsn(sms));
            }
        }
        return super.readProperty(pId, ndx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BEnumSchedule sched = (BEnumSchedule)this.getSchedule();
        if (sched == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(val);
                switch (pId) {
                    case 85: {
                        if (((BStatusValue)sched.get("out")).getStatus().isDisabled()) {
                            BStatusEnum inval = (BStatusEnum)sched.getIn().newCopy();
                            BDynamicEnum ms = inval.getValue();
                            switch (asnIn.peekApplicationTag()) {
                                case 0: {
                                    sched.getOut().set(BStatusValue.status, (BValue)BStatus.make((BStatus)sched.getOut().getStatus(), (int)64, (boolean)true), BLocalBacnetDevice.getBacnetContext());
                                    return null;
                                }
                                case 2: {
                                    if (this.isUnsigned()) {
                                        inval.setValue(BDynamicEnum.make((int)asnIn.readUnsignedInt(), (BEnumRange)ms.getRange()));
                                        sched.set(BEnumSchedule.in, (BValue)inval, BLocalBacnetDevice.getBacnetContext());
                                        return null;
                                    }
                                }
                                case 3: {
                                    if (this.isInteger()) {
                                        inval.setValue(BDynamicEnum.make((int)asnIn.readInteger(), (BEnumRange)ms.getRange()));
                                        sched.set(BEnumSchedule.in, (BValue)inval, BLocalBacnetDevice.getBacnetContext());
                                        return null;
                                    }
                                }
                                case 9: {
                                    if (!this.isEnumerated()) break;
                                    inval.setValue(BDynamicEnum.make((int)asnIn.readEnumerated(), (BEnumRange)ms.getRange()));
                                    sched.set(BEnumSchedule.in, (BValue)inval, BLocalBacnetDevice.getBacnetContext());
                                    return null;
                                }
                            }
                            return new NErrorType(2, 9);
                        }
                        return new NErrorType(2, 40);
                    }
                }
                return super.writeProperty(pId, ndx, val, pri);
            }
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        catch (Exception e) {
            log.warning("Exception writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + e);
            return new NErrorType(2, 0);
        }
    }

    @Override
    protected ErrorType doWriteScheduleDefaultValue(AsnInputStream asnInputStream, int applicationTag) throws Exception {
        BEnumSchedule sched = (BEnumSchedule)this.getSchedule();
        BStatusEnum defval = (BStatusEnum)sched.getDefaultOutput().newCopy();
        BDynamicEnum ms = defval.getValue();
        switch (applicationTag) {
            case 2: {
                if (this.isUnsigned()) {
                    defval.setValue(BDynamicEnum.make((int)asnIn.readUnsignedInt(), (BEnumRange)ms.getRange()));
                    defval.setStatusNull(false);
                    sched.set(BControlSchedule.defaultOutput, (BValue)defval, BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            case 3: {
                if (this.isInteger()) {
                    defval.setValue(BDynamicEnum.make((int)asnIn.readInteger(), (BEnumRange)ms.getRange()));
                    defval.setStatusNull(false);
                    sched.set(BControlSchedule.defaultOutput, (BValue)defval, BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            case 9: {
                if (!this.isEnumerated()) break;
                defval.setValue(BDynamicEnum.make((int)asnIn.readEnumerated(), (BEnumRange)ms.getRange()));
                defval.setStatusNull(false);
                sched.set(BControlSchedule.defaultOutput, (BValue)defval, BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        return new NErrorType(2, 9);
    }

    @Override
    BStatusValue getEffectiveValueFrom(BStatusValue statusValue) {
        BEnumSchedule schedule = (BEnumSchedule)this.getSchedule();
        BEnumRange range = (BEnumRange)schedule.getFacets().get("range");
        BStatusEnum ret = new BStatusEnum((BEnum)BDynamicEnum.make((int)0, (BEnumRange)range), BStatus.nullStatus);
        if (statusValue instanceof BStatusEnum) {
            ret = (BStatusEnum)statusValue.newCopy(true);
        } else {
            ret.setValue(BDynamicEnum.make((int)0, (BEnumRange)range));
        }
        return ret;
    }

    private byte[] encodeAsn(BStatusEnum se) {
        if (se.getStatus().isNull()) {
            return AsnUtil.toAsnNull();
        }
        int ordinal = se.getValue().getOrdinal();
        switch (this.getScheduleDataType().getOrdinal()) {
            case 0: {
                return AsnUtil.toAsnUnsigned(ordinal);
            }
            case 1: {
                return AsnUtil.toAsnEnumerated(ordinal);
            }
            case 2: {
                return AsnUtil.toAsnInteger(ordinal);
            }
        }
        throw new IllegalStateException("Invalid Schedule Data Type for " + this + ":" + this.getScheduleDataType().getOrdinal());
    }
}

