/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.StringTokenizer;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.export.BBacnetAnalogPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.export.BacnetWritableDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BLink;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="bacnetWritable", type="String", defaultValue="BBacnetAnalogPointDescriptor.lexNotWritable", flags=5)
public abstract class BBacnetAnalogWritableDescriptor
extends BBacnetAnalogPointDescriptor
implements BacnetWritableDescriptor {
    @Generated
    public static final Property bacnetWritable = BBacnetAnalogWritableDescriptor.newProperty((int)5, (String)BBacnetAnalogPointDescriptor.lexNotWritable, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetAnalogWritableDescriptor.class);

    @Override
    @Generated
    public String getBacnetWritable() {
        return this.getString(bacnetWritable);
    }

    @Generated
    public void setBacnetWritable(String v) {
        this.setString(bacnetWritable, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected final boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BNumericWritable;
    }

    @Override
    protected boolean isCommandable() {
        return true;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BNumericWritable pt = (BNumericWritable)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 87: {
                return this.readPriorityArray(ndx);
            }
            case 104: {
                byte[] asn = this.convertToAsn(pt.getFallback().getValue());
                return new NReadPropertyResult(pId, ndx, asn);
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BNumericWritable pt = (BNumericWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 85: {
                    return this.writePriorityArray(pri, val);
                }
                case 87: {
                    return new NErrorType(2, 40);
                }
                case 104: {
                    BNumber nmin = (BNumber)this.getPoint().getFacets().getFacet("min");
                    BNumber nmax = (BNumber)this.getPoint().getFacets().getFacet("max");
                    double min = nmin != null ? nmin.getDouble() : Double.NEGATIVE_INFINITY;
                    double max = nmax != null ? nmax.getDouble() : Double.POSITIVE_INFINITY;
                    double real = Double.NaN;
                    real = this.convertFromAsn(val);
                    if (real < min || real > max) {
                        return new NErrorType(2, 37);
                    }
                    BStatusNumeric fb = pt.getFallback();
                    fb.setDouble(BStatusNumeric.value, real, BLocalBacnetDevice.getBacnetContext());
                    fb.setStatusNull(false);
                    return null;
                }
            }
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        return super.writeProperty(pId, ndx, val, pri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyValue readPriorityArray(int ndx) {
        BNumericWritable pt = (BNumericWritable)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(87, ndx, new NErrorType(1, 1000));
        }
        if (ndx == -1) {
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                for (int i = 1; i <= 16; ++i) {
                    BStatusNumeric e = pt.getLevel(BPriorityLevel.make((int)i));
                    if (e.getStatus().isNull()) {
                        asnOut.writeNull();
                        continue;
                    }
                    this.appendToAsn(asnOut, e.getValue());
                }
                return new NReadPropertyResult(87, ndx, asnOut.toByteArray());
            }
        }
        if (ndx == 0) {
            return new NReadPropertyResult(87, ndx, AsnUtil.toAsnUnsigned(16L));
        }
        try {
            BStatusNumeric e = pt.getLevel(BPriorityLevel.make((int)ndx));
            if (e.getStatus().isNull()) {
                return new NReadPropertyResult(87, ndx, AsnUtil.toAsnNull());
            }
            return new NReadPropertyResult(87, ndx, this.convertToAsn(e.getValue()));
        }
        catch (Exception e) {
            return new NReadPropertyResult(87, ndx, new NErrorType(2, 42));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorType writePriorityArray(int pri, byte[] val) throws BacnetException {
        BNumericWritable pt = (BNumericWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        try {
            if (pri == -1) {
                pri = 16;
            }
            if (pri < 1 || pri > 16) {
                return new NErrorType(5, 80);
            }
            String inSlotName = "bacnetValueIn" + pri;
            Property inSlot = this.loadSlots().getProperty(inSlotName);
            if (inSlot == null) {
                return new NErrorType(2, 40);
            }
            BStatusNumeric bacval = (BStatusNumeric)this.get(inSlot).newCopy();
            BNumber nmin = (BNumber)pt.getFacets().getFacet("min");
            BNumber nmax = (BNumber)pt.getFacets().getFacet("max");
            double min = nmin != null ? nmin.getDouble() : Double.NEGATIVE_INFINITY;
            double max = nmax != null ? nmax.getDouble() : Double.POSITIVE_INFINITY;
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(val);
                int tag = asnIn.peekTag();
                if (tag == 0) {
                    bacval.setStatusNull(true);
                } else if (tag == this.asnType()) {
                    double real = this.readFromAsn(asnIn);
                    if (real < min || real > max) {
                        return new NErrorType(2, 37);
                    }
                    BOutOfServiceExt outOfServiceExt = this.getOosExt();
                    if (outOfServiceExt.getOutOfService()) {
                        outOfServiceExt.set(BOutOfServiceExt.presentValue, (BValue)BDouble.make((double)real), BLocalBacnetDevice.getBacnetContext());
                    }
                    bacval.setStatusNull(false);
                    bacval.setValue(real);
                } else {
                    throw new AsnException("Invalid tag: " + tag);
                }
            }
            this.set(inSlot, (BValue)bacval, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (IllegalArgumentException e) {
            log.warning("IllegalArgumentException writing priorityArray in object " + (Object)((Object)this.getObjectId()) + ": " + e);
            return new NErrorType(2, 37);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing priorityArray in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    private void resetBacnetWritable() {
        StringBuilder sb = new StringBuilder();
        Knob[] knobs = this.getKnobs();
        for (int i = 0; i < knobs.length; ++i) {
            BObject tgt = knobs[i].getTargetOrd().get((BObject)this);
            BControlPoint pt = this.getPoint();
            if (!knobs[i].getTargetSlotName().startsWith("in") || tgt != pt) continue;
            sb.append(knobs[i].getTargetSlotName()).append(',');
        }
        this.setBacnetWritable(sb.length() > 0 ? sb.substring(0, sb.length() - 1) : lexNotWritable);
    }

    public void knobAdded(Knob knob, Context cx) {
        this.resetBacnetWritable();
    }

    public void knobRemoved(Knob knob, Context cx) {
        this.resetBacnetWritable();
    }

    @Override
    public final void doMakeWritable(BValue writable) {
        if (!this.isRunning()) {
            return;
        }
        BNumericWritable pt = (BNumericWritable)this.getPoint();
        if (pt == null) {
            return;
        }
        BLink[] links = pt.getLinks();
        for (int i = 0; i < links.length; ++i) {
            if (links[i].isActive()) {
                if (links[i].getSourceComponent() != this || !links[i].getTargetSlot().getName().startsWith("in")) continue;
                pt.remove((BComplex)links[i]);
                continue;
            }
            pt.remove((BComplex)links[i]);
        }
        BStatusNumeric[] bacnetValues = (BStatusNumeric[])this.getChildren(BStatusNumeric.class);
        for (int i = 0; i < bacnetValues.length; ++i) {
            if (!bacnetValues[i].getName().startsWith("bacnetValueIn")) continue;
            this.remove((BComplex)bacnetValues[i]);
        }
        String s = ((BString)writable).getString();
        if (s.equals(lexNotWritable)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String tgtSlotName = st.nextToken();
            Slot tgtSlot = pt.getSlot(tgtSlotName);
            BValue value = pt.get(tgtSlotName).newCopy();
            String srcSlotName = "bacnetValue" + TextUtil.capitalize((String)tgtSlotName);
            BStatusNumeric sf = new BStatusNumeric();
            sf.setStatusNull(true);
            this.add(srcSlotName, (BValue)sf, 257);
            pt.setFlags(tgtSlot, pt.getFlags(tgtSlot) | 0x400);
            BLink link = new BLink(this.getHandleOrd(), srcSlotName, tgtSlotName, true);
            pt.add("bacnet" + tgtSlotName, (BValue)link, 1);
            pt.set(tgtSlotName, value);
        }
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 35: {
                BAlarmSourceExt almExt = this.getAlarmExt();
                if (almExt == null) break;
                almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

