/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.AsnUtil;
import java.util.ArrayList;
import java.util.List;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="sequenceTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=5)
@NiagaraActions(value={@NiagaraAction(name="add", parameterType="BValue", defaultValue="BBoolean.FALSE"), @NiagaraAction(name="remove", parameterType="BInteger", defaultValue="BInteger.make(1)", returnType="BValue")})
public class BBacnetSequenceOf
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property sequenceTypeSpec = BBacnetSequenceOf.newProperty((int)5, (BValue)BTypeSpec.DEFAULT, null);
    @Generated
    public static final Action add = BBacnetSequenceOf.newAction((int)0, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Action remove = BBacnetSequenceOf.newAction((int)0, (BValue)BInteger.make((int)1), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetSequenceOf.class);

    @Generated
    public BTypeSpec getSequenceTypeSpec() {
        return (BTypeSpec)this.get(sequenceTypeSpec);
    }

    @Generated
    public void setSequenceTypeSpec(BTypeSpec v) {
        this.set(sequenceTypeSpec, (BValue)v, null);
    }

    @Generated
    public void add(BValue parameter) {
        this.invoke(add, parameter, null);
    }

    @Generated
    public BValue remove(BInteger parameter) {
        return this.invoke(remove, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetSequenceOf() {
    }

    public BBacnetSequenceOf(Type sequenceType) {
        this.setSequenceTypeSpec(BTypeSpec.make((Type)sequenceType));
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        this.notifyParent(context);
    }

    public final void added(Property property, Context context) {
        super.added(property, context);
        this.notifyParent(context);
    }

    public final void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        this.notifyParent(context);
    }

    public void reordered(Context context) {
        super.reordered(context);
        this.notifyParent(context);
    }

    private void notifyParent(Context context) {
        if (!this.isRunning() || context == noWrite) {
            return;
        }
        this.getParent().asComponent().changed(this.getPropertyInParent(), context);
    }

    public void doAdd(BValue newElement, Context context) {
        if (!newElement.getType().equals(this.getSequenceTypeSpec().getResolvedType())) {
            throw new IllegalArgumentException("Invalid type " + newElement.getType() + " for " + this);
        }
        this.add("element1?", newElement, context);
    }

    public BValue doRemove(BInteger index, Context context) {
        Type sequenceType = this.getSequenceTypeSpec().getResolvedType();
        Property[] allProperties = this.getDynamicPropertiesArray();
        ArrayList<Property> elementProperties = new ArrayList<Property>(allProperties.length);
        for (Property property : allProperties) {
            if (!this.get(property).getType().equals(sequenceType)) continue;
            elementProperties.add(property);
        }
        int indexInt = index.getInt();
        if (indexInt < 1 || indexInt > elementProperties.size()) {
            throw new IllegalArgumentException("Invalid index: " + indexInt);
        }
        Property removedProperty = (Property)elementProperties.get(indexInt - 1);
        BValue removedValue = this.get(removedProperty);
        this.remove(removedProperty, context);
        return removedValue;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(add)) {
            BTypeSpec typeSpec = this.getSequenceTypeSpec();
            if (typeSpec.isNull()) {
                return null;
            }
            return (BValue)typeSpec.getInstance();
        }
        return super.getActionParameterDefault(action);
    }

    @Override
    public void writeAsn(AsnOutput out) {
        Type sequenceType = this.getSequenceTypeSpec().getResolvedType();
        int asnType = AsnUtil.getAsnType(sequenceType);
        block15: for (Object element : this.getChildren(sequenceType.getTypeClass())) {
            switch (asnType) {
                case 0: {
                    out.writeNull();
                    continue block15;
                }
                case 1: {
                    out.writeBoolean((BBoolean)element);
                    continue block15;
                }
                case 2: {
                    out.writeUnsigned((BBacnetUnsigned)((Object)element));
                    continue block15;
                }
                case 3: {
                    out.writeSignedInteger((BInteger)element);
                    continue block15;
                }
                case 4: {
                    out.writeReal((BNumber)((BFloat)element));
                    continue block15;
                }
                case 5: {
                    out.writeDouble((BNumber)((BDouble)element));
                    continue block15;
                }
                case 6: {
                    out.writeOctetString((BBacnetOctetString)((Object)element));
                    continue block15;
                }
                case 7: {
                    out.writeCharacterString((BString)element);
                    continue block15;
                }
                case 8: {
                    out.writeBitString((BBacnetBitString)((Object)element));
                    continue block15;
                }
                case 9: {
                    out.writeEnumerated((BEnum)element);
                    continue block15;
                }
                case 10: {
                    out.writeDate((BBacnetDate)((Object)element));
                    continue block15;
                }
                case 11: {
                    out.writeTime((BBacnetTime)((Object)element));
                    continue block15;
                }
                case 12: {
                    out.writeObjectIdentifier((BBacnetObjectIdentifier)((Object)element));
                    continue block15;
                }
                default: {
                    ((BIBacnetDataType)element).writeAsn(out);
                }
            }
        }
    }

    public static List<BValue> readAsn(AsnInput in, int closingTag, Type sequenceType) throws AsnException {
        int asnType = AsnUtil.getAsnType(sequenceType);
        ArrayList<BValue> newValues = new ArrayList<BValue>();
        int tag = in.peekTag();
        while (tag != -1 && !in.isClosingTag(closingTag)) {
            BSimple value;
            switch (asnType) {
                case 0: {
                    value = in.readNull();
                    break;
                }
                case 1: {
                    value = BBoolean.make((boolean)in.readBoolean());
                    break;
                }
                case 2: {
                    value = in.readUnsigned();
                    break;
                }
                case 3: {
                    value = BInteger.make((int)in.readSignedInteger());
                    break;
                }
                case 4: {
                    value = BFloat.make((float)in.readReal());
                    break;
                }
                case 5: {
                    value = BDouble.make((double)in.readDouble());
                    break;
                }
                case 6: {
                    value = BBacnetOctetString.make(in.readOctetString());
                    break;
                }
                case 7: {
                    value = BString.make((String)in.readCharacterString());
                    break;
                }
                case 8: {
                    value = in.readBitString();
                    break;
                }
                case 9: {
                    BEnum d = (BEnum)sequenceType.getInstance();
                    value = d.getRange().get(in.readEnumerated());
                    break;
                }
                case 10: {
                    value = in.readDate();
                    break;
                }
                case 11: {
                    value = in.readTime();
                    break;
                }
                case 12: {
                    value = in.readObjectIdentifier();
                    break;
                }
                default: {
                    value = (BValue)sequenceType.getInstance();
                    ((BIBacnetDataType)value).readAsn(in);
                }
            }
            newValues.add((BValue)value);
            tag = in.peekTag();
        }
        return newValues;
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        BTypeSpec typeSpec = this.getSequenceTypeSpec();
        if (typeSpec.isNull()) {
            throw new AsnException("Invalid sequence type: " + typeSpec);
        }
        Type sequenceType = typeSpec.getResolvedType();
        List<BValue> newValues = BBacnetSequenceOf.readAsn(in, -1, sequenceType);
        this.updateElements(newValues, sequenceType, noWrite);
    }

    public void updateElements(List<BValue> newValues, Type sequenceType, Context context) {
        Property[] oldProps;
        int newIndex = 0;
        for (Property oldProp : oldProps = this.getDynamicPropertiesArray()) {
            BValue oldValue = this.get(oldProp);
            if (!oldValue.getType().equals(sequenceType)) continue;
            if (newIndex < newValues.size()) {
                BValue newValue = newValues.get(newIndex);
                if (!oldValue.equivalent((Object)newValue)) {
                    this.set(oldProp, newValue, context);
                }
                ++newIndex;
                continue;
            }
            this.remove(oldProp, context);
        }
        for (int i = newIndex; i < newValues.size(); ++i) {
            this.add("element1?", newValues.get(i), context);
        }
    }

    public String toString(Context context) {
        return "Sequence of " + this.getSequenceTypeSpec().getTypeName();
    }
}

