/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetAction;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetLifeSafetyMode;
import javax.baja.bacnet.enums.BBacnetLifeSafetyOperation;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.enums.BBacnetMaintenance;
import javax.baja.bacnet.enums.BBacnetNodeType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetPolarity;
import javax.baja.bacnet.enums.BBacnetProgramError;
import javax.baja.bacnet.enums.BBacnetProgramRequest;
import javax.baja.bacnet.enums.BBacnetProgramState;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.enums.BBacnetRestartReason;
import javax.baja.bacnet.enums.BBacnetShedState;
import javax.baja.bacnet.enums.BBacnetSilencedState;
import javax.baja.bacnet.enums.BBacnetWriteStatus;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisable;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisableReason;
import javax.baja.bacnet.enums.access.BBacnetAccessEvent;
import javax.baja.bacnet.enums.access.BBacnetAccessZoneOccupancyState;
import javax.baja.bacnet.enums.access.BBacnetAuthenticationStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorAlarmState;
import javax.baja.bacnet.enums.access.BBacnetDoorSecuredStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorValue;
import javax.baja.bacnet.enums.access.BBacnetLockStatus;
import javax.baja.bacnet.enums.lighting.BBacnetBinaryLightingPv;
import javax.baja.bacnet.enums.lighting.BBacnetLightingInProgress;
import javax.baja.bacnet.enums.lighting.BBacnetLightingOperation;
import javax.baja.bacnet.enums.lighting.BBacnetLightingTransition;
import javax.baja.bacnet.enums.security.BBacnetSecurityLevel;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="choice", type="int", defaultValue="0", flags=4)
public final class BBacnetPropertyStates
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property choice = BBacnetPropertyStates.newProperty((int)4, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetPropertyStates.class);
    private static final int MAX_TAG = 254;
    public static final int BOOLEAN_VALUE_TAG = 0;
    public static final int BINARY_VALUE_TAG = 1;
    public static final int EVENT_TYPE_TAG = 2;
    public static final int POLARITY_TAG = 3;
    public static final int PROGRAM_CHANGE_TAG = 4;
    public static final int PROGRAM_STATE_TAG = 5;
    public static final int REASON_FOR_HALT_TAG = 6;
    public static final int RELIABILITY_TAG = 7;
    public static final int STATE_TAG = 8;
    public static final int SYSTEM_STATUS_TAG = 9;
    public static final int UNITS_TAG = 10;
    public static final int UNSIGNED_VALUE_TAG = 11;
    public static final int LIFE_SAFETY_MODE_TAG = 12;
    public static final int LIFE_SAFETY_STATE_TAG = 13;
    public static final int RESTART_REASON_TAG = 14;
    public static final int DOOR_ALARM_TAG = 15;
    public static final int ACTION_TAG = 16;
    public static final int DOOR_SECURED_STATUS_TAG = 17;
    public static final int DOOR_STATUS_TAG = 18;
    public static final int DOOR_VALUE_TAG = 19;
    public static final int FILE_ACCESS_METHOD_TAG = 20;
    public static final int LOCK_STATUS_TAG = 21;
    public static final int LIFE_SAFETY_OPERATION_TAG = 22;
    public static final int MAINTENANCE_TAG = 23;
    public static final int NODE_TYPE_TAG = 24;
    public static final int NOTIFY_TYPE_TAG = 25;
    public static final int SECURITY_LEVEL_TAG = 26;
    public static final int SHED_STATE_TAG = 27;
    public static final int SILENCED_STATE_TAG = 28;
    public static final int RESERVED29_TAG = 29;
    public static final int ACCESS_EVENT_TAG = 30;
    public static final int ZONE_OCCUPANCY_TAG = 31;
    public static final int ACCESS_CREDENTIAL_DISABLE_REASON_TAG = 32;
    public static final int ACCESS_CREDENTIAL_DISABLE_TAG = 33;
    public static final int AUTHENTICATION_STATUS_TAG = 34;
    public static final int BACKUP_STATE_TAG = 36;
    public static final int WRITE_STATUS_TAG = 37;
    public static final int LIGHTING_IN_PROGRESS_TAG = 38;
    public static final int LIGHTING_OPERATION_TAG = 39;
    public static final int LIGHTING_TRANSITION_TAG = 40;
    public static final int INTEGER_VALUE_TAG = 41;
    public static final int BINARY_LIGHTING_VALUE = 42;
    private static final int MAX_DEFINED_CHOICE = 42;
    public static final String BOOLEAN_VALUE_SLOT_NAME = "booleanValue";
    public static final String BINARY_VALUE_SLOT_NAME = "binaryValue";
    public static final String UNSIGNED_VALUE_SLOT_NAME = "unsignedValue";
    public static final String INTEGER_VALUE_SLOT_NAME = "integerValue";
    private static final String ASHRAE_SLOT_NAME = "ashrae";
    private static final String PROPRIETARY_SLOT_NAME = "proprietary";
    private static final int MAX_ASHRAE_CHOICE = 63;
    private static final int MAX_CHOICE = 42949;
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static final Map<Integer, ChoiceInfo> choiceToInfoMap = BBacnetPropertyStates.makeChoiceInfoMap();
    private static final Map<BTypeSpec, Integer> typeToChoiceMap = BBacnetPropertyStates.makeTypeToChoiceMap();
    private static final BEnumRange choiceRange = BBacnetPropertyStates.makeChoiceRange();

    @Generated
    public int getChoice() {
        return this.getInt(choice);
    }

    @Generated
    public void setChoice(int v) {
        this.setInt(choice, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BBacnetPropertyStates makeBoolean(boolean value) {
        BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
        propertyStates.setChoice(0);
        propertyStates.add(BOOLEAN_VALUE_SLOT_NAME, (BValue)BBoolean.make((boolean)value));
        return propertyStates;
    }

    public static BBacnetPropertyStates makeBinaryPv(boolean value) {
        BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
        propertyStates.setChoice(1);
        propertyStates.add(BINARY_VALUE_SLOT_NAME, (BValue)BBacnetBinaryPv.make(value));
        return propertyStates;
    }

    public static BBacnetPropertyStates makeUnsigned(long value) {
        BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
        propertyStates.setChoice(11);
        propertyStates.add(UNSIGNED_VALUE_SLOT_NAME, (BValue)BBacnetUnsigned.make(value));
        return propertyStates;
    }

    public static BBacnetPropertyStates makeInteger(int value) {
        BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
        propertyStates.setChoice(41);
        propertyStates.add(INTEGER_VALUE_SLOT_NAME, (BValue)BInteger.make((int)value));
        return propertyStates;
    }

    public static BBacnetPropertyStates makeEnum(BTypeSpec typeSpec, int ordinal) {
        BValue value;
        Integer choice = typeToChoiceMap.get(typeSpec);
        if (choice == null) {
            throw new IllegalStateException("BACnetPropertyStates enum type is not supported: " + typeSpec);
        }
        try {
            value = BBacnetPropertyStates.makeEnumValue(choice, ordinal);
        }
        catch (OutOfRangeException e) {
            throw new IllegalStateException("BACnetPropertyStates enum type is not supported: " + typeSpec, (Throwable)((Object)e));
        }
        BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
        propertyStates.setChoice(choice);
        propertyStates.add(BBacnetPropertyStates.getSlotName(choice), value);
        return propertyStates;
    }

    public static BBacnetPropertyStates makeEnum(BEnum enumValue) {
        return BBacnetPropertyStates.makeEnum(enumValue.getType().getTypeSpec(), enumValue.getOrdinal());
    }

    public void started() throws Exception {
        super.started();
        int choice = this.getChoice();
        String valueSlotName = BBacnetPropertyStates.getSlotName(choice);
        if (valueSlotName != null && this.get(valueSlotName) == null) {
            this.add(valueSlotName, BBacnetPropertyStates.getDefaultValue(choice));
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent != null) {
            parent.asComponent().changed(this.getPropertyInParent(), cx);
        }
    }

    public void subscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
        if (vp != null) {
            vp.childSubscribed(this);
        }
    }

    public void unsubscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
        if (vp != null) {
            vp.childUnsubscribed(this);
        }
    }

    public BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public BPermissions getPermissions(Context cx) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(cx);
        }
        return super.getPermissions(cx);
    }

    public String toString(Context cx) {
        String slotName = BBacnetPropertyStates.getSlotName(this.getChoice());
        return slotName != null ? lex.getText("BacnetPropertyStates." + slotName) + ':' + this.get(slotName) : lex.getText("BacnetPropertyStates.invalid");
    }

    @Override
    public void writeAsn(AsnOutput out) {
        int choice = this.getChoice();
        if (choice < 0) {
            throw new IllegalStateException("Invalid BACnetPropertyStates choice: " + choice);
        }
        if (choice == 63) {
            throw new IllegalStateException("Choice value 63 reserved to extend support for tag number greater than 254");
        }
        if (choice > 42949) {
            throw new IllegalStateException("BACnetPropertyStates choice " + choice + " is too large to be encoded by ASN; choice should be less than " + 42949);
        }
        if (choice <= 42) {
            switch (choice) {
                case 0: {
                    out.writeBoolean(0, (BBoolean)this.get(BOOLEAN_VALUE_SLOT_NAME));
                    break;
                }
                case 11: {
                    out.writeUnsigned(11, (BBacnetUnsigned)this.get(UNSIGNED_VALUE_SLOT_NAME));
                    break;
                }
                case 41: {
                    out.writeSignedInteger(41, (BInteger)this.get(INTEGER_VALUE_SLOT_NAME));
                    break;
                }
                case 29: 
                case 35: {
                    out.writeEnumerated(choice, ((BBacnetUnsigned)this.get(ASHRAE_SLOT_NAME)).getInt());
                    break;
                }
                default: {
                    BValue value;
                    String slotName = BBacnetPropertyStates.getSlotName(choice);
                    BValue bValue = value = slotName != null ? this.get(slotName) : null;
                    if (value != null) {
                        out.writeEnumerated(choice, (BEnum)value);
                        break;
                    }
                    throw new IllegalStateException("Invalid enum value for the BACnetPropertyStates choice " + choice);
                }
            }
        } else if (choice < 63) {
            out.writeEnumerated(choice, ((BBacnetUnsigned)this.get(ASHRAE_SLOT_NAME)).getInt());
        } else if (choice <= 254) {
            out.writeEnumerated(choice, ((BBacnetUnsigned)this.get(PROPRIETARY_SLOT_NAME)).getInt());
        } else {
            long value = ((BBacnetUnsigned)this.get(ASHRAE_SLOT_NAME)).getLong();
            long extendedValue = (long)choice * 100000L + value;
            out.writeUnsignedInteger(63, extendedValue);
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        BBacnetUnsigned value;
        String slotName;
        int tag = in.peekTag();
        if (tag < 0 || tag > 254) {
            throw new AsnException("Invalid tag: " + tag);
        }
        int choice = tag;
        if (tag <= 42) {
            slotName = BBacnetPropertyStates.getSlotName(tag);
            switch (tag) {
                case 0: {
                    value = BBoolean.make((boolean)in.readBoolean(0));
                    break;
                }
                case 11: {
                    value = in.readUnsigned(11);
                    break;
                }
                case 41: {
                    value = in.readSigned(41);
                    break;
                }
                case 29: 
                case 35: {
                    value = BBacnetUnsigned.make(in.readEnumerated(tag));
                    break;
                }
                default: {
                    value = BBacnetPropertyStates.makeEnumValue(tag, in.readEnumerated(tag));
                    break;
                }
            }
        } else if (tag < 63) {
            slotName = ASHRAE_SLOT_NAME;
            value = BBacnetUnsigned.make(in.readEnumerated(tag));
        } else if (tag == 63) {
            long extendedValue = in.readUnsignedInteger(63);
            if (extendedValue < 25500000L) {
                throw new OutOfRangeException("Extended choice values must be at least 255; value: " + extendedValue);
            }
            long extendedChoice = extendedValue / 100000L;
            if (extendedChoice > 42949L) {
                throw new OutOfRangeException("Extended choice value greater than 42949 are not supported: " + extendedChoice);
            }
            choice = (int)extendedChoice;
            slotName = ASHRAE_SLOT_NAME;
            value = BBacnetUnsigned.make(extendedValue - extendedChoice * 100000L);
        } else {
            slotName = PROPRIETARY_SLOT_NAME;
            value = BBacnetUnsigned.make(in.readEnumerated(tag));
        }
        this.removeAll(noWrite);
        this.setInt(BBacnetPropertyStates.choice, choice, noWrite);
        this.add(slotName, (BValue)value, noWrite);
    }

    private static BValue makeEnumValue(int tag, int ordinal) throws OutOfRangeException {
        switch (tag) {
            case 1: {
                return BBacnetBinaryPv.make(ordinal);
            }
            case 2: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetEventType.DEFAULT);
            }
            case 3: {
                return BBacnetPolarity.make(ordinal);
            }
            case 4: {
                return BBacnetProgramRequest.make(ordinal);
            }
            case 5: {
                return BBacnetProgramState.make(ordinal);
            }
            case 6: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetProgramError.DEFAULT);
            }
            case 7: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetReliability.DEFAULT);
            }
            case 8: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetEventState.DEFAULT);
            }
            case 9: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetDeviceStatus.DEFAULT);
            }
            case 10: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetEngineeringUnits.DEFAULT);
            }
            case 12: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetLifeSafetyMode.DEFAULT);
            }
            case 13: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetLifeSafetyState.DEFAULT);
            }
            case 14: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetRestartReason.DEFAULT);
            }
            case 15: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetDoorAlarmState.DEFAULT);
            }
            case 16: {
                return BBacnetAction.make(ordinal);
            }
            case 17: {
                return BBacnetDoorSecuredStatus.make(ordinal);
            }
            case 18: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetDoorStatus.DEFAULT);
            }
            case 19: {
                return BBacnetDoorValue.make(ordinal);
            }
            case 20: {
                return BBacnetFileAccessMethod.make(ordinal);
            }
            case 21: {
                return BBacnetLockStatus.make(ordinal);
            }
            case 22: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetLifeSafetyOperation.DEFAULT);
            }
            case 23: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetMaintenance.DEFAULT);
            }
            case 24: {
                return BBacnetNodeType.make(ordinal);
            }
            case 25: {
                return BBacnetNotifyType.make(ordinal);
            }
            case 26: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetSecurityLevel.DEFAULT);
            }
            case 27: {
                return BBacnetShedState.make(ordinal);
            }
            case 28: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetSilencedState.DEFAULT);
            }
            case 30: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetAccessEvent.DEFAULT);
            }
            case 31: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetAccessZoneOccupancyState.DEFAULT);
            }
            case 32: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetAccessCredentialDisableReason.DEFAULT);
            }
            case 33: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetAccessCredentialDisable.DEFAULT);
            }
            case 34: {
                return BBacnetAuthenticationStatus.make(ordinal);
            }
            case 36: {
                return BBacnetBackupState.make(ordinal);
            }
            case 37: {
                return BBacnetWriteStatus.make(ordinal);
            }
            case 38: {
                return BBacnetLightingInProgress.make(ordinal);
            }
            case 39: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetLightingOperation.DEFAULT);
            }
            case 40: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetLightingTransition.DEFAULT);
            }
            case 42: {
                return BBacnetPropertyStates.makeDynamicEnum(ordinal, BBacnetBinaryLightingPv.DEFAULT);
            }
        }
        throw new OutOfRangeException("Enum choice value not supported: " + tag);
    }

    private static BDynamicEnum makeDynamicEnum(int ordinal, BFrozenEnum enumDefault) {
        return BDynamicEnum.make((int)ordinal, (BEnumRange)enumDefault.getRange());
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetPropertyStates", 2);
        out.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        out.endProps();
    }

    public BValue getValue() {
        String slotName = BBacnetPropertyStates.getSlotName(this.getChoice());
        return slotName != null ? this.get(slotName) : null;
    }

    private static Map<Integer, ChoiceInfo> makeChoiceInfoMap() {
        LinkedHashMap<Integer, ChoiceInfo> map = new LinkedHashMap<Integer, ChoiceInfo>();
        BBacnetPropertyStates.putChoiceInfo(map, 0, BOOLEAN_VALUE_SLOT_NAME, (BValue)BBoolean.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 1, BINARY_VALUE_SLOT_NAME, (BValue)BBacnetBinaryPv.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 2, "eventType", (BValue)BDynamicEnum.make((BEnum)BBacnetEventType.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 3, "polarity", (BValue)BBacnetPolarity.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 4, "programChange", (BValue)BBacnetProgramRequest.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 5, "programState", (BValue)BBacnetProgramState.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 6, "reasonForHalt", (BValue)BDynamicEnum.make((BEnum)BBacnetProgramError.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 7, "reliability", (BValue)BDynamicEnum.make((BEnum)BBacnetReliability.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 8, "state", (BValue)BDynamicEnum.make((BEnum)BBacnetEventState.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 9, "systemStatus", (BValue)BDynamicEnum.make((BEnum)BBacnetDeviceStatus.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 10, "units", (BValue)BDynamicEnum.make((BEnum)BBacnetEngineeringUnits.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 11, UNSIGNED_VALUE_SLOT_NAME, (BValue)BBacnetUnsigned.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 12, "lifeSafetyMode", (BValue)BDynamicEnum.make((BEnum)BBacnetLifeSafetyMode.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 13, "lifeSafetyState", (BValue)BDynamicEnum.make((BEnum)BBacnetLifeSafetyState.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 14, "restartReason", (BValue)BDynamicEnum.make((BEnum)BBacnetRestartReason.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 15, "doorAlarmState", (BValue)BDynamicEnum.make((BEnum)BBacnetDoorAlarmState.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 16, "action", (BValue)BBacnetAction.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 17, "doorSecuredStatus", (BValue)BBacnetDoorSecuredStatus.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 18, "doorStatus", (BValue)BDynamicEnum.make((BEnum)BBacnetDoorStatus.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 19, "doorValue", (BValue)BBacnetDoorValue.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 20, "fileAccessMethod", (BValue)BBacnetFileAccessMethod.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 21, "lockStatus", (BValue)BBacnetLockStatus.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 22, "lifeSafetyOperation", (BValue)BDynamicEnum.make((BEnum)BBacnetLifeSafetyOperation.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 23, "maintenance", (BValue)BDynamicEnum.make((BEnum)BBacnetMaintenance.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 24, "nodeType", (BValue)BBacnetNodeType.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 25, "notifyType", (BValue)BBacnetNotifyType.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 26, "securityLevel", (BValue)BDynamicEnum.make((BEnum)BBacnetSecurityLevel.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 27, "shedState", (BValue)BBacnetShedState.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 28, "silencedState", (BValue)BDynamicEnum.make((BEnum)BBacnetSilencedState.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 30, "accessEvent", (BValue)BDynamicEnum.make((BEnum)BBacnetAccessEvent.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 31, "zoneOccupancyState", (BValue)BDynamicEnum.make((BEnum)BBacnetAccessZoneOccupancyState.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 32, "accessCredentialDisableReason", (BValue)BDynamicEnum.make((BEnum)BBacnetAccessCredentialDisableReason.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 33, "accessCredentialDisable", (BValue)BDynamicEnum.make((BEnum)BBacnetAccessCredentialDisable.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 34, "authenticationStatus", (BValue)BBacnetAuthenticationStatus.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 36, "backupState", (BValue)BBacnetBackupState.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 37, "writeStatus", (BValue)BBacnetWriteStatus.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 38, "lightingInProgress", (BValue)BBacnetLightingInProgress.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 39, "lightingOperation", (BValue)BDynamicEnum.make((BEnum)BBacnetLightingOperation.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 40, "lightingTransition", (BValue)BDynamicEnum.make((BEnum)BBacnetLightingTransition.DEFAULT));
        BBacnetPropertyStates.putChoiceInfo(map, 41, INTEGER_VALUE_SLOT_NAME, (BValue)BInteger.DEFAULT);
        BBacnetPropertyStates.putChoiceInfo(map, 42, "binaryLightingValue", (BValue)BDynamicEnum.make((BEnum)BBacnetBinaryLightingPv.DEFAULT));
        return map;
    }

    private static void putChoiceInfo(Map<Integer, ChoiceInfo> map, int choice, String slotName, BValue defaultValue) {
        map.put(choice, new ChoiceInfo(slotName, defaultValue));
    }

    private static Map<BTypeSpec, Integer> makeTypeToChoiceMap() {
        HashMap<BTypeSpec, Integer> map = new HashMap<BTypeSpec, Integer>();
        for (Map.Entry<Integer, ChoiceInfo> entry : choiceToInfoMap.entrySet()) {
            BValue defaultValue = entry.getValue().defaultValue;
            if (defaultValue instanceof BDynamicEnum) {
                Type frozenType = ((BDynamicEnum)defaultValue).getRange().getFrozenType();
                map.put(frozenType.getTypeSpec(), entry.getKey());
                continue;
            }
            map.put(defaultValue.getType().getTypeSpec(), entry.getKey());
        }
        return map;
    }

    private static BEnumRange makeChoiceRange() {
        ArrayList<Map.Entry<Integer, ChoiceInfo>> entries = new ArrayList<Map.Entry<Integer, ChoiceInfo>>(choiceToInfoMap.entrySet());
        int size = entries.size();
        int[] ordinals = new int[size];
        String[] tags = new String[size];
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            ordinals[i] = (Integer)entry.getKey();
            tags[i] = SlotPath.escape((String)("BacnetPropertyStates." + ((ChoiceInfo)entry.getValue()).slotName));
        }
        BFacets options = BFacets.make((String)"lexicon", (String)"bacnet");
        return BEnumRange.make(null, (int[])ordinals, (String[])tags, (int)size, (BFacets)options);
    }

    public static BEnumRange getChoiceRange() {
        return choiceRange;
    }

    public static String getSlotName(int choice) {
        if (choice < 0 || choice == 63 || choice > 42949) {
            return null;
        }
        if (choice == 29 || choice == 35) {
            return ASHRAE_SLOT_NAME;
        }
        if (choice <= 42) {
            ChoiceInfo choiceInfo = choiceToInfoMap.get(choice);
            return choiceInfo != null ? choiceInfo.slotName : null;
        }
        if (choice < 63 || choice > 254) {
            return ASHRAE_SLOT_NAME;
        }
        return PROPRIETARY_SLOT_NAME;
    }

    public static BValue getDefaultValue(int choice) {
        if (choice < 0 || choice == 63 || choice > 42949) {
            return null;
        }
        if (choice == 29 || choice == 35) {
            return BBacnetUnsigned.DEFAULT;
        }
        if (choice <= 42) {
            ChoiceInfo choiceInfo = choiceToInfoMap.get(choice);
            return choiceInfo != null ? choiceInfo.defaultValue : null;
        }
        return BBacnetUnsigned.DEFAULT;
    }

    private static class ChoiceInfo {
        public final String slotName;
        public final BValue defaultValue;

        public ChoiceInfo(String slotName, BValue defaultValue) {
            this.slotName = slotName;
            this.defaultValue = defaultValue;
        }
    }
}

