/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="isNull", type="boolean", defaultValue="true"), @NiagaraProperty(name="processIdentifier", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.make(0)")})
public final class BBacnetProcessIdSelection
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property isNull = BBacnetProcessIdSelection.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property processIdentifier = BBacnetProcessIdSelection.newProperty((int)0, (BValue)BBacnetUnsigned.make(0L), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetProcessIdSelection.class);

    @Generated
    public boolean getIsNull() {
        return this.getBoolean(isNull);
    }

    @Generated
    public void setIsNull(boolean v) {
        this.setBoolean(isNull, v, null);
    }

    @Generated
    public BBacnetUnsigned getProcessIdentifier() {
        return (BBacnetUnsigned)this.get(processIdentifier);
    }

    @Generated
    public void setProcessIdentifier(BBacnetUnsigned v) {
        this.set(processIdentifier, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetProcessIdSelection() {
    }

    public BBacnetProcessIdSelection(BBacnetUnsigned processIdentifier) {
        this.setIsNull(false);
        this.setProcessIdentifier(processIdentifier);
    }

    public boolean isNull() {
        return this.getIsNull();
    }

    @Override
    public void writeAsn(AsnOutput out) {
        if (this.getIsNull()) {
            out.writeNull();
        } else {
            long processIdentifier = this.getProcessIdentifier().getLong();
            if (processIdentifier < 0L || processIdentifier > 0xFFFFFFFFL) {
                throw new IllegalStateException("BACnetProcessIdSelection.processIdentifier must be between zero and max Unsigned32 (inclusive); actual: " + processIdentifier);
            }
            out.writeUnsigned(this.getProcessIdentifier());
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int tag = in.peekTag();
        switch (tag) {
            case 0: {
                in.readNull();
                this.setBoolean(isNull, true, noWrite);
                break;
            }
            case 2: {
                BBacnetUnsigned processIdentifier = in.readUnsigned();
                if (processIdentifier.getLong() > 0xFFFFFFFFL) {
                    throw new OutOfRangeException("BACnetProcessIdSelection.processIdentifier must be less than or equal to max Unsigned32; actual: " + processIdentifier.getLong());
                }
                this.setBoolean(isNull, false, noWrite);
                this.set(BBacnetProcessIdSelection.processIdentifier, (BValue)processIdentifier, noWrite);
                break;
            }
            default: {
                throw new AsnException("Invalid tag: " + tag);
            }
        }
    }

    public String toString(Context context) {
        StringBuilder builder = new StringBuilder("processId: ");
        if (this.getIsNull()) {
            builder.append("null");
        } else {
            builder.append(this.getProcessIdentifier().getInt());
        }
        return builder.toString();
    }
}

