/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="portId", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.DEFAULT"), @NiagaraProperty(name="enabled", type="boolean", defaultValue="false")})
public final class BBacnetPortPermission
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property portId = BBacnetPortPermission.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, null);
    @Generated
    public static final Property enabled = BBacnetPortPermission.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetPortPermission.class);

    @Generated
    public BBacnetUnsigned getPortId() {
        return (BBacnetUnsigned)this.get(portId);
    }

    @Generated
    public void setPortId(BBacnetUnsigned v) {
        this.set(portId, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        long portId = this.getPortId().getLong();
        if (portId < 0L || portId > 255L) {
            throw new IllegalStateException("BACnetPortPermission.portId must be between zero and max Unsigned8 (inclusive); actual: " + portId);
        }
        out.writeUnsignedInteger(0, portId);
        out.writeBoolean(1, this.getEnabled());
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        BBacnetUnsigned portId = in.readUnsigned(0);
        if (portId.getLong() > 255L) {
            throw new OutOfRangeException("BACnetPortPermission.portId must be less than or equal to max Unsigned8; actual: " + portId.getLong());
        }
        boolean enabled = in.readBoolean(1);
        this.set(BBacnetPortPermission.portId, (BValue)portId, noWrite);
        this.setBoolean(BBacnetPortPermission.enabled, enabled, noWrite);
    }

    public String toString(Context context) {
        return "port: " + (Object)((Object)this.getPortId()) + ", enabled? " + this.getEnabled();
    }
}

